/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractActorrole {
    PRACTITIONER,
    PATIENT,
    NULL;


    public static ContractActorrole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        throw new FHIRException("Unknown ContractActorrole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRACTITIONER: {
                return "practitioner";
            }
            case PATIENT: {
                return "patient";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://www.hl7.org/fhir/contractactorrole";
    }

    public String getDefinition() {
        switch (this) {
            case PRACTITIONER: {
                return "";
            }
            case PATIENT: {
                return "";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRACTITIONER: {
                return "Practitioner";
            }
            case PATIENT: {
                return "Patient";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

