/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CodesystemContentMode {
    NOTPRESENT,
    EXAMPLAR,
    FRAGMENT,
    COMPLETE,
    NULL;


    public static CodesystemContentMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-present".equals(codeString)) {
            return NOTPRESENT;
        }
        if ("examplar".equals(codeString)) {
            return EXAMPLAR;
        }
        if ("fragment".equals(codeString)) {
            return FRAGMENT;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        throw new FHIRException("Unknown CodesystemContentMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTPRESENT: {
                return "not-present";
            }
            case EXAMPLAR: {
                return "examplar";
            }
            case FRAGMENT: {
                return "fragment";
            }
            case COMPLETE: {
                return "complete";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/codesystem-content-mode";
    }

    public String getDefinition() {
        switch (this) {
            case NOTPRESENT: {
                return "None of the concepts defined by the code system are included in the code system resource";
            }
            case EXAMPLAR: {
                return "A few representative concepts are included in the code system resource";
            }
            case FRAGMENT: {
                return "A subset of the code system concepts are included in the code system resource";
            }
            case COMPLETE: {
                return "All the concepts defined by the code system are included in the code system resource";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTPRESENT: {
                return "Not Present";
            }
            case EXAMPLAR: {
                return "Examplar";
            }
            case FRAGMENT: {
                return "Fragment";
            }
            case COMPLETE: {
                return "Complete";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

