/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.ParameterDefinition;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.TriggerDefinition;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="DecisionSupportServiceModule", profile="http://hl7.org/fhir/Profile/DecisionSupportServiceModule")
public class DecisionSupportServiceModule
extends DomainResource {
    @Child(name="moduleMetadata", type={ModuleMetadata.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Metadata for the service module", formalDefinition="The metadata for the decision support service module, including publishing, life-cycle, version, documentation, and supporting evidence.")
    protected ModuleMetadata moduleMetadata;
    @Child(name="trigger", type={TriggerDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="\"when\" the module should be invoked", formalDefinition="The trigger element defines when the rule should be invoked. This information is used by consumers of the rule to determine how to integrate the rule into a specific workflow.")
    protected List<TriggerDefinition> trigger;
    @Child(name="parameter", type={ParameterDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Parameters to the module", formalDefinition="The parameters to the module. This collection specifies both the input and output parameters. Input parameters are provided by the caller as part of the $evaluate operation. Output parameters are included in the GuidanceResponse.")
    protected List<ParameterDefinition> parameter;
    @Child(name="dataRequirement", type={DataRequirement.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data requirements for the module", formalDefinition="Data requirements are a machine processable description of the data required by the module in order to perform a successful evaluation.")
    protected List<DataRequirement> dataRequirement;
    private static final long serialVersionUID = 1154664442L;
    @SearchParamDefinition(name="topic", path="DecisionSupportServiceModule.moduleMetadata.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="title", path="DecisionSupportServiceModule.moduleMetadata.title", description="Text search against the title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="DecisionSupportServiceModule.moduleMetadata.status", description="Status of the module", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="DecisionSupportServiceModule.moduleMetadata.description", description="Text search against the description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="DecisionSupportServiceModule.moduleMetadata.identifier", description="Logical identifier for the module (e.g. CMS-143)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="DecisionSupportServiceModule.moduleMetadata.version", description="Version of the module (e.g. 1.0.0)", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public ModuleMetadata getModuleMetadata() {
        if (this.moduleMetadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DecisionSupportServiceModule.moduleMetadata");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleMetadata = new ModuleMetadata();
            }
        }
        return this.moduleMetadata;
    }

    public boolean hasModuleMetadata() {
        return this.moduleMetadata != null && !this.moduleMetadata.isEmpty();
    }

    public DecisionSupportServiceModule setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
        return this;
    }

    public List<TriggerDefinition> getTrigger() {
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        return this.trigger;
    }

    public boolean hasTrigger() {
        if (this.trigger == null) {
            return false;
        }
        for (TriggerDefinition item : this.trigger) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TriggerDefinition addTrigger() {
        TriggerDefinition t = new TriggerDefinition();
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        this.trigger.add(t);
        return t;
    }

    public DecisionSupportServiceModule addTrigger(TriggerDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        this.trigger.add(t);
        return this;
    }

    public List<ParameterDefinition> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        return this.parameter;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ParameterDefinition item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParameterDefinition addParameter() {
        ParameterDefinition t = new ParameterDefinition();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        this.parameter.add(t);
        return t;
    }

    public DecisionSupportServiceModule addParameter(ParameterDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        this.parameter.add(t);
        return this;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public boolean hasDataRequirement() {
        if (this.dataRequirement == null) {
            return false;
        }
        for (DataRequirement item : this.dataRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirement addDataRequirement() {
        DataRequirement t = new DataRequirement();
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return t;
    }

    public DecisionSupportServiceModule addDataRequirement(DataRequirement t) {
        if (t == null) {
            return this;
        }
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("moduleMetadata", "ModuleMetadata", "The metadata for the decision support service module, including publishing, life-cycle, version, documentation, and supporting evidence.", 0, Integer.MAX_VALUE, this.moduleMetadata));
        childrenList.add(new Property("trigger", "TriggerDefinition", "The trigger element defines when the rule should be invoked. This information is used by consumers of the rule to determine how to integrate the rule into a specific workflow.", 0, Integer.MAX_VALUE, this.trigger));
        childrenList.add(new Property("parameter", "ParameterDefinition", "The parameters to the module. This collection specifies both the input and output parameters. Input parameters are provided by the caller as part of the $evaluate operation. Output parameters are included in the GuidanceResponse.", 0, Integer.MAX_VALUE, this.parameter));
        childrenList.add(new Property("dataRequirement", "DataRequirement", "Data requirements are a machine processable description of the data required by the module in order to perform a successful evaluation.", 0, Integer.MAX_VALUE, this.dataRequirement));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 455891387: {
                Base[] baseArray;
                if (this.moduleMetadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.moduleMetadata;
                }
                return baseArray;
            }
            case -1059891784: {
                return this.trigger == null ? new Base[]{} : this.trigger.toArray(new Base[this.trigger.size()]);
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 629147193: {
                return this.dataRequirement == null ? new Base[]{} : this.dataRequirement.toArray(new Base[this.dataRequirement.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 455891387: {
                this.moduleMetadata = this.castToModuleMetadata(value);
                break;
            }
            case -1059891784: {
                this.getTrigger().add(this.castToTriggerDefinition(value));
                break;
            }
            case 1954460585: {
                this.getParameter().add(this.castToParameterDefinition(value));
                break;
            }
            case 629147193: {
                this.getDataRequirement().add(this.castToDataRequirement(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = this.castToModuleMetadata(value);
        } else if (name.equals("trigger")) {
            this.getTrigger().add(this.castToTriggerDefinition(value));
        } else if (name.equals("parameter")) {
            this.getParameter().add(this.castToParameterDefinition(value));
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().add(this.castToDataRequirement(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 455891387: {
                return this.getModuleMetadata();
            }
            case -1059891784: {
                return this.addTrigger();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case 629147193: {
                return this.addDataRequirement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = new ModuleMetadata();
            return this.moduleMetadata;
        }
        if (name.equals("trigger")) {
            return this.addTrigger();
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("dataRequirement")) {
            return this.addDataRequirement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DecisionSupportServiceModule";
    }

    @Override
    public DecisionSupportServiceModule copy() {
        DecisionSupportServiceModule dst = new DecisionSupportServiceModule();
        this.copyValues(dst);
        ModuleMetadata moduleMetadata = dst.moduleMetadata = this.moduleMetadata == null ? null : this.moduleMetadata.copy();
        if (this.trigger != null) {
            dst.trigger = new ArrayList<TriggerDefinition>();
            for (TriggerDefinition triggerDefinition : this.trigger) {
                dst.trigger.add(triggerDefinition.copy());
            }
        }
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ParameterDefinition>();
            for (ParameterDefinition parameterDefinition : this.parameter) {
                dst.parameter.add(parameterDefinition.copy());
            }
        }
        if (this.dataRequirement != null) {
            dst.dataRequirement = new ArrayList<DataRequirement>();
            for (DataRequirement dataRequirement : this.dataRequirement) {
                dst.dataRequirement.add(dataRequirement.copy());
            }
        }
        return dst;
    }

    protected DecisionSupportServiceModule typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DecisionSupportServiceModule)) {
            return false;
        }
        DecisionSupportServiceModule o = (DecisionSupportServiceModule)other;
        return DecisionSupportServiceModule.compareDeep(this.moduleMetadata, o.moduleMetadata, true) && DecisionSupportServiceModule.compareDeep(this.trigger, o.trigger, true) && DecisionSupportServiceModule.compareDeep(this.parameter, o.parameter, true) && DecisionSupportServiceModule.compareDeep(this.dataRequirement, o.dataRequirement, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DecisionSupportServiceModule)) {
            return false;
        }
        DecisionSupportServiceModule o = (DecisionSupportServiceModule)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.moduleMetadata != null && !this.moduleMetadata.isEmpty() || this.trigger != null && !this.trigger.isEmpty() || this.parameter != null && !this.parameter.isEmpty() || this.dataRequirement != null && !this.dataRequirement.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DecisionSupportServiceModule;
    }
}

