/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NutritionOrderStatus {
    PROPOSED,
    DRAFT,
    PLANNED,
    REQUESTED,
    ACTIVE,
    ONHOLD,
    COMPLETED,
    CANCELLED,
    ENTEREDINERROR,
    NULL;


    public static NutritionOrderStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("requested".equals(codeString)) {
            return REQUESTED;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown NutritionOrderStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSED: {
                return "proposed";
            }
            case DRAFT: {
                return "draft";
            }
            case PLANNED: {
                return "planned";
            }
            case REQUESTED: {
                return "requested";
            }
            case ACTIVE: {
                return "active";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nutrition-order-status";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSED: {
                return "The request has been proposed.";
            }
            case DRAFT: {
                return "The request is in preliminary form prior to being sent.";
            }
            case PLANNED: {
                return "The request has been planned.";
            }
            case REQUESTED: {
                return "The request has been placed.";
            }
            case ACTIVE: {
                return "The request is 'actionable', but not all actions that are implied by it have occurred yet.";
            }
            case ONHOLD: {
                return "Actions implied by the request have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
            }
            case COMPLETED: {
                return "All actions that are implied by the order have occurred and no continuation is planned (this will rarely be made explicit).";
            }
            case CANCELLED: {
                return "The request has been withdrawn and is no longer actionable.";
            }
            case ENTEREDINERROR: {
                return "The request was entered in error and voided.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSED: {
                return "Proposed";
            }
            case DRAFT: {
                return "Draft";
            }
            case PLANNED: {
                return "Planned";
            }
            case REQUESTED: {
                return "Requested";
            }
            case ACTIVE: {
                return "Active";
            }
            case ONHOLD: {
                return "On-Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

