/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaCrcOperationType {
    OTHERPROCEDURES,
    NULL;


    public static NehtaNehtaCrcOperationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("other_procedures".equals(codeString)) {
            return OTHERPROCEDURES;
        }
        throw new FHIRException("Unknown NehtaNehtaCrcOperationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OTHERPROCEDURES: {
                return "other_procedures";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-crc-operation-type";
    }

    public String getDefinition() {
        switch (this) {
            case OTHERPROCEDURES: {
                return "Indicates whether other procedure(s) were undertaken";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OTHERPROCEDURES: {
                return "Other procedure(s)";
            }
        }
        return "?";
    }
}

