/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasurementPrinciple {
    OTHER,
    CHEMICAL,
    ELECTRICAL,
    IMPEDANCE,
    NUCLEAR,
    OPTICAL,
    THERMAL,
    BIOLOGICAL,
    MECHANICAL,
    ACOUSTICAL,
    MANUAL,
    NULL;


    public static MeasurementPrinciple fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        if ("chemical".equals(codeString)) {
            return CHEMICAL;
        }
        if ("electrical".equals(codeString)) {
            return ELECTRICAL;
        }
        if ("impedance".equals(codeString)) {
            return IMPEDANCE;
        }
        if ("nuclear".equals(codeString)) {
            return NUCLEAR;
        }
        if ("optical".equals(codeString)) {
            return OPTICAL;
        }
        if ("thermal".equals(codeString)) {
            return THERMAL;
        }
        if ("biological".equals(codeString)) {
            return BIOLOGICAL;
        }
        if ("mechanical".equals(codeString)) {
            return MECHANICAL;
        }
        if ("acoustical".equals(codeString)) {
            return ACOUSTICAL;
        }
        if ("manual".equals(codeString)) {
            return MANUAL;
        }
        throw new FHIRException("Unknown MeasurementPrinciple code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OTHER: {
                return "other";
            }
            case CHEMICAL: {
                return "chemical";
            }
            case ELECTRICAL: {
                return "electrical";
            }
            case IMPEDANCE: {
                return "impedance";
            }
            case NUCLEAR: {
                return "nuclear";
            }
            case OPTICAL: {
                return "optical";
            }
            case THERMAL: {
                return "thermal";
            }
            case BIOLOGICAL: {
                return "biological";
            }
            case MECHANICAL: {
                return "mechanical";
            }
            case ACOUSTICAL: {
                return "acoustical";
            }
            case MANUAL: {
                return "manual";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measurement-principle";
    }

    public String getDefinition() {
        switch (this) {
            case OTHER: {
                return "Measurement principle isn't in the list.";
            }
            case CHEMICAL: {
                return "Measurement is done using the chemical principle.";
            }
            case ELECTRICAL: {
                return "Measurement is done using the electrical principle.";
            }
            case IMPEDANCE: {
                return "Measurement is done using the impedance principle.";
            }
            case NUCLEAR: {
                return "Measurement is done using the nuclear principle.";
            }
            case OPTICAL: {
                return "Measurement is done using the optical principle.";
            }
            case THERMAL: {
                return "Measurement is done using the thermal principle.";
            }
            case BIOLOGICAL: {
                return "Measurement is done using the biological principle.";
            }
            case MECHANICAL: {
                return "Measurement is done using the mechanical principle.";
            }
            case ACOUSTICAL: {
                return "Measurement is done using the acoustical principle.";
            }
            case MANUAL: {
                return "Measurement is done using the manual principle.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OTHER: {
                return "MSP Other";
            }
            case CHEMICAL: {
                return "MSP Chemical";
            }
            case ELECTRICAL: {
                return "MSP Electrical";
            }
            case IMPEDANCE: {
                return "MSP Impedance";
            }
            case NUCLEAR: {
                return "MSP Nuclear";
            }
            case OPTICAL: {
                return "MSP Optical";
            }
            case THERMAL: {
                return "MSP Thermal";
            }
            case BIOLOGICAL: {
                return "MSP Biological";
            }
            case MECHANICAL: {
                return "MSP Mechanical";
            }
            case ACOUSTICAL: {
                return "MSP Acoustical";
            }
            case MANUAL: {
                return "MSP Manual";
            }
        }
        return "?";
    }
}

