/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcTelecomUse {
    NS,
    NULL;


    public static HspcTelecomUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("NS".equals(codeString)) {
            return NS;
        }
        throw new FHIRException("Unknown HspcTelecomUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NS: {
                return "NS";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/telecomUse";
    }

    public String getDefinition() {
        switch (this) {
            case NS: {
                return "The type of telecom system was not specified for the given number.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NS: {
                return "Not specified";
            }
        }
        return "?";
    }
}

