/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubscriptionChannelType {
    RESTHOOK,
    WEBSOCKET,
    EMAIL,
    SMS,
    MESSAGE,
    NULL;


    public static SubscriptionChannelType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("rest-hook".equals(codeString)) {
            return RESTHOOK;
        }
        if ("websocket".equals(codeString)) {
            return WEBSOCKET;
        }
        if ("email".equals(codeString)) {
            return EMAIL;
        }
        if ("sms".equals(codeString)) {
            return SMS;
        }
        if ("message".equals(codeString)) {
            return MESSAGE;
        }
        throw new FHIRException("Unknown SubscriptionChannelType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RESTHOOK: {
                return "rest-hook";
            }
            case WEBSOCKET: {
                return "websocket";
            }
            case EMAIL: {
                return "email";
            }
            case SMS: {
                return "sms";
            }
            case MESSAGE: {
                return "message";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/subscription-channel-type";
    }

    public String getDefinition() {
        switch (this) {
            case RESTHOOK: {
                return "The channel is executed by making a post to the URI. If a payload is included, the URL is interpreted as the service base, and an update (PUT) is made.";
            }
            case WEBSOCKET: {
                return "The channel is executed by sending a packet across a web socket connection maintained by the client. The URL identifies the websocket, and the client binds to this URL.";
            }
            case EMAIL: {
                return "The channel is executed by sending an email to the email addressed in the URI (which must be a mailto:).";
            }
            case SMS: {
                return "The channel is executed by sending an SMS message to the phone number identified in the URL (tel:).";
            }
            case MESSAGE: {
                return "The channel is executed by sending a message (e.g. a Bundle with a MessageHeader resource etc.) to the application identified in the URI.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RESTHOOK: {
                return "Rest Hook";
            }
            case WEBSOCKET: {
                return "Websocket";
            }
            case EMAIL: {
                return "Email";
            }
            case SMS: {
                return "SMS";
            }
            case MESSAGE: {
                return "Message";
            }
        }
        return "?";
    }
}

