/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ProtocolStatus;

public class ProtocolStatusEnumFactory
implements EnumFactory<ProtocolStatus> {
    @Override
    public ProtocolStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return ProtocolStatus.DRAFT;
        }
        if ("testing".equals(codeString)) {
            return ProtocolStatus.TESTING;
        }
        if ("review".equals(codeString)) {
            return ProtocolStatus.REVIEW;
        }
        if ("active".equals(codeString)) {
            return ProtocolStatus.ACTIVE;
        }
        if ("withdrawn".equals(codeString)) {
            return ProtocolStatus.WITHDRAWN;
        }
        if ("superseded".equals(codeString)) {
            return ProtocolStatus.SUPERSEDED;
        }
        throw new IllegalArgumentException("Unknown ProtocolStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(ProtocolStatus code) {
        if (code == ProtocolStatus.DRAFT) {
            return "draft";
        }
        if (code == ProtocolStatus.TESTING) {
            return "testing";
        }
        if (code == ProtocolStatus.REVIEW) {
            return "review";
        }
        if (code == ProtocolStatus.ACTIVE) {
            return "active";
        }
        if (code == ProtocolStatus.WITHDRAWN) {
            return "withdrawn";
        }
        if (code == ProtocolStatus.SUPERSEDED) {
            return "superseded";
        }
        return "?";
    }

    @Override
    public String toSystem(ProtocolStatus code) {
        return code.getSystem();
    }
}

