/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Payeetype {
    SUBSCRIBER,
    PROVIDER,
    OTHER,
    NULL;


    public static Payeetype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("subscriber".equals(codeString)) {
            return SUBSCRIBER;
        }
        if ("provider".equals(codeString)) {
            return PROVIDER;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown Payeetype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUBSCRIBER: {
                return "subscriber";
            }
            case PROVIDER: {
                return "provider";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/payeetype";
    }

    public String getDefinition() {
        switch (this) {
            case SUBSCRIBER: {
                return "The subscriber (policy holder) will be reimbursed.";
            }
            case PROVIDER: {
                return "Any benefit payable will be paid to the provider (Assignment of Benefit).";
            }
            case OTHER: {
                return "Any benefit payable will be paid to a third party such as a guarrantor.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUBSCRIBER: {
                return "Subscriber";
            }
            case PROVIDER: {
                return "Provider";
            }
            case OTHER: {
                return "Provider";
            }
        }
        return "?";
    }
}

