/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AssertResponseCodeTypes {
    OKAY,
    CREATED,
    NOCONTENT,
    NOTMODIFIED,
    BAD,
    FORBIDDEN,
    NOTFOUND,
    METHODNOTALLOWED,
    CONFLICT,
    GONE,
    PRECONDITIONFAILED,
    UNPROCESSABLE,
    NULL;


    public static AssertResponseCodeTypes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("okay".equals(codeString)) {
            return OKAY;
        }
        if ("created".equals(codeString)) {
            return CREATED;
        }
        if ("noContent".equals(codeString)) {
            return NOCONTENT;
        }
        if ("notModified".equals(codeString)) {
            return NOTMODIFIED;
        }
        if ("bad".equals(codeString)) {
            return BAD;
        }
        if ("forbidden".equals(codeString)) {
            return FORBIDDEN;
        }
        if ("notFound".equals(codeString)) {
            return NOTFOUND;
        }
        if ("methodNotAllowed".equals(codeString)) {
            return METHODNOTALLOWED;
        }
        if ("conflict".equals(codeString)) {
            return CONFLICT;
        }
        if ("gone".equals(codeString)) {
            return GONE;
        }
        if ("preconditionFailed".equals(codeString)) {
            return PRECONDITIONFAILED;
        }
        if ("unprocessable".equals(codeString)) {
            return UNPROCESSABLE;
        }
        throw new FHIRException("Unknown AssertResponseCodeTypes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OKAY: {
                return "okay";
            }
            case CREATED: {
                return "created";
            }
            case NOCONTENT: {
                return "noContent";
            }
            case NOTMODIFIED: {
                return "notModified";
            }
            case BAD: {
                return "bad";
            }
            case FORBIDDEN: {
                return "forbidden";
            }
            case NOTFOUND: {
                return "notFound";
            }
            case METHODNOTALLOWED: {
                return "methodNotAllowed";
            }
            case CONFLICT: {
                return "conflict";
            }
            case GONE: {
                return "gone";
            }
            case PRECONDITIONFAILED: {
                return "preconditionFailed";
            }
            case UNPROCESSABLE: {
                return "unprocessable";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/assert-response-code-types";
    }

    public String getDefinition() {
        switch (this) {
            case OKAY: {
                return "Response code is 200.";
            }
            case CREATED: {
                return "Response code is 201.";
            }
            case NOCONTENT: {
                return "Response code is 204.";
            }
            case NOTMODIFIED: {
                return "Response code is 304.";
            }
            case BAD: {
                return "Response code is 400.";
            }
            case FORBIDDEN: {
                return "Response code is 403.";
            }
            case NOTFOUND: {
                return "Response code is 404.";
            }
            case METHODNOTALLOWED: {
                return "Response code is 405.";
            }
            case CONFLICT: {
                return "Response code is 409.";
            }
            case GONE: {
                return "Response code is 410.";
            }
            case PRECONDITIONFAILED: {
                return "Response code is 412.";
            }
            case UNPROCESSABLE: {
                return "Response code is 422.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OKAY: {
                return "okay";
            }
            case CREATED: {
                return "created";
            }
            case NOCONTENT: {
                return "noContent";
            }
            case NOTMODIFIED: {
                return "notModified";
            }
            case BAD: {
                return "bad";
            }
            case FORBIDDEN: {
                return "forbidden";
            }
            case NOTFOUND: {
                return "notFound";
            }
            case METHODNOTALLOWED: {
                return "methodNotAllowed";
            }
            case CONFLICT: {
                return "conflict";
            }
            case GONE: {
                return "gone";
            }
            case PRECONDITIONFAILED: {
                return "preconditionFailed";
            }
            case UNPROCESSABLE: {
                return "unprocessable";
            }
        }
        return "?";
    }
}

