/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.ActionDefinition;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="OrderSet", profile="http://hl7.org/fhir/Profile/OrderSet")
public class OrderSet
extends DomainResource {
    @Child(name="moduleMetadata", type={ModuleMetadata.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The metadata for the orderset", formalDefinition="A reference to a ModuleMetadata resource containing metadata for the orderset.")
    protected ModuleMetadata moduleMetadata;
    @Child(name="library", type={Library.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logic used by the orderset", formalDefinition="A reference to a Library resource containing any formal logic used by the orderset.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="action", type={ActionDefinition.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Groups, sections, and line items of the order set", formalDefinition="The definition of the actions that make up the order set. Order set groups and sections are represented as actions which contain sub-actions.")
    protected List<ActionDefinition> action;
    private static final long serialVersionUID = -728217200L;
    @SearchParamDefinition(name="topic", path="OrderSet.moduleMetadata.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="title", path="OrderSet.moduleMetadata.title", description="Text search against the title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="OrderSet.moduleMetadata.status", description="Status of the module", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="OrderSet.moduleMetadata.description", description="Text search against the description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="OrderSet.moduleMetadata.identifier", description="Logical identifier for the module (e.g. CMS-143)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="OrderSet.moduleMetadata.version", description="Version of the module (e.g. 1.0.0)", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public ModuleMetadata getModuleMetadata() {
        if (this.moduleMetadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderSet.moduleMetadata");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleMetadata = new ModuleMetadata();
            }
        }
        return this.moduleMetadata;
    }

    public boolean hasModuleMetadata() {
        return this.moduleMetadata != null && !this.moduleMetadata.isEmpty();
    }

    public OrderSet setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
        return this;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public OrderSet addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public List<Library> getLibraryTarget() {
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        return this.libraryTarget;
    }

    public Library addLibraryTarget() {
        Library r = new Library();
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        this.libraryTarget.add(r);
        return r;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (ActionDefinition item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionDefinition addAction() {
        ActionDefinition t = new ActionDefinition();
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return t;
    }

    public OrderSet addAction(ActionDefinition t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        this.action.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("moduleMetadata", "ModuleMetadata", "A reference to a ModuleMetadata resource containing metadata for the orderset.", 0, Integer.MAX_VALUE, this.moduleMetadata));
        childrenList.add(new Property("library", "Reference(Library)", "A reference to a Library resource containing any formal logic used by the orderset.", 0, Integer.MAX_VALUE, this.library));
        childrenList.add(new Property("action", "ActionDefinition", "The definition of the actions that make up the order set. Order set groups and sections are represented as actions which contain sub-actions.", 0, Integer.MAX_VALUE, this.action));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 455891387: {
                Base[] baseArray;
                if (this.moduleMetadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.moduleMetadata;
                }
                return baseArray;
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case -1422950858: {
                return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 455891387: {
                this.moduleMetadata = this.castToModuleMetadata(value);
                break;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                break;
            }
            case -1422950858: {
                this.getAction().add(this.castToActionDefinition(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = this.castToModuleMetadata(value);
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("action")) {
            this.getAction().add(this.castToActionDefinition(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 455891387: {
                return this.getModuleMetadata();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case -1422950858: {
                return this.addAction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = new ModuleMetadata();
            return this.moduleMetadata;
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OrderSet";
    }

    @Override
    public OrderSet copy() {
        OrderSet dst = new OrderSet();
        this.copyValues(dst);
        ModuleMetadata moduleMetadata = dst.moduleMetadata = this.moduleMetadata == null ? null : this.moduleMetadata.copy();
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<ActionDefinition>();
            for (ActionDefinition actionDefinition : this.action) {
                dst.action.add(actionDefinition.copy());
            }
        }
        return dst;
    }

    protected OrderSet typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof OrderSet)) {
            return false;
        }
        OrderSet o = (OrderSet)other;
        return OrderSet.compareDeep(this.moduleMetadata, o.moduleMetadata, true) && OrderSet.compareDeep(this.library, o.library, true) && OrderSet.compareDeep(this.action, o.action, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof OrderSet)) {
            return false;
        }
        OrderSet o = (OrderSet)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.moduleMetadata != null && !this.moduleMetadata.isEmpty() || this.library != null && !this.library.isEmpty() || this.action != null && !this.action.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OrderSet;
    }
}

