/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Substance", profile="http://hl7.org/fhir/Profile/Substance")
public class Substance
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier for the substance.")
    protected List<Identifier> identifier;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What class/type of substance this is", formalDefinition="A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What substance this is", formalDefinition="A code (or set of codes) that identify this substance.")
    protected CodeableConcept code;
    @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description of the substance, comments", formalDefinition="A description of the substance - its appearance, handling requirements, and other usage notes.")
    protected StringType description;
    @Child(name="instance", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific package/container of the substance", formalDefinition="Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.")
    protected List<SubstanceInstanceComponent> instance;
    @Child(name="ingredient", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Composition information about the substance", formalDefinition="A substance can be composed of other substances.")
    protected List<SubstanceIngredientComponent> ingredient;
    private static final long serialVersionUID = -1653977206L;
    @SearchParamDefinition(name="identifier", path="Substance.identifier", description="Unique identifier for the substance", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="container-identifier", path="Substance.instance.identifier", description="Identifier of the package/container", type="token")
    public static final String SP_CONTAINERIDENTIFIER = "container-identifier";
    @SearchParamDefinition(name="code", path="Substance.code", description="The code of the substance", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="quantity", path="Substance.instance.quantity", description="Amount of substance in the package", type="quantity")
    public static final String SP_QUANTITY = "quantity";
    @SearchParamDefinition(name="substance", path="Substance.ingredient.substance", description="A component of the substance", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    @SearchParamDefinition(name="expiry", path="Substance.instance.expiry", description="Expiry date of package or container of substance", type="date")
    public static final String SP_EXPIRY = "expiry";
    @SearchParamDefinition(name="category", path="Substance.category", description="The category of the substance", type="token")
    public static final String SP_CATEGORY = "category";

    public Substance() {
    }

    public Substance(CodeableConcept code) {
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Substance addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Substance addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Substance.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Substance setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Substance.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Substance setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Substance setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<SubstanceInstanceComponent> getInstance() {
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        return this.instance;
    }

    public boolean hasInstance() {
        if (this.instance == null) {
            return false;
        }
        for (SubstanceInstanceComponent item : this.instance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceInstanceComponent addInstance() {
        SubstanceInstanceComponent t = new SubstanceInstanceComponent();
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        this.instance.add(t);
        return t;
    }

    public Substance addInstance(SubstanceInstanceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.instance == null) {
            this.instance = new ArrayList<SubstanceInstanceComponent>();
        }
        this.instance.add(t);
        return this;
    }

    public List<SubstanceIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        return this.ingredient;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (SubstanceIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceIngredientComponent addIngredient() {
        SubstanceIngredientComponent t = new SubstanceIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public Substance addIngredient(SubstanceIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for the substance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the general type of substance.  This is used  for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that identify this substance.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property("description", "string", "A description of the substance - its appearance, handling requirements, and other usage notes.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("instance", "", "Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.", 0, Integer.MAX_VALUE, this.instance));
        childrenList.add(new Property("ingredient", "", "A substance can be composed of other substances.", 0, Integer.MAX_VALUE, this.ingredient));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("instance")) {
            this.getInstance().add((SubstanceInstanceComponent)value);
        } else if (name.equals("ingredient")) {
            this.getIngredient().add((SubstanceIngredientComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Substance.description");
        }
        if (name.equals("instance")) {
            return this.addInstance();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Substance";
    }

    @Override
    public Substance copy() {
        Substance dst = new Substance();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.instance != null) {
            dst.instance = new ArrayList<SubstanceInstanceComponent>();
            for (SubstanceInstanceComponent substanceInstanceComponent : this.instance) {
                dst.instance.add(substanceInstanceComponent.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<SubstanceIngredientComponent>();
            for (SubstanceIngredientComponent substanceIngredientComponent : this.ingredient) {
                dst.ingredient.add(substanceIngredientComponent.copy());
            }
        }
        return dst;
    }

    protected Substance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Substance)) {
            return false;
        }
        Substance o = (Substance)other;
        return Substance.compareDeep(this.identifier, o.identifier, true) && Substance.compareDeep(this.category, o.category, true) && Substance.compareDeep(this.code, o.code, true) && Substance.compareDeep(this.description, o.description, true) && Substance.compareDeep(this.instance, o.instance, true) && Substance.compareDeep(this.ingredient, o.ingredient, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Substance)) {
            return false;
        }
        Substance o = (Substance)other;
        return Substance.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.description != null && !this.description.isEmpty() || this.instance != null && !this.instance.isEmpty() || this.ingredient != null && !this.ingredient.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Substance;
    }

    @Block
    public static class SubstanceInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the package/container", formalDefinition="Identifier associated with the package/container (usually a label affixed directly).")
        protected Identifier identifier;
        @Child(name="expiry", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When no longer valid to use", formalDefinition="When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.")
        protected DateTimeType expiry;
        @Child(name="quantity", type={SimpleQuantity.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of substance in the package", formalDefinition="The amount of the substance.")
        protected SimpleQuantity quantity;
        private static final long serialVersionUID = -794314734L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceInstanceComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getExpiryElement() {
            if (this.expiry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.expiry");
                }
                if (Configuration.doAutoCreate()) {
                    this.expiry = new DateTimeType();
                }
            }
            return this.expiry;
        }

        public boolean hasExpiryElement() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public boolean hasExpiry() {
            return this.expiry != null && !this.expiry.isEmpty();
        }

        public SubstanceInstanceComponent setExpiryElement(DateTimeType value) {
            this.expiry = value;
            return this;
        }

        public Date getExpiry() {
            return this.expiry == null ? null : (Date)this.expiry.getValue();
        }

        public SubstanceInstanceComponent setExpiry(Date value) {
            if (value == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceInstanceComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubstanceInstanceComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Substance.SP_IDENTIFIER, "Identifier", "Identifier associated with the package/container (usually a label affixed directly).", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(Substance.SP_EXPIRY, "dateTime", "When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.", 0, Integer.MAX_VALUE, this.expiry));
            childrenList.add(new Property(Substance.SP_QUANTITY, "SimpleQuantity", "The amount of the substance.", 0, Integer.MAX_VALUE, this.quantity));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Substance.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals(Substance.SP_EXPIRY)) {
                this.expiry = this.castToDateTime(value);
            } else if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = this.castToSimpleQuantity(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Substance.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(Substance.SP_EXPIRY)) {
                throw new FHIRException("Cannot call addChild on a singleton property Substance.expiry");
            }
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceInstanceComponent copy() {
            SubstanceInstanceComponent dst = new SubstanceInstanceComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.expiry = this.expiry == null ? null : this.expiry.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubstanceInstanceComponent)) {
                return false;
            }
            SubstanceInstanceComponent o = (SubstanceInstanceComponent)other;
            return SubstanceInstanceComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceInstanceComponent.compareDeep(this.expiry, o.expiry, true) && SubstanceInstanceComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubstanceInstanceComponent)) {
                return false;
            }
            SubstanceInstanceComponent o = (SubstanceInstanceComponent)other;
            return SubstanceInstanceComponent.compareValues(this.expiry, o.expiry, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.expiry != null && !this.expiry.isEmpty() || this.quantity != null && !this.quantity.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Substance.instance";
        }
    }

    @Block
    public static class SubstanceIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="quantity", type={Ratio.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optional amount (concentration)", formalDefinition="The amount of the ingredient in the substance - a concentration ratio.")
        protected Ratio quantity;
        @Child(name="substance", type={Substance.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A component of the substance", formalDefinition="Another substance that is a component of this substance.")
        protected Reference substance;
        protected Substance substanceTarget;
        private static final long serialVersionUID = -1783242034L;

        public SubstanceIngredientComponent() {
        }

        public SubstanceIngredientComponent(Reference substance) {
            this.substance = substance;
        }

        public Ratio getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceIngredientComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Ratio();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubstanceIngredientComponent setQuantity(Ratio value) {
            this.quantity = value;
            return this;
        }

        public Reference getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceIngredientComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new Reference();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public SubstanceIngredientComponent setSubstance(Reference value) {
            this.substance = value;
            return this;
        }

        public Substance getSubstanceTarget() {
            if (this.substanceTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceIngredientComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substanceTarget = new Substance();
                }
            }
            return this.substanceTarget;
        }

        public SubstanceIngredientComponent setSubstanceTarget(Substance value) {
            this.substanceTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Substance.SP_QUANTITY, "Ratio", "The amount of the ingredient in the substance - a concentration ratio.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property(Substance.SP_SUBSTANCE, "Reference(Substance)", "Another substance that is a component of this substance.", 0, Integer.MAX_VALUE, this.substance));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = this.castToRatio(value);
            } else if (name.equals(Substance.SP_SUBSTANCE)) {
                this.substance = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Substance.SP_QUANTITY)) {
                this.quantity = new Ratio();
                return this.quantity;
            }
            if (name.equals(Substance.SP_SUBSTANCE)) {
                this.substance = new Reference();
                return this.substance;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceIngredientComponent copy() {
            SubstanceIngredientComponent dst = new SubstanceIngredientComponent();
            this.copyValues(dst);
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.substance = this.substance == null ? null : this.substance.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubstanceIngredientComponent)) {
                return false;
            }
            SubstanceIngredientComponent o = (SubstanceIngredientComponent)other;
            return SubstanceIngredientComponent.compareDeep(this.quantity, o.quantity, true) && SubstanceIngredientComponent.compareDeep(this.substance, o.substance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubstanceIngredientComponent)) {
                return false;
            }
            SubstanceIngredientComponent o = (SubstanceIngredientComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.substance != null && !this.substance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Substance.ingredient";
        }
    }
}

