/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/Profile/MedicationAdministration")
public class MedicationAdministration
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | on-hold | completed | entered-in-error | stopped", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    protected Enumeration<MedicationAdministrationStatus> status;
    @Child(name="patient", type={Patient.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who received medication", formalDefinition="The person or animal receiving the medication.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="practitioner", type={Practitioner.class, Patient.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who administered substance", formalDefinition="The individual who was responsible for giving the medication to the patient.")
    protected Reference practitioner;
    protected Resource practitionerTarget;
    @Child(name="encounter", type={Encounter.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter administered as part of", formalDefinition="The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="prescription", type={MedicationOrder.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Order administration performed against", formalDefinition="The original request, instruction or authority to perform the administration.")
    protected Reference prescription;
    protected MedicationOrder prescriptionTarget;
    @Child(name="wasNotGiven", type={BooleanType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if medication not administered", formalDefinition="Set this to true if the record is saying that the medication was NOT administered.")
    protected BooleanType wasNotGiven;
    @Child(name="reasonNotGiven", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason administration not performed", formalDefinition="A code indicating why the administration was not performed.")
    protected List<CodeableConcept> reasonNotGiven;
    @Child(name="reasonGiven", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason administration performed", formalDefinition="A code indicating why the medication was given.")
    protected List<CodeableConcept> reasonGiven;
    @Child(name="effectiveTime", type={DateTimeType.class, Period.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Start and end time of administration", formalDefinition="A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.")
    protected Type effectiveTime;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What was administered", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    protected Type medication;
    @Child(name="device", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Device used to administer", formalDefinition="The device used in administering the medication to the patient.  For example, a particular infusion pump.")
    protected List<Reference> device;
    protected List<Device> deviceTarget;
    @Child(name="note", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the administration", formalDefinition="Extra information about the medication administration that is not conveyed by the other attributes.")
    protected StringType note;
    @Child(name="dosage", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Describes the medication dosage information details e.g. dose, rate, site, route, etc.")
    protected MedicationAdministrationDosageComponent dosage;
    private static final long serialVersionUID = -669616345L;
    @SearchParamDefinition(name="identifier", path="MedicationAdministration.identifier", description="Return administrations with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="MedicationAdministration.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="prescription", path="MedicationAdministration.prescription", description="The identity of a prescription to list administrations from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    @SearchParamDefinition(name="effectivetime", path="MedicationAdministration.effectiveTime[x]", description="Date administration happened (or did not happen)", type="date")
    public static final String SP_EFFECTIVETIME = "effectivetime";
    @SearchParamDefinition(name="practitioner", path="MedicationAdministration.practitioner", description="Who administered substance", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    @SearchParamDefinition(name="patient", path="MedicationAdministration.patient", description="The identity of a patient to list administrations  for", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medicationReference", description="Return administrations of this medication resource", type="reference")
    public static final String SP_MEDICATION = "medication";
    @SearchParamDefinition(name="encounter", path="MedicationAdministration.encounter", description="Return administrations that share this encounter", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference")
    public static final String SP_DEVICE = "device";
    @SearchParamDefinition(name="notgiven", path="MedicationAdministration.wasNotGiven", description="Administrations that were not made", type="token")
    public static final String SP_NOTGIVEN = "notgiven";
    @SearchParamDefinition(name="status", path="MedicationAdministration.status", description="MedicationAdministration event status (for example one of active/paused/completed/nullified)", type="token")
    public static final String SP_STATUS = "status";

    public MedicationAdministration() {
    }

    public MedicationAdministration(Enumeration<MedicationAdministrationStatus> status, Reference patient, Type effectiveTime, Type medication) {
        this.status = status;
        this.patient = patient;
        this.effectiveTime = effectiveTime;
        this.medication = medication;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationAdministration addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<MedicationAdministrationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationAdministrationStatus>(new MedicationAdministrationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationAdministration setStatusElement(Enumeration<MedicationAdministrationStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationAdministrationStatus getStatus() {
        return this.status == null ? null : (MedicationAdministrationStatus)((Object)this.status.getValue());
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationAdministrationStatus>(new MedicationAdministrationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MedicationAdministration setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public MedicationAdministration setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getPractitioner() {
        if (this.practitioner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.practitioner");
            }
            if (Configuration.doAutoCreate()) {
                this.practitioner = new Reference();
            }
        }
        return this.practitioner;
    }

    public boolean hasPractitioner() {
        return this.practitioner != null && !this.practitioner.isEmpty();
    }

    public MedicationAdministration setPractitioner(Reference value) {
        this.practitioner = value;
        return this;
    }

    public Resource getPractitionerTarget() {
        return this.practitionerTarget;
    }

    public MedicationAdministration setPractitionerTarget(Resource value) {
        this.practitionerTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public MedicationAdministration setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public MedicationAdministration setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public MedicationAdministration setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public MedicationOrder getPrescriptionTarget() {
        if (this.prescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriptionTarget = new MedicationOrder();
            }
        }
        return this.prescriptionTarget;
    }

    public MedicationAdministration setPrescriptionTarget(MedicationOrder value) {
        this.prescriptionTarget = value;
        return this;
    }

    public BooleanType getWasNotGivenElement() {
        if (this.wasNotGiven == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.wasNotGiven");
            }
            if (Configuration.doAutoCreate()) {
                this.wasNotGiven = new BooleanType();
            }
        }
        return this.wasNotGiven;
    }

    public boolean hasWasNotGivenElement() {
        return this.wasNotGiven != null && !this.wasNotGiven.isEmpty();
    }

    public boolean hasWasNotGiven() {
        return this.wasNotGiven != null && !this.wasNotGiven.isEmpty();
    }

    public MedicationAdministration setWasNotGivenElement(BooleanType value) {
        this.wasNotGiven = value;
        return this;
    }

    public boolean getWasNotGiven() {
        return this.wasNotGiven == null || this.wasNotGiven.isEmpty() ? false : (Boolean)this.wasNotGiven.getValue();
    }

    public MedicationAdministration setWasNotGiven(boolean value) {
        if (this.wasNotGiven == null) {
            this.wasNotGiven = new BooleanType();
        }
        this.wasNotGiven.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotGiven;
    }

    public boolean hasReasonNotGiven() {
        if (this.reasonNotGiven == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonNotGiven) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonNotGiven() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonNotGiven.add(t);
        return t;
    }

    public MedicationAdministration addReasonNotGiven(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonNotGiven == null) {
            this.reasonNotGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonNotGiven.add(t);
        return this;
    }

    public List<CodeableConcept> getReasonGiven() {
        if (this.reasonGiven == null) {
            this.reasonGiven = new ArrayList<CodeableConcept>();
        }
        return this.reasonGiven;
    }

    public boolean hasReasonGiven() {
        if (this.reasonGiven == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonGiven) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonGiven() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonGiven == null) {
            this.reasonGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonGiven.add(t);
        return t;
    }

    public MedicationAdministration addReasonGiven(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonGiven == null) {
            this.reasonGiven = new ArrayList<CodeableConcept>();
        }
        this.reasonGiven.add(t);
        return this;
    }

    public Type getEffectiveTime() {
        return this.effectiveTime;
    }

    public DateTimeType getEffectiveTimeDateTimeType() throws FHIRException {
        if (!(this.effectiveTime instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effectiveTime.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effectiveTime;
    }

    public boolean hasEffectiveTimeDateTimeType() {
        return this.effectiveTime instanceof DateTimeType;
    }

    public Period getEffectiveTimePeriod() throws FHIRException {
        if (!(this.effectiveTime instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effectiveTime.getClass().getName() + " was encountered");
        }
        return (Period)this.effectiveTime;
    }

    public boolean hasEffectiveTimePeriod() {
        return this.effectiveTime instanceof Period;
    }

    public boolean hasEffectiveTime() {
        return this.effectiveTime != null && !this.effectiveTime.isEmpty();
    }

    public MedicationAdministration setEffectiveTime(Type value) {
        this.effectiveTime = value;
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationAdministration setMedication(Type value) {
        this.medication = value;
        return this;
    }

    public List<Reference> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        return this.device;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (Reference item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDevice() {
        Reference t = new Reference();
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return t;
    }

    public MedicationAdministration addDevice(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.device == null) {
            this.device = new ArrayList<Reference>();
        }
        this.device.add(t);
        return this;
    }

    public List<Device> getDeviceTarget() {
        if (this.deviceTarget == null) {
            this.deviceTarget = new ArrayList<Device>();
        }
        return this.deviceTarget;
    }

    public Device addDeviceTarget() {
        Device r = new Device();
        if (this.deviceTarget == null) {
            this.deviceTarget = new ArrayList<Device>();
        }
        this.deviceTarget.add(r);
        return r;
    }

    public StringType getNoteElement() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new StringType();
            }
        }
        return this.note;
    }

    public boolean hasNoteElement() {
        return this.note != null && !this.note.isEmpty();
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public MedicationAdministration setNoteElement(StringType value) {
        this.note = value;
        return this;
    }

    public String getNote() {
        return this.note == null ? null : (String)this.note.getValue();
    }

    public MedicationAdministration setNote(String value) {
        if (Utilities.noString((String)value)) {
            this.note = null;
        } else {
            if (this.note == null) {
                this.note = new StringType();
            }
            this.note.setValue(value);
        }
        return this;
    }

    public MedicationAdministrationDosageComponent getDosage() {
        if (this.dosage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationAdministration.dosage");
            }
            if (Configuration.doAutoCreate()) {
                this.dosage = new MedicationAdministrationDosageComponent();
            }
        }
        return this.dosage;
    }

    public boolean hasDosage() {
        return this.dosage != null && !this.dosage.isEmpty();
    }

    public MedicationAdministration setDosage(MedicationAdministrationDosageComponent value) {
        this.dosage = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The person or animal receiving the medication.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_PRACTITIONER, "Reference(Practitioner|Patient|RelatedPerson)", "The individual who was responsible for giving the medication to the patient.", 0, Integer.MAX_VALUE, this.practitioner));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property(SP_PRESCRIPTION, "Reference(MedicationOrder)", "The original request, instruction or authority to perform the administration.", 0, Integer.MAX_VALUE, this.prescription));
        childrenList.add(new Property("wasNotGiven", "boolean", "Set this to true if the record is saying that the medication was NOT administered.", 0, Integer.MAX_VALUE, this.wasNotGiven));
        childrenList.add(new Property("reasonNotGiven", "CodeableConcept", "A code indicating why the administration was not performed.", 0, Integer.MAX_VALUE, this.reasonNotGiven));
        childrenList.add(new Property("reasonGiven", "CodeableConcept", "A code indicating why the medication was given.", 0, Integer.MAX_VALUE, this.reasonGiven));
        childrenList.add(new Property("effectiveTime[x]", "dateTime|Period", "A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.", 0, Integer.MAX_VALUE, this.effectiveTime));
        childrenList.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device)", "The device used in administering the medication to the patient.  For example, a particular infusion pump.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("note", "string", "Extra information about the medication administration that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("dosage", "", "Describes the medication dosage information details e.g. dose, rate, site, route, etc.", 0, Integer.MAX_VALUE, this.dosage));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new MedicationAdministrationStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals(SP_PRESCRIPTION)) {
            this.prescription = this.castToReference(value);
        } else if (name.equals("wasNotGiven")) {
            this.wasNotGiven = this.castToBoolean(value);
        } else if (name.equals("reasonNotGiven")) {
            this.getReasonNotGiven().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonGiven")) {
            this.getReasonGiven().add(this.castToCodeableConcept(value));
        } else if (name.equals("effectiveTime[x]")) {
            this.effectiveTime = (Type)value;
        } else if (name.equals("medication[x]")) {
            this.medication = (Type)value;
        } else if (name.equals(SP_DEVICE)) {
            this.getDevice().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.note = this.castToString(value);
        } else if (name.equals("dosage")) {
            this.dosage = (MedicationAdministrationDosageComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = new Reference();
            return this.practitioner;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_PRESCRIPTION)) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("wasNotGiven")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.wasNotGiven");
        }
        if (name.equals("reasonNotGiven")) {
            return this.addReasonNotGiven();
        }
        if (name.equals("reasonGiven")) {
            return this.addReasonGiven();
        }
        if (name.equals("effectiveTimeDateTime")) {
            this.effectiveTime = new DateTimeType();
            return this.effectiveTime;
        }
        if (name.equals("effectiveTimePeriod")) {
            this.effectiveTime = new Period();
            return this.effectiveTime;
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals(SP_DEVICE)) {
            return this.addDevice();
        }
        if (name.equals("note")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.note");
        }
        if (name.equals("dosage")) {
            this.dosage = new MedicationAdministrationDosageComponent();
            return this.dosage;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationAdministration";
    }

    @Override
    public MedicationAdministration copy() {
        MedicationAdministration dst = new MedicationAdministration();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.practitioner = this.practitioner == null ? null : this.practitioner.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        BooleanType booleanType = dst.wasNotGiven = this.wasNotGiven == null ? null : this.wasNotGiven.copy();
        if (this.reasonNotGiven != null) {
            dst.reasonNotGiven = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonNotGiven) {
                dst.reasonNotGiven.add(codeableConcept.copy());
            }
        }
        if (this.reasonGiven != null) {
            dst.reasonGiven = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonGiven) {
                dst.reasonGiven.add(codeableConcept.copy());
            }
        }
        dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
        Type type = dst.medication = this.medication == null ? null : this.medication.copy();
        if (this.device != null) {
            dst.device = new ArrayList<Reference>();
            for (Reference reference : this.device) {
                dst.device.add(reference.copy());
            }
        }
        dst.note = this.note == null ? null : this.note.copy();
        dst.dosage = this.dosage == null ? null : this.dosage.copy();
        return dst;
    }

    protected MedicationAdministration typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other;
        return MedicationAdministration.compareDeep(this.identifier, o.identifier, true) && MedicationAdministration.compareDeep(this.status, o.status, true) && MedicationAdministration.compareDeep(this.patient, o.patient, true) && MedicationAdministration.compareDeep(this.practitioner, o.practitioner, true) && MedicationAdministration.compareDeep(this.encounter, o.encounter, true) && MedicationAdministration.compareDeep(this.prescription, o.prescription, true) && MedicationAdministration.compareDeep(this.wasNotGiven, o.wasNotGiven, true) && MedicationAdministration.compareDeep(this.reasonNotGiven, o.reasonNotGiven, true) && MedicationAdministration.compareDeep(this.reasonGiven, o.reasonGiven, true) && MedicationAdministration.compareDeep(this.effectiveTime, o.effectiveTime, true) && MedicationAdministration.compareDeep(this.medication, o.medication, true) && MedicationAdministration.compareDeep(this.device, o.device, true) && MedicationAdministration.compareDeep(this.note, o.note, true) && MedicationAdministration.compareDeep(this.dosage, o.dosage, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MedicationAdministration)) {
            return false;
        }
        MedicationAdministration o = (MedicationAdministration)other;
        return MedicationAdministration.compareValues(this.status, o.status, true) && MedicationAdministration.compareValues(this.wasNotGiven, o.wasNotGiven, true) && MedicationAdministration.compareValues(this.note, o.note, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.practitioner != null && !this.practitioner.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.prescription != null && !this.prescription.isEmpty() || this.wasNotGiven != null && !this.wasNotGiven.isEmpty() || this.reasonNotGiven != null && !this.reasonNotGiven.isEmpty() || this.reasonGiven != null && !this.reasonGiven.isEmpty() || this.effectiveTime != null && !this.effectiveTime.isEmpty() || this.medication != null && !this.medication.isEmpty() || this.device != null && !this.device.isEmpty() || this.note != null && !this.note.isEmpty() || this.dosage != null && !this.dosage.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationAdministration;
    }

    public static class MedicationAdministrationStatusEnumFactory
    implements EnumFactory<MedicationAdministrationStatus> {
        @Override
        public MedicationAdministrationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return MedicationAdministrationStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationAdministrationStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationAdministrationStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationAdministrationStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationAdministrationStatus.STOPPED;
            }
            throw new IllegalArgumentException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationAdministrationStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationAdministrationStatus>(this, MedicationAdministrationStatus.STOPPED);
            }
            throw new FHIRException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationAdministrationStatus code) {
            if (code == MedicationAdministrationStatus.NULL) {
                return null;
            }
            if (code == MedicationAdministrationStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == MedicationAdministrationStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationAdministrationStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationAdministrationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationAdministrationStatus.STOPPED) {
                return "stopped";
            }
            return "?";
        }
    }

    public static enum MedicationAdministrationStatus {
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        NULL;


        public static MedicationAdministrationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            throw new FHIRException("Unknown MedicationAdministrationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-admin-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "The administration has started but has not yet completed.";
                }
                case ONHOLD: {
                    return "Actions implied by the administration have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case COMPLETED: {
                    return "All actions that are implied by the administration have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The administration was entered in error and therefore nullified.";
                }
                case STOPPED: {
                    return "Actions implied by the administration have been permanently halted, before all of them occurred.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    @Block
    public static class MedicationAdministrationDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dosage Instructions", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.")
        protected StringType text;
        @Child(name="site", type={CodeableConcept.class, BodySite.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body site administered to", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".")
        protected Type site;
        @Child(name="route", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path of substance into body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How drug was administered", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        protected CodeableConcept method;
        @Child(name="quantity", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount administered in one dose", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        protected SimpleQuantity quantity;
        @Child(name="rate", type={Ratio.class, Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Currently we do not specify a default of '1' in the denominator, but this is being discussed.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected Type rate;
        private static final long serialVersionUID = -1772198879L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationAdministrationDosageComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationAdministrationDosageComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Type getSite() {
            return this.site;
        }

        public CodeableConcept getSiteCodeableConcept() throws FHIRException {
            if (!(this.site instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.site;
        }

        public boolean hasSiteCodeableConcept() {
            return this.site instanceof CodeableConcept;
        }

        public Reference getSiteReference() throws FHIRException {
            if (!(this.site instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (Reference)this.site;
        }

        public boolean hasSiteReference() {
            return this.site instanceof Reference;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationAdministrationDosageComponent setSite(Type value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationAdministrationDosageComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationAdministrationDosageComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationAdministrationDosageComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public Range getRateRange() throws FHIRException {
            if (!(this.rate instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Range)this.rate;
        }

        public boolean hasRateRange() {
            return this.rate instanceof Range;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationAdministrationDosageComponent setRate(Type value) {
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("text", "string", "Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("site[x]", "CodeableConcept|Reference(BodySite)", "A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\".", 0, Integer.MAX_VALUE, this.site));
            childrenList.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.", 0, Integer.MAX_VALUE, this.route));
            childrenList.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("rate[x]", "Ratio|Range", "Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Currently we do not specify a default of '1' in the denominator, but this is being discussed.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, Integer.MAX_VALUE, this.rate));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("site[x]")) {
                this.site = (Type)value;
            } else if (name.equals("route")) {
                this.route = this.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicationAdministration.text");
            }
            if (name.equals("siteCodeableConcept")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("siteReference")) {
                this.site = new Reference();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateRange")) {
                this.rate = new Range();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationAdministrationDosageComponent copy() {
            MedicationAdministrationDosageComponent dst = new MedicationAdministrationDosageComponent();
            this.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other;
            return MedicationAdministrationDosageComponent.compareDeep(this.text, o.text, true) && MedicationAdministrationDosageComponent.compareDeep(this.site, o.site, true) && MedicationAdministrationDosageComponent.compareDeep(this.route, o.route, true) && MedicationAdministrationDosageComponent.compareDeep(this.method, o.method, true) && MedicationAdministrationDosageComponent.compareDeep(this.quantity, o.quantity, true) && MedicationAdministrationDosageComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationAdministrationDosageComponent)) {
                return false;
            }
            MedicationAdministrationDosageComponent o = (MedicationAdministrationDosageComponent)other;
            return MedicationAdministrationDosageComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.text != null && !this.text.isEmpty() || this.site != null && !this.site.isEmpty() || this.route != null && !this.route.isEmpty() || this.method != null && !this.method.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.rate != null && !this.rate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationAdministration.dosage";
        }
    }
}

