/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.formats.JsonParser;
import org.hl7.fhir.dstu2.formats.ParserBase;
import org.hl7.fhir.dstu2.formats.XmlParser;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.utils.ResourceUtilities;
import org.hl7.fhir.dstu2.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2.utils.client.ResourceRequest;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.MimeType;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPHeaderUtil;
import org.hl7.fhir.utilities.http.HTTPRequest;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedFhirWebAccessor;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.settings.FhirSettings;

@Deprecated
public class ClientUtils {
    protected static final String LOCATION_HEADER = "location";
    protected static final String CONTENT_LOCATION_HEADER = "content-location";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static boolean debugging = false;
    private int timeout = 5000;
    private ToolingClientLogger logger;
    private int retryCount;
    private String userAgent;
    private String acceptLanguage;
    private String contentLanguage;
    private final TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;

    protected ManagedFhirWebAccessor getManagedWebAccessor() {
        return ManagedWebAccess.fhirAccessor().withRetries(this.retryCount).withTimeout((long)this.timeout, this.timeoutUnit).withLogger(this.logger);
    }

    public <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.OPTIONS).withUrl(optionsUri.toString());
        return this.issueResourceRequest(resourceFormat, httpRequest, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.GET).withUrl(resourceUri.toString());
        return this.issueResourceRequest(resourceFormat, httpRequest, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, Iterable<HTTPHeader> headers, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.PUT).withUrl(resourceUri.toString()).withBody(payload);
        return this.issueResourceRequest(resourceFormat, httpRequest, headers, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.PUT).withUrl(resourceUri.toString()).withBody(payload);
        return this.issueResourceRequest(resourceFormat, httpRequest, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, Iterable<HTTPHeader> headers, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.POST).withUrl(resourceUri.toString()).withBody(payload);
        return this.issueResourceRequest(resourceFormat, httpRequest, headers, timeoutLoading);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        return this.issuePostRequest(resourceUri, payload, resourceFormat, null, timeoutLoading);
    }

    public Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.GET).withUrl(resourceUri.toString());
        Iterable<HTTPHeader> headers = this.getFhirHeaders(httpRequest, resourceFormat);
        HTTPResult response = this.sendRequest(httpRequest.withHeaders(headers));
        return (Bundle)this.unmarshalReference(response, resourceFormat);
    }

    public Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.POST).withUrl(resourceUri.toString()).withBody(payload);
        Iterable<HTTPHeader> headers = this.getFhirHeaders(httpRequest, resourceFormat);
        HTTPResult response = this.sendPayload(httpRequest.withHeaders(headers));
        return this.unmarshalFeed(response, resourceFormat);
    }

    public boolean issueDeleteRequest(URI resourceUri) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPRequest request = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.DELETE).withUrl(resourceUri.toString());
        HTTPResult response = this.sendRequest(request);
        int responseStatusCode = response.getCode();
        boolean deletionSuccessful = false;
        if (responseStatusCode == 204) {
            deletionSuccessful = true;
        }
        return deletionSuccessful;
    }

    protected <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HTTPRequest request, int timeoutLoading) {
        return this.issueResourceRequest(resourceFormat, request, Collections.emptyList(), timeoutLoading);
    }

    protected <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HTTPRequest request, @Nonnull Iterable<HTTPHeader> headers, int timeoutLoading) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        Iterable<HTTPHeader> configuredHeaders = this.getFhirHeaders(request, resourceFormat, headers);
        try {
            HTTPResult response = this.getManagedWebAccessor().httpCall(request.withHeaders(configuredHeaders));
            T resource = this.unmarshalReference(response, resourceFormat);
            return new ResourceRequest<T>(resource, response.getCode(), ClientUtils.getLocationHeader(response.getHeaders()));
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload to ??: " + ioe.getMessage(), ioe);
        }
    }

    protected Iterable<HTTPHeader> getFhirHeaders(HTTPRequest httpRequest, String format) {
        return this.getFhirHeaders(httpRequest, format, null);
    }

    protected Iterable<HTTPHeader> getFhirHeaders(HTTPRequest httpRequest, String format, Iterable<HTTPHeader> headers) {
        ArrayList<HTTPHeader> configuredHeaders = new ArrayList<HTTPHeader>();
        if (!Utilities.noString((String)this.userAgent)) {
            configuredHeaders.add(new HTTPHeader("User-Agent", this.userAgent));
        }
        if (!Utilities.noString((String)this.acceptLanguage)) {
            configuredHeaders.add(new HTTPHeader("Accept-Language", this.acceptLanguage));
        }
        if (!Utilities.noString((String)this.contentLanguage)) {
            configuredHeaders.add(new HTTPHeader("Content-Language", this.acceptLanguage));
        }
        List<HTTPHeader> resourceFormatHeaders = ClientUtils.getResourceFormatHeaders(httpRequest, format);
        resourceFormatHeaders.forEach(configuredHeaders::add);
        if (headers != null) {
            headers.forEach(configuredHeaders::add);
        }
        return configuredHeaders;
    }

    protected static List<HTTPHeader> getResourceFormatHeaders(HTTPRequest httpRequest, String format) {
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        headers.add(new HTTPHeader("Accept", format));
        if (httpRequest.getMethod() == HTTPRequest.HttpMethod.PUT || httpRequest.getMethod() == HTTPRequest.HttpMethod.POST || httpRequest.getMethod() == HTTPRequest.HttpMethod.PATCH) {
            headers.add(new HTTPHeader("Content-Type", format + ";charset=UTF-8"));
        }
        return headers;
    }

    protected HTTPResult sendRequest(HTTPRequest request) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        HTTPResult response = null;
        try {
            response = this.getManagedWebAccessor().httpCall(request);
            return response;
        }
        catch (IOException ioe) {
            if (debugging) {
                ioe.printStackTrace();
            }
            throw new EFhirClientException("Error sending Http Request: " + ioe.getMessage(), ioe);
        }
    }

    protected <T extends Resource> T unmarshalReference(HTTPResult response, String format) {
        Resource resource = null;
        OperationOutcome error = null;
        if (response.getContent() != null) {
            try {
                resource = this.getParser(format).parse(response.getContent());
                if (resource instanceof OperationOutcome && this.hasError((OperationOutcome)resource)) {
                    error = (OperationOutcome)resource;
                }
            }
            catch (IOException ioe) {
                throw new EFhirClientException("Error reading Http Response: " + ioe.getMessage(), ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException("Error parsing response message: " + e.getMessage(), e);
            }
        }
        if (error != null) {
            throw new EFhirClientException("Error from server: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return (T)resource;
    }

    protected Bundle unmarshalFeed(HTTPResult response, String format) {
        OperationOutcome error;
        Bundle feed;
        block6: {
            feed = null;
            String contentType = HTTPHeaderUtil.getSingleHeader((Iterable)response.getHeaders(), (String)"Content-Type");
            error = null;
            try {
                if (response.getContent() == null || !contentType.contains(ResourceFormat.RESOURCE_XML.getHeader()) && !contentType.contains("text/xml+fhir")) break block6;
                Resource rf = this.getParser(format).parse(response.getContent());
                if (rf instanceof Bundle) {
                    feed = (Bundle)rf;
                    break block6;
                }
                if (rf instanceof OperationOutcome && this.hasError((OperationOutcome)rf)) {
                    error = (OperationOutcome)rf;
                    break block6;
                }
                throw new EFhirClientException("Error reading server response: a resource was returned instead");
            }
            catch (IOException ioe) {
                throw new EFhirClientException("Error reading Http Response", ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException("Error parsing response message", e);
            }
        }
        if (error != null) {
            throw new EFhirClientException("Error from server: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return feed;
    }

    protected boolean hasError(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : oo.getIssue()) {
            if (t.getSeverity() != OperationOutcome.IssueSeverity.ERROR && t.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            return true;
        }
        return false;
    }

    protected static String getLocationHeader(Iterable<HTTPHeader> headers) {
        String locationHeader = HTTPHeaderUtil.getSingleHeader(headers, (String)LOCATION_HEADER);
        if (locationHeader != null) {
            return locationHeader;
        }
        return HTTPHeaderUtil.getSingleHeader(headers, (String)CONTENT_LOCATION_HEADER);
    }

    public HttpURLConnection buildConnection(URI baseServiceUri, String tail) {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        try {
            HttpURLConnection client = (HttpURLConnection)baseServiceUri.resolve(tail).toURL().openConnection();
            return client;
        }
        catch (MalformedURLException mue) {
            throw new EFhirClientException("Invalid Service URL", mue);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Unable to establish connection to server: " + baseServiceUri.toString() + tail, ioe);
        }
    }

    public HttpURLConnection buildConnection(URI baseServiceUri, ResourceType resourceType, String id) {
        return this.buildConnection(baseServiceUri, ResourceAddress.buildRelativePathFromResourceType(resourceType, id));
    }

    public <T extends Resource> byte[] getResourceAsByteArray(T resource, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, resource);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public byte[] getFeedAsByteArray(Bundle feed, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, feed);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public Calendar getLastModifiedResponseHeaderAsCalendarObject(URLConnection serverConnection) {
        String dateTime = null;
        try {
            dateTime = serverConnection.getHeaderField("Last-Modified");
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", new Locale("en", "US"));
            Date lastModifiedTimestamp = format.parse(dateTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastModifiedTimestamp);
            return calendar;
        }
        catch (ParseException pe) {
            throw new EFhirClientException("Error parsing Last-Modified response header " + dateTime, pe);
        }
    }

    protected IParser getParser(String format) {
        MimeType mm;
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if ((mm = new MimeType(format)).getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (mm.getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + format);
    }

    public Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat) throws IOException {
        HTTPRequest httpRequest = new HTTPRequest().withMethod(HTTPRequest.HttpMethod.POST).withUrl(resourceUri.toString());
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        headers.add(new HTTPHeader("Content-Type", "multipart/form-data; boundary=" + boundary));
        headers.add(new HTTPHeader("Accept", resourceFormat));
        this.getFhirHeaders(httpRequest, null).forEach(headers::add);
        HTTPResult response = this.sendPayload(httpRequest.withBody(this.encodeFormSubmission(parameters, resourceName, resource, boundary)).withHeaders(headers));
        return this.unmarshalFeed(response, resourceFormat);
    }

    private byte[] encodeFormSubmission(Map<String, String> parameters, String resourceName, Resource resource, String boundary) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)b, DEFAULT_CHARSET);
        for (String name : parameters.keySet()) {
            w.write("--");
            w.write(boundary);
            w.write("\r\nContent-Disposition: form-data; name=\"" + name + "\"\r\n\r\n");
            w.write(parameters.get(name) + "\r\n");
        }
        w.write("--");
        w.write(boundary);
        w.write("\r\nContent-Disposition: form-data; name=\"" + resourceName + "\"\r\n\r\n");
        w.close();
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.NORMAL);
        json.compose(b, resource);
        b.close();
        w = new OutputStreamWriter((OutputStream)b, DEFAULT_CHARSET);
        w.write("\r\n--");
        w.write(boundary);
        w.write("--");
        w.close();
        return b.toByteArray();
    }

    protected HTTPResult sendPayload(HTTPRequest request) {
        HTTPResult response = null;
        try {
            response = this.getManagedWebAccessor().httpCall(request);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload: " + ioe.getMessage(), ioe);
        }
        return response;
    }

    protected String writeInputStreamAsString(InputStream instream) {
        String value = null;
        try {
            value = IOUtils.toString((InputStream)instream, (String)DEFAULT_CHARSET);
            System.out.println(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
    }

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }
}

