/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="SupplyDelivery", profile="http://hl7.org/fhir/Profile/SupplyDelivery")
public class SupplyDelivery
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier assigned by the dispensing facility when the item(s) is dispensed.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | abandoned", formalDefinition="A code specifying the state of the dispense event.")
    protected Enumeration<SupplyDeliveryStatus> status;
    @Child(name="patient", type={Patient.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient for whom the item is supplied", formalDefinition="A link to a resource representing the person whom the delivered item is for.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Category of dispense event", formalDefinition="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    protected CodeableConcept type;
    @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of supply that has been dispensed. Includes unit of measure.")
    protected SimpleQuantity quantity;
    @Child(name="suppliedItem", type={Medication.class, Substance.class, Device.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication, Substance, or Device supplied", formalDefinition="Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a simple attribute carrying a code that identifies the item from a known list.")
    protected Reference suppliedItem;
    protected Resource suppliedItemTarget;
    @Child(name="supplier", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dispenser", formalDefinition="The individual responsible for dispensing the medication, supplier or device.")
    protected Reference supplier;
    protected Practitioner supplierTarget;
    @Child(name="whenPrepared", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dispensing time", formalDefinition="The time the dispense event occurred.")
    protected Period whenPrepared;
    @Child(name="time", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Handover time", formalDefinition="The time the dispensed item was sent or handed to the patient (or agent).")
    protected DateTimeType time;
    @Child(name="destination", type={Location.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the Supply was sent", formalDefinition="Identification of the facility/location where the Supply was shipped to, as part of the dispense event.")
    protected Reference destination;
    protected Location destinationTarget;
    @Child(name="receiver", type={Practitioner.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who collected the Supply", formalDefinition="Identifies the person who picked up the Supply.")
    protected List<Reference> receiver;
    protected List<Practitioner> receiverTarget;
    private static final long serialVersionUID = -1520129707L;
    @SearchParamDefinition(name="identifier", path="SupplyDelivery.identifier", description="External identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="receiver", path="SupplyDelivery.receiver", description="Who collected the Supply", type="reference")
    public static final String SP_RECEIVER = "receiver";
    @SearchParamDefinition(name="patient", path="SupplyDelivery.patient", description="Patient for whom the item is supplied", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="supplier", path="SupplyDelivery.supplier", description="Dispenser", type="reference")
    public static final String SP_SUPPLIER = "supplier";
    @SearchParamDefinition(name="status", path="SupplyDelivery.status", description="in-progress | completed | abandoned", type="token")
    public static final String SP_STATUS = "status";

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SupplyDelivery setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<SupplyDeliveryStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyDelivery setStatusElement(Enumeration<SupplyDeliveryStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyDeliveryStatus getStatus() {
        return this.status == null ? null : (SupplyDeliveryStatus)((Object)this.status.getValue());
    }

    public SupplyDelivery setStatus(SupplyDeliveryStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyDeliveryStatus>(new SupplyDeliveryStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public SupplyDelivery setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public SupplyDelivery setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SupplyDelivery setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public SimpleQuantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new SimpleQuantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public SupplyDelivery setQuantity(SimpleQuantity value) {
        this.quantity = value;
        return this;
    }

    public Reference getSuppliedItem() {
        if (this.suppliedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.suppliedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.suppliedItem = new Reference();
            }
        }
        return this.suppliedItem;
    }

    public boolean hasSuppliedItem() {
        return this.suppliedItem != null && !this.suppliedItem.isEmpty();
    }

    public SupplyDelivery setSuppliedItem(Reference value) {
        this.suppliedItem = value;
        return this;
    }

    public Resource getSuppliedItemTarget() {
        return this.suppliedItemTarget;
    }

    public SupplyDelivery setSuppliedItemTarget(Resource value) {
        this.suppliedItemTarget = value;
        return this;
    }

    public Reference getSupplier() {
        if (this.supplier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.supplier");
            }
            if (Configuration.doAutoCreate()) {
                this.supplier = new Reference();
            }
        }
        return this.supplier;
    }

    public boolean hasSupplier() {
        return this.supplier != null && !this.supplier.isEmpty();
    }

    public SupplyDelivery setSupplier(Reference value) {
        this.supplier = value;
        return this;
    }

    public Practitioner getSupplierTarget() {
        if (this.supplierTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.supplier");
            }
            if (Configuration.doAutoCreate()) {
                this.supplierTarget = new Practitioner();
            }
        }
        return this.supplierTarget;
    }

    public SupplyDelivery setSupplierTarget(Practitioner value) {
        this.supplierTarget = value;
        return this;
    }

    public Period getWhenPrepared() {
        if (this.whenPrepared == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.whenPrepared");
            }
            if (Configuration.doAutoCreate()) {
                this.whenPrepared = new Period();
            }
        }
        return this.whenPrepared;
    }

    public boolean hasWhenPrepared() {
        return this.whenPrepared != null && !this.whenPrepared.isEmpty();
    }

    public SupplyDelivery setWhenPrepared(Period value) {
        this.whenPrepared = value;
        return this;
    }

    public DateTimeType getTimeElement() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DateTimeType();
            }
        }
        return this.time;
    }

    public boolean hasTimeElement() {
        return this.time != null && !this.time.isEmpty();
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public SupplyDelivery setTimeElement(DateTimeType value) {
        this.time = value;
        return this;
    }

    public Date getTime() {
        return this.time == null ? null : (Date)this.time.getValue();
    }

    public SupplyDelivery setTime(Date value) {
        if (value == null) {
            this.time = null;
        } else {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            this.time.setValue(value);
        }
        return this;
    }

    public Reference getDestination() {
        if (this.destination == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destination = new Reference();
            }
        }
        return this.destination;
    }

    public boolean hasDestination() {
        return this.destination != null && !this.destination.isEmpty();
    }

    public SupplyDelivery setDestination(Reference value) {
        this.destination = value;
        return this;
    }

    public Location getDestinationTarget() {
        if (this.destinationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyDelivery.destination");
            }
            if (Configuration.doAutoCreate()) {
                this.destinationTarget = new Location();
            }
        }
        return this.destinationTarget;
    }

    public SupplyDelivery setDestinationTarget(Location value) {
        this.destinationTarget = value;
        return this;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public boolean hasReceiver() {
        if (this.receiver == null) {
            return false;
        }
        for (Reference item : this.receiver) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReceiver() {
        Reference t = new Reference();
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return t;
    }

    public SupplyDelivery addReceiver(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        this.receiver.add(t);
        return this;
    }

    public List<Practitioner> getReceiverTarget() {
        if (this.receiverTarget == null) {
            this.receiverTarget = new ArrayList<Practitioner>();
        }
        return this.receiverTarget;
    }

    public Practitioner addReceiverTarget() {
        Practitioner r = new Practitioner();
        if (this.receiverTarget == null) {
            this.receiverTarget = new ArrayList<Practitioner>();
        }
        this.receiverTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier assigned by the dispensing facility when the item(s) is dispensed.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "A code specifying the state of the dispense event.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the delivered item is for.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("quantity", "SimpleQuantity", "The amount of supply that has been dispensed. Includes unit of measure.", 0, Integer.MAX_VALUE, this.quantity));
        childrenList.add(new Property("suppliedItem", "Reference(Medication|Substance|Device)", "Identifies the medication, substance or device being dispensed. This is either a link to a resource representing the details of the item or a simple attribute carrying a code that identifies the item from a known list.", 0, Integer.MAX_VALUE, this.suppliedItem));
        childrenList.add(new Property(SP_SUPPLIER, "Reference(Practitioner)", "The individual responsible for dispensing the medication, supplier or device.", 0, Integer.MAX_VALUE, this.supplier));
        childrenList.add(new Property("whenPrepared", "Period", "The time the dispense event occurred.", 0, Integer.MAX_VALUE, this.whenPrepared));
        childrenList.add(new Property("time", "dateTime", "The time the dispensed item was sent or handed to the patient (or agent).", 0, Integer.MAX_VALUE, this.time));
        childrenList.add(new Property("destination", "Reference(Location)", "Identification of the facility/location where the Supply was shipped to, as part of the dispense event.", 0, Integer.MAX_VALUE, this.destination));
        childrenList.add(new Property(SP_RECEIVER, "Reference(Practitioner)", "Identifies the person who picked up the Supply.", 0, Integer.MAX_VALUE, this.receiver));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new SupplyDeliveryStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToSimpleQuantity(value);
        } else if (name.equals("suppliedItem")) {
            this.suppliedItem = this.castToReference(value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.supplier = this.castToReference(value);
        } else if (name.equals("whenPrepared")) {
            this.whenPrepared = this.castToPeriod(value);
        } else if (name.equals("time")) {
            this.time = this.castToDateTime(value);
        } else if (name.equals("destination")) {
            this.destination = this.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.getReceiver().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property SupplyDelivery.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("quantity")) {
            this.quantity = new SimpleQuantity();
            return this.quantity;
        }
        if (name.equals("suppliedItem")) {
            this.suppliedItem = new Reference();
            return this.suppliedItem;
        }
        if (name.equals(SP_SUPPLIER)) {
            this.supplier = new Reference();
            return this.supplier;
        }
        if (name.equals("whenPrepared")) {
            this.whenPrepared = new Period();
            return this.whenPrepared;
        }
        if (name.equals("time")) {
            throw new FHIRException("Cannot call addChild on a singleton property SupplyDelivery.time");
        }
        if (name.equals("destination")) {
            this.destination = new Reference();
            return this.destination;
        }
        if (name.equals(SP_RECEIVER)) {
            return this.addReceiver();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyDelivery";
    }

    @Override
    public SupplyDelivery copy() {
        SupplyDelivery dst = new SupplyDelivery();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.suppliedItem = this.suppliedItem == null ? null : this.suppliedItem.copy();
        dst.supplier = this.supplier == null ? null : this.supplier.copy();
        dst.whenPrepared = this.whenPrepared == null ? null : this.whenPrepared.copy();
        dst.time = this.time == null ? null : this.time.copy();
        Reference reference = dst.destination = this.destination == null ? null : this.destination.copy();
        if (this.receiver != null) {
            dst.receiver = new ArrayList<Reference>();
            for (Reference i : this.receiver) {
                dst.receiver.add(i.copy());
            }
        }
        return dst;
    }

    protected SupplyDelivery typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other;
        return SupplyDelivery.compareDeep(this.identifier, o.identifier, true) && SupplyDelivery.compareDeep(this.status, o.status, true) && SupplyDelivery.compareDeep(this.patient, o.patient, true) && SupplyDelivery.compareDeep(this.type, o.type, true) && SupplyDelivery.compareDeep(this.quantity, o.quantity, true) && SupplyDelivery.compareDeep(this.suppliedItem, o.suppliedItem, true) && SupplyDelivery.compareDeep(this.supplier, o.supplier, true) && SupplyDelivery.compareDeep(this.whenPrepared, o.whenPrepared, true) && SupplyDelivery.compareDeep(this.time, o.time, true) && SupplyDelivery.compareDeep(this.destination, o.destination, true) && SupplyDelivery.compareDeep(this.receiver, o.receiver, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof SupplyDelivery)) {
            return false;
        }
        SupplyDelivery o = (SupplyDelivery)other;
        return SupplyDelivery.compareValues(this.status, o.status, true) && SupplyDelivery.compareValues(this.time, o.time, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.type != null && !this.type.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.suppliedItem != null && !this.suppliedItem.isEmpty() || this.supplier != null && !this.supplier.isEmpty() || this.whenPrepared != null && !this.whenPrepared.isEmpty() || this.time != null && !this.time.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.receiver != null && !this.receiver.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyDelivery;
    }

    public static class SupplyDeliveryStatusEnumFactory
    implements EnumFactory<SupplyDeliveryStatus> {
        @Override
        public SupplyDeliveryStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return SupplyDeliveryStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return SupplyDeliveryStatus.COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return SupplyDeliveryStatus.ABANDONED;
            }
            throw new IllegalArgumentException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyDeliveryStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.COMPLETED);
            }
            if ("abandoned".equals(codeString)) {
                return new Enumeration<SupplyDeliveryStatus>(this, SupplyDeliveryStatus.ABANDONED);
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyDeliveryStatus code) {
            if (code == SupplyDeliveryStatus.NULL) {
                return null;
            }
            if (code == SupplyDeliveryStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == SupplyDeliveryStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyDeliveryStatus.ABANDONED) {
                return "abandoned";
            }
            return "?";
        }
    }

    public static enum SupplyDeliveryStatus {
        INPROGRESS,
        COMPLETED,
        ABANDONED,
        NULL;


        public static SupplyDeliveryStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("abandoned".equals(codeString)) {
                return ABANDONED;
            }
            throw new FHIRException("Unknown SupplyDeliveryStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ABANDONED: {
                    return "abandoned";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case ABANDONED: {
                    return "http://hl7.org/fhir/supplydelivery-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "Supply has been requested, but not delivered.";
                }
                case COMPLETED: {
                    return "Supply has been delivered (\"completed\").";
                }
                case ABANDONED: {
                    return "Dispensing was not completed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Delivered";
                }
                case ABANDONED: {
                    return "Abandoned";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

