/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BaseResource;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.utilities.Utilities;

public abstract class Resource
extends BaseResource
implements IAnyResource {
    @Child(name="id", type={IdType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id of this artifact", formalDefinition="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.")
    protected IdType id;
    @Child(name="meta", type={Meta.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Metadata about the resource", formalDefinition="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.")
    protected Meta meta;
    @Child(name="implicitRules", type={UriType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="A set of rules under which this content was created", formalDefinition="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content.")
    protected UriType implicitRules;
    @Child(name="language", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Language of the resource content", formalDefinition="The base language in which the resource is written.")
    protected CodeType language;
    private static final long serialVersionUID = -559462759L;

    public IdType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new IdType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    @Override
    public Resource setIdElement(IdType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : this.id.getValue();
    }

    public Resource setId(String value) {
        if (Utilities.noString((String)value)) {
            this.id = null;
        } else {
            if (this.id == null) {
                this.id = new IdType();
            }
            this.id.setValue(value);
        }
        return this;
    }

    public Meta getMeta() {
        if (this.meta == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.meta");
            }
            if (Configuration.doAutoCreate()) {
                this.meta = new Meta();
            }
        }
        return this.meta;
    }

    public boolean hasMeta() {
        return this.meta != null && !this.meta.isEmpty();
    }

    public Resource setMeta(Meta value) {
        this.meta = value;
        return this;
    }

    public UriType getImplicitRulesElement() {
        if (this.implicitRules == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.implicitRules");
            }
            if (Configuration.doAutoCreate()) {
                this.implicitRules = new UriType();
            }
        }
        return this.implicitRules;
    }

    public boolean hasImplicitRulesElement() {
        return this.implicitRules != null && !this.implicitRules.isEmpty();
    }

    public boolean hasImplicitRules() {
        return this.implicitRules != null && !this.implicitRules.isEmpty();
    }

    public Resource setImplicitRulesElement(UriType value) {
        this.implicitRules = value;
        return this;
    }

    public String getImplicitRules() {
        return this.implicitRules == null ? null : (String)this.implicitRules.getValue();
    }

    public Resource setImplicitRules(String value) {
        if (Utilities.noString((String)value)) {
            this.implicitRules = null;
        } else {
            if (this.implicitRules == null) {
                this.implicitRules = new UriType();
            }
            this.implicitRules.setValue(value);
        }
        return this;
    }

    public CodeType getLanguageElement() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Resource.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CodeType();
            }
        }
        return this.language;
    }

    public boolean hasLanguageElement() {
        return this.language != null && !this.language.isEmpty();
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public Resource setLanguageElement(CodeType value) {
        this.language = value;
        return this;
    }

    public String getLanguage() {
        return this.language == null ? null : (String)this.language.getValue();
    }

    public Resource setLanguage(String value) {
        if (Utilities.noString((String)value)) {
            this.language = null;
        } else {
            if (this.language == null) {
                this.language = new CodeType();
            }
            this.language.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        childrenList.add(new Property("id", "id", "The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.", 0, Integer.MAX_VALUE, this.id));
        childrenList.add(new Property("meta", "Meta", "The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content may not always be associated with version changes to the resource.", 0, Integer.MAX_VALUE, this.meta));
        childrenList.add(new Property("implicitRules", "uri", "A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content.", 0, Integer.MAX_VALUE, this.implicitRules));
        childrenList.add(new Property("language", "code", "The base language in which the resource is written.", 0, Integer.MAX_VALUE, this.language));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("id")) {
            this.id = this.castToId(value);
        } else if (name.equals("meta")) {
            this.meta = this.castToMeta(value);
        } else if (name.equals("implicitRules")) {
            this.implicitRules = this.castToUri(value);
        } else if (name.equals("language")) {
            this.language = this.castToCode(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a singleton property Resource.id");
        }
        if (name.equals("meta")) {
            this.meta = new Meta();
            return this.meta;
        }
        if (name.equals("implicitRules")) {
            throw new FHIRException("Cannot call addChild on a singleton property Resource.implicitRules");
        }
        if (name.equals("language")) {
            throw new FHIRException("Cannot call addChild on a singleton property Resource.language");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Resource";
    }

    public abstract Resource copy();

    public void copyValues(Resource dst) {
        dst.id = this.id == null ? null : this.id.copy();
        dst.meta = this.meta == null ? null : this.meta.copy();
        dst.implicitRules = this.implicitRules == null ? null : this.implicitRules.copy();
        dst.language = this.language == null ? null : this.language.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other;
        return Resource.compareDeep(this.id, o.id, true) && Resource.compareDeep(this.meta, o.meta, true) && Resource.compareDeep(this.implicitRules, o.implicitRules, true) && Resource.compareDeep(this.language, o.language, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other;
        return Resource.compareValues(this.id, o.id, true) && Resource.compareValues(this.implicitRules, o.implicitRules, true) && Resource.compareValues(this.language, o.language, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.id != null && !this.id.isEmpty() || this.meta != null && !this.meta.isEmpty() || this.implicitRules != null && !this.implicitRules.isEmpty() || this.language != null && !this.language.isEmpty());
    }

    public abstract ResourceType getResourceType();
}

