/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Medication;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationStatement", profile="http://hl7.org/fhir/Profile/MedicationStatement")
public class MedicationStatement
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is/was taking  the medication", formalDefinition="The person or animal who is/was taking the medication.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The person who provided the information about the taking of this medication.")
    protected Reference informationSource;
    protected Resource informationSourceTarget;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the statement was asserted?", formalDefinition="The date when the medication statement was asserted by the information source.")
    protected DateTimeType dateAsserted;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | entered-in-error | intended", formalDefinition="A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.")
    protected Enumeration<MedicationStatementStatus> status;
    @Child(name="wasNotTaken", type={BooleanType.class}, order=5, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if medication is/was not being taken", formalDefinition="Set this to true if the record is saying that the medication was NOT taken.")
    protected BooleanType wasNotTaken;
    @Child(name="reasonNotTaken", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="True if asserting medication was not given", formalDefinition="A code indicating why the medication was not taken.")
    protected List<CodeableConcept> reasonNotTaken;
    @Child(name="reasonForUse", type={CodeableConcept.class, Condition.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="A reason for why the medication is being/was taken.")
    protected Type reasonForUse;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Over what period was medication consumed?", formalDefinition="The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).")
    protected Type effective;
    @Child(name="note", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Further information about the statement", formalDefinition="Provides extra information about the medication statement that is not conveyed by the other attributes.")
    protected StringType note;
    @Child(name="supportingInformation", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional supporting information", formalDefinition="Allows linking the MedicationStatement to the underlying MedicationOrder, or to other information that supports the MedicationStatement.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What medication was taken", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    protected Type medication;
    @Child(name="dosage", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Indicates how the medication is/was used by the patient.")
    protected List<MedicationStatementDosageComponent> dosage;
    private static final long serialVersionUID = 55795672L;
    @SearchParamDefinition(name="identifier", path="MedicationStatement.identifier", description="Return statements with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="MedicationStatement.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="patient", path="MedicationStatement.patient", description="The identity of a patient to list statements  for", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="medication", path="MedicationStatement.medicationReference", description="Return administrations of this medication reference", type="reference")
    public static final String SP_MEDICATION = "medication";
    @SearchParamDefinition(name="source", path="MedicationStatement.informationSource", description="Who the information in the statement came from", type="reference")
    public static final String SP_SOURCE = "source";
    @SearchParamDefinition(name="effectivedate", path="MedicationStatement.effective[x]", description="Date when patient was taking (or not taking) the medication", type="date")
    public static final String SP_EFFECTIVEDATE = "effectivedate";
    @SearchParamDefinition(name="status", path="MedicationStatement.status", description="Return statements that match the given status", type="token")
    public static final String SP_STATUS = "status";

    public MedicationStatement() {
    }

    public MedicationStatement(Reference patient, Enumeration<MedicationStatementStatus> status, Type medication) {
        this.patient = patient;
        this.status = status;
        this.medication = medication;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MedicationStatement setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public MedicationStatement setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getInformationSource() {
        if (this.informationSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.informationSource");
            }
            if (Configuration.doAutoCreate()) {
                this.informationSource = new Reference();
            }
        }
        return this.informationSource;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public MedicationStatement setInformationSource(Reference value) {
        this.informationSource = value;
        return this;
    }

    public Resource getInformationSourceTarget() {
        return this.informationSourceTarget;
    }

    public MedicationStatement setInformationSourceTarget(Resource value) {
        this.informationSourceTarget = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public MedicationStatement setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public MedicationStatement setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public Enumeration<MedicationStatementStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationStatementStatus>(new MedicationStatementStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationStatement setStatusElement(Enumeration<MedicationStatementStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationStatementStatus getStatus() {
        return this.status == null ? null : (MedicationStatementStatus)((Object)this.status.getValue());
    }

    public MedicationStatement setStatus(MedicationStatementStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MedicationStatementStatus>(new MedicationStatementStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getWasNotTakenElement() {
        if (this.wasNotTaken == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.wasNotTaken");
            }
            if (Configuration.doAutoCreate()) {
                this.wasNotTaken = new BooleanType();
            }
        }
        return this.wasNotTaken;
    }

    public boolean hasWasNotTakenElement() {
        return this.wasNotTaken != null && !this.wasNotTaken.isEmpty();
    }

    public boolean hasWasNotTaken() {
        return this.wasNotTaken != null && !this.wasNotTaken.isEmpty();
    }

    public MedicationStatement setWasNotTakenElement(BooleanType value) {
        this.wasNotTaken = value;
        return this;
    }

    public boolean getWasNotTaken() {
        return this.wasNotTaken == null || this.wasNotTaken.isEmpty() ? false : (Boolean)this.wasNotTaken.getValue();
    }

    public MedicationStatement setWasNotTaken(boolean value) {
        if (this.wasNotTaken == null) {
            this.wasNotTaken = new BooleanType();
        }
        this.wasNotTaken.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotTaken;
    }

    public boolean hasReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonNotTaken) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonNotTaken() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        this.reasonNotTaken.add(t);
        return t;
    }

    public MedicationStatement addReasonNotTaken(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        this.reasonNotTaken.add(t);
        return this;
    }

    public Type getReasonForUse() {
        return this.reasonForUse;
    }

    public CodeableConcept getReasonForUseCodeableConcept() throws FHIRException {
        if (!(this.reasonForUse instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reasonForUse.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reasonForUse;
    }

    public boolean hasReasonForUseCodeableConcept() {
        return this.reasonForUse instanceof CodeableConcept;
    }

    public Reference getReasonForUseReference() throws FHIRException {
        if (!(this.reasonForUse instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reasonForUse.getClass().getName() + " was encountered");
        }
        return (Reference)this.reasonForUse;
    }

    public boolean hasReasonForUseReference() {
        return this.reasonForUse instanceof Reference;
    }

    public boolean hasReasonForUse() {
        return this.reasonForUse != null && !this.reasonForUse.isEmpty();
    }

    public MedicationStatement setReasonForUse(Type value) {
        this.reasonForUse = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public MedicationStatement setEffective(Type value) {
        this.effective = value;
        return this;
    }

    public StringType getNoteElement() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationStatement.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new StringType();
            }
        }
        return this.note;
    }

    public boolean hasNoteElement() {
        return this.note != null && !this.note.isEmpty();
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public MedicationStatement setNoteElement(StringType value) {
        this.note = value;
        return this;
    }

    public String getNote() {
        return this.note == null ? null : (String)this.note.getValue();
    }

    public MedicationStatement setNote(String value) {
        if (Utilities.noString((String)value)) {
            this.note = null;
        } else {
            if (this.note == null) {
                this.note = new StringType();
            }
            this.note.setValue(value);
        }
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public MedicationStatement addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationStatement setMedication(Type value) {
        this.medication = value;
        return this;
    }

    public List<MedicationStatementDosageComponent> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosageComponent>();
        }
        return this.dosage;
    }

    public boolean hasDosage() {
        if (this.dosage == null) {
            return false;
        }
        for (MedicationStatementDosageComponent item : this.dosage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationStatementDosageComponent addDosage() {
        MedicationStatementDosageComponent t = new MedicationStatementDosageComponent();
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosageComponent>();
        }
        this.dosage.add(t);
        return t;
    }

    public MedicationStatement addDosage(MedicationStatementDosageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosageComponent>();
        }
        this.dosage.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The person or animal who is/was taking the medication.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("informationSource", "Reference(Patient|Practitioner|RelatedPerson)", "The person who provided the information about the taking of this medication.", 0, Integer.MAX_VALUE, this.informationSource));
        childrenList.add(new Property("dateAsserted", "dateTime", "The date when the medication statement was asserted by the information source.", 0, Integer.MAX_VALUE, this.dateAsserted));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "A code representing the patient or other source's judgment about the state of the medication used that this statement is about.  Generally this will be active or completed.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("wasNotTaken", "boolean", "Set this to true if the record is saying that the medication was NOT taken.", 0, Integer.MAX_VALUE, this.wasNotTaken));
        childrenList.add(new Property("reasonNotTaken", "CodeableConcept", "A code indicating why the medication was not taken.", 0, Integer.MAX_VALUE, this.reasonNotTaken));
        childrenList.add(new Property("reasonForUse[x]", "CodeableConcept|Reference(Condition)", "A reason for why the medication is being/was taken.", 0, Integer.MAX_VALUE, this.reasonForUse));
        childrenList.add(new Property("effective[x]", "dateTime|Period", "The interval of time during which it is being asserted that the patient was taking the medication (or was not taking, when the wasNotGiven element is true).", 0, Integer.MAX_VALUE, this.effective));
        childrenList.add(new Property("note", "string", "Provides extra information about the medication statement that is not conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("supportingInformation", "Reference(Any)", "Allows linking the MedicationStatement to the underlying MedicationOrder, or to other information that supports the MedicationStatement.", 0, Integer.MAX_VALUE, this.supportingInformation));
        childrenList.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        childrenList.add(new Property("dosage", "", "Indicates how the medication is/was used by the patient.", 0, Integer.MAX_VALUE, this.dosage));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("informationSource")) {
            this.informationSource = this.castToReference(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = this.castToDateTime(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new MedicationStatementStatusEnumFactory().fromType(value);
        } else if (name.equals("wasNotTaken")) {
            this.wasNotTaken = this.castToBoolean(value);
        } else if (name.equals("reasonNotTaken")) {
            this.getReasonNotTaken().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonForUse[x]")) {
            this.reasonForUse = (Type)value;
        } else if (name.equals("effective[x]")) {
            this.effective = (Type)value;
        } else if (name.equals("note")) {
            this.note = this.castToString(value);
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else if (name.equals("medication[x]")) {
            this.medication = (Type)value;
        } else if (name.equals("dosage")) {
            this.getDosage().add((MedicationStatementDosageComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("informationSource")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.dateAsserted");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.status");
        }
        if (name.equals("wasNotTaken")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.wasNotTaken");
        }
        if (name.equals("reasonNotTaken")) {
            return this.addReasonNotTaken();
        }
        if (name.equals("reasonForUseCodeableConcept")) {
            this.reasonForUse = new CodeableConcept();
            return this.reasonForUse;
        }
        if (name.equals("reasonForUseReference")) {
            this.reasonForUse = new Reference();
            return this.reasonForUse;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals("note")) {
            throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.note");
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals("dosage")) {
            return this.addDosage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationStatement";
    }

    @Override
    public MedicationStatement copy() {
        MedicationStatement dst = new MedicationStatement();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        dst.status = this.status == null ? null : this.status.copy();
        BooleanType booleanType = dst.wasNotTaken = this.wasNotTaken == null ? null : this.wasNotTaken.copy();
        if (this.reasonNotTaken != null) {
            dst.reasonNotTaken = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonNotTaken) {
                dst.reasonNotTaken.add(codeableConcept.copy());
            }
        }
        dst.reasonForUse = this.reasonForUse == null ? null : this.reasonForUse.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        StringType stringType = dst.note = this.note == null ? null : this.note.copy();
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference : this.supportingInformation) {
                dst.supportingInformation.add(reference.copy());
            }
        }
        Type type = dst.medication = this.medication == null ? null : this.medication.copy();
        if (this.dosage != null) {
            dst.dosage = new ArrayList<MedicationStatementDosageComponent>();
            for (MedicationStatementDosageComponent medicationStatementDosageComponent : this.dosage) {
                dst.dosage.add(medicationStatementDosageComponent.copy());
            }
        }
        return dst;
    }

    protected MedicationStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other;
        return MedicationStatement.compareDeep(this.identifier, o.identifier, true) && MedicationStatement.compareDeep(this.patient, o.patient, true) && MedicationStatement.compareDeep(this.informationSource, o.informationSource, true) && MedicationStatement.compareDeep(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareDeep(this.status, o.status, true) && MedicationStatement.compareDeep(this.wasNotTaken, o.wasNotTaken, true) && MedicationStatement.compareDeep(this.reasonNotTaken, o.reasonNotTaken, true) && MedicationStatement.compareDeep(this.reasonForUse, o.reasonForUse, true) && MedicationStatement.compareDeep(this.effective, o.effective, true) && MedicationStatement.compareDeep(this.note, o.note, true) && MedicationStatement.compareDeep(this.supportingInformation, o.supportingInformation, true) && MedicationStatement.compareDeep(this.medication, o.medication, true) && MedicationStatement.compareDeep(this.dosage, o.dosage, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MedicationStatement)) {
            return false;
        }
        MedicationStatement o = (MedicationStatement)other;
        return MedicationStatement.compareValues(this.dateAsserted, o.dateAsserted, true) && MedicationStatement.compareValues(this.status, o.status, true) && MedicationStatement.compareValues(this.wasNotTaken, o.wasNotTaken, true) && MedicationStatement.compareValues(this.note, o.note, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.informationSource != null && !this.informationSource.isEmpty() || this.dateAsserted != null && !this.dateAsserted.isEmpty() || this.status != null && !this.status.isEmpty() || this.wasNotTaken != null && !this.wasNotTaken.isEmpty() || this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() || this.reasonForUse != null && !this.reasonForUse.isEmpty() || this.effective != null && !this.effective.isEmpty() || this.note != null && !this.note.isEmpty() || this.supportingInformation != null && !this.supportingInformation.isEmpty() || this.medication != null && !this.medication.isEmpty() || this.dosage != null && !this.dosage.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationStatement;
    }

    @Block
    public static class MedicationStatementDosageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reported dosage information", formalDefinition="Free text dosage information as reported about a patient's medication use. When coded dosage information is present, the free text may still be present for display to humans.")
        protected StringType text;
        @Child(name="timing", type={Timing.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When/how often was medication taken", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
        protected Timing timing;
        @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Take \"as needed\" (for x)", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  \n\nSpecifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.")
        protected Type asNeeded;
        @Child(name="site", type={CodeableConcept.class, BodySite.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where (on body) medication is/was administered", formalDefinition="A coded specification of or a reference to the anatomic site where the medication first enters the body.")
        protected Type site;
        @Child(name="route", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How the medication entered the body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Technique used to administer medication", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        protected CodeableConcept method;
        @Child(name="quantity", type={SimpleQuantity.class, Range.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount administered in one dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        protected Type quantity;
        @Child(name="rate", type={Ratio.class, Range.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected Type rate;
        @Child(name="maxDosePerPeriod", type={Ratio.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Maximum dose that was consumed per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.")
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = 246880733L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementDosageComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationStatementDosageComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationStatementDosageComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Timing getTiming() {
            if (this.timing == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementDosageComponent.timing");
                }
                if (Configuration.doAutoCreate()) {
                    this.timing = new Timing();
                }
            }
            return this.timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public MedicationStatementDosageComponent setTiming(Timing value) {
            this.timing = value;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public BooleanType getAsNeededBooleanType() throws FHIRException {
            if (!(this.asNeeded instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.asNeeded;
        }

        public boolean hasAsNeededBooleanType() {
            return this.asNeeded instanceof BooleanType;
        }

        public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
            if (!(this.asNeeded instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.asNeeded;
        }

        public boolean hasAsNeededCodeableConcept() {
            return this.asNeeded instanceof CodeableConcept;
        }

        public boolean hasAsNeeded() {
            return this.asNeeded != null && !this.asNeeded.isEmpty();
        }

        public MedicationStatementDosageComponent setAsNeeded(Type value) {
            this.asNeeded = value;
            return this;
        }

        public Type getSite() {
            return this.site;
        }

        public CodeableConcept getSiteCodeableConcept() throws FHIRException {
            if (!(this.site instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.site;
        }

        public boolean hasSiteCodeableConcept() {
            return this.site instanceof CodeableConcept;
        }

        public Reference getSiteReference() throws FHIRException {
            if (!(this.site instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (Reference)this.site;
        }

        public boolean hasSiteReference() {
            return this.site instanceof Reference;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationStatementDosageComponent setSite(Type value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementDosageComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationStatementDosageComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementDosageComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationStatementDosageComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public Type getQuantity() {
            return this.quantity;
        }

        public SimpleQuantity getQuantitySimpleQuantity() throws FHIRException {
            if (!(this.quantity instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.quantity.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.quantity;
        }

        public boolean hasQuantitySimpleQuantity() {
            return this.quantity instanceof SimpleQuantity;
        }

        public Range getQuantityRange() throws FHIRException {
            if (!(this.quantity instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.quantity.getClass().getName() + " was encountered");
            }
            return (Range)this.quantity;
        }

        public boolean hasQuantityRange() {
            return this.quantity instanceof Range;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationStatementDosageComponent setQuantity(Type value) {
            this.quantity = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public Range getRateRange() throws FHIRException {
            if (!(this.rate instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Range)this.rate;
        }

        public boolean hasRateRange() {
            return this.rate instanceof Range;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationStatementDosageComponent setRate(Type value) {
            this.rate = value;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            if (this.maxDosePerPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationStatementDosageComponent.maxDosePerPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerPeriod = new Ratio();
                }
            }
            return this.maxDosePerPeriod;
        }

        public boolean hasMaxDosePerPeriod() {
            return this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty();
        }

        public MedicationStatementDosageComponent setMaxDosePerPeriod(Ratio value) {
            this.maxDosePerPeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("text", "string", "Free text dosage information as reported about a patient's medication use. When coded dosage information is present, the free text may still be present for display to humans.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("timing", "Timing", "The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, Integer.MAX_VALUE, this.timing));
            childrenList.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  \n\nSpecifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.", 0, Integer.MAX_VALUE, this.asNeeded));
            childrenList.add(new Property("site[x]", "CodeableConcept|Reference(BodySite)", "A coded specification of or a reference to the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            childrenList.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.", 0, Integer.MAX_VALUE, this.route));
            childrenList.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("quantity[x]", "SimpleQuantity|Range", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("rate[x]", "Ratio|Range", "Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, Integer.MAX_VALUE, this.rate));
            childrenList.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("timing")) {
                this.timing = this.castToTiming(value);
            } else if (name.equals("asNeeded[x]")) {
                this.asNeeded = (Type)value;
            } else if (name.equals("site[x]")) {
                this.site = (Type)value;
            } else if (name.equals("route")) {
                this.route = this.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("quantity[x]")) {
                this.quantity = (Type)value;
            } else if (name.equals("rate[x]")) {
                this.rate = (Type)value;
            } else if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = this.castToRatio(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property MedicationStatement.text");
            }
            if (name.equals("timing")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("asNeededBoolean")) {
                this.asNeeded = new BooleanType();
                return this.asNeeded;
            }
            if (name.equals("asNeededCodeableConcept")) {
                this.asNeeded = new CodeableConcept();
                return this.asNeeded;
            }
            if (name.equals("siteCodeableConcept")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("siteReference")) {
                this.site = new Reference();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("quantitySimpleQuantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("quantityRange")) {
                this.quantity = new Range();
                return this.quantity;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateRange")) {
                this.rate = new Range();
                return this.rate;
            }
            if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = new Ratio();
                return this.maxDosePerPeriod;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationStatementDosageComponent copy() {
            MedicationStatementDosageComponent dst = new MedicationStatementDosageComponent();
            this.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            dst.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationStatementDosageComponent)) {
                return false;
            }
            MedicationStatementDosageComponent o = (MedicationStatementDosageComponent)other;
            return MedicationStatementDosageComponent.compareDeep(this.text, o.text, true) && MedicationStatementDosageComponent.compareDeep(this.timing, o.timing, true) && MedicationStatementDosageComponent.compareDeep(this.asNeeded, o.asNeeded, true) && MedicationStatementDosageComponent.compareDeep(this.site, o.site, true) && MedicationStatementDosageComponent.compareDeep(this.route, o.route, true) && MedicationStatementDosageComponent.compareDeep(this.method, o.method, true) && MedicationStatementDosageComponent.compareDeep(this.quantity, o.quantity, true) && MedicationStatementDosageComponent.compareDeep(this.rate, o.rate, true) && MedicationStatementDosageComponent.compareDeep(this.maxDosePerPeriod, o.maxDosePerPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationStatementDosageComponent)) {
                return false;
            }
            MedicationStatementDosageComponent o = (MedicationStatementDosageComponent)other;
            return MedicationStatementDosageComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.text != null && !this.text.isEmpty() || this.timing != null && !this.timing.isEmpty() || this.asNeeded != null && !this.asNeeded.isEmpty() || this.site != null && !this.site.isEmpty() || this.route != null && !this.route.isEmpty() || this.method != null && !this.method.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.rate != null && !this.rate.isEmpty() || this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationStatement.dosage";
        }
    }

    public static class MedicationStatementStatusEnumFactory
    implements EnumFactory<MedicationStatementStatus> {
        @Override
        public MedicationStatementStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationStatementStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return MedicationStatementStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationStatementStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return MedicationStatementStatus.INTENDED;
            }
            throw new IllegalArgumentException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationStatementStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.ENTEREDINERROR);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<MedicationStatementStatus>(this, MedicationStatementStatus.INTENDED);
            }
            throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatementStatus code) {
            if (code == MedicationStatementStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationStatementStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationStatementStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationStatementStatus.INTENDED) {
                return "intended";
            }
            return "?";
        }
    }

    public static enum MedicationStatementStatus {
        ACTIVE,
        COMPLETED,
        ENTEREDINERROR,
        INTENDED,
        NULL;


        public static MedicationStatementStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            throw new FHIRException("Unknown MedicationStatementStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/medication-statement-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is still being taken.";
                }
                case COMPLETED: {
                    return "The medication is no longer being taken.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error.";
                }
                case INTENDED: {
                    return "The medication may be taken at some time in the future.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

