/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ConceptMap", profile="http://hl7.org/fhir/Profile/ConceptMap")
public class ConceptMap
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical id for concept map", formalDefinition="An absolute URL that is used to identify this concept map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this concept map is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the concept map", formalDefinition="Formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical id for this version of the concept map", formalDefinition="The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this concept map", formalDefinition="A free text natural language name describing the concept map.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the concept map.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This ConceptMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the individual or organization that published the concept map.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ConceptMapContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for given status", formalDefinition="The date this version of the concept map was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.")
    protected DateTimeType date;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human language description of the concept map", formalDefinition="A free text natural language description of the use of the concept map - reason for definition, conditions of use, etc.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of concept map instances.")
    protected List<CodeableConcept> useContext;
    @Child(name="requirements", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why needed", formalDefinition="Explains why this concept map is needed and why it has been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the concept map and/or its contents.")
    protected StringType copyright;
    @Child(name="source", type={UriType.class, ValueSet.class, StructureDefinition.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies the source of the concepts which are being mapped", formalDefinition="The source value set that specifies the concepts that are being mapped.")
    protected Type source;
    @Child(name="target", type={UriType.class, ValueSet.class, StructureDefinition.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Provides context to the mappings", formalDefinition="The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.")
    protected Type target;
    @Child(name="element", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Mappings for a concept from the source set", formalDefinition="Mappings for an individual concept in the source to one or more concepts in the target.")
    protected List<SourceElementComponent> element;
    private static final long serialVersionUID = 1687563642L;
    @SearchParamDefinition(name="date", path="ConceptMap.date", description="The concept map publication date", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="ConceptMap.identifier", description="Additional identifier for the concept map", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="product", path="ConceptMap.element.target.product.element", description="Reference to element/field/ValueSet mapping depends on", type="uri")
    public static final String SP_PRODUCT = "product";
    @SearchParamDefinition(name="dependson", path="ConceptMap.element.target.dependsOn.element", description="Reference to element/field/ValueSet mapping depends on", type="uri")
    public static final String SP_DEPENDSON = "dependson";
    @SearchParamDefinition(name="description", path="ConceptMap.description", description="Text search in the description of the concept map", type="string")
    public static final String SP_DESCRIPTION = "description";
    @SearchParamDefinition(name="targetsystem", path="ConceptMap.element.target.codeSystem", description="System of the target (if necessary)", type="uri")
    public static final String SP_TARGETSYSTEM = "targetsystem";
    @SearchParamDefinition(name="source", path="ConceptMap.sourceReference", description="Identifies the source of the concepts which are being mapped", type="reference")
    public static final String SP_SOURCE = "source";
    @SearchParamDefinition(name="version", path="ConceptMap.version", description="The version identifier of the concept map", type="token")
    public static final String SP_VERSION = "version";
    @SearchParamDefinition(name="sourcesystem", path="ConceptMap.element.codeSystem", description="Code System (if value set crosses code systems)", type="uri")
    public static final String SP_SOURCESYSTEM = "sourcesystem";
    @SearchParamDefinition(name="url", path="ConceptMap.url", description="The URL of the concept map", type="uri")
    public static final String SP_URL = "url";
    @SearchParamDefinition(name="target", path="ConceptMap.target[x]", description="Provides context to the mappings", type="reference")
    public static final String SP_TARGET = "target";
    @SearchParamDefinition(name="sourcecode", path="ConceptMap.element.code", description="Identifies element being mapped", type="token")
    public static final String SP_SOURCECODE = "sourcecode";
    @SearchParamDefinition(name="sourceuri", path="ConceptMap.sourceUri", description="Identifies the source of the concepts which are being mapped", type="reference")
    public static final String SP_SOURCEURI = "sourceuri";
    @SearchParamDefinition(name="name", path="ConceptMap.name", description="Name of the concept map", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="context", path="ConceptMap.useContext", description="A use context assigned to the concept map", type="token")
    public static final String SP_CONTEXT = "context";
    @SearchParamDefinition(name="publisher", path="ConceptMap.publisher", description="Name of the publisher of the concept map", type="string")
    public static final String SP_PUBLISHER = "publisher";
    @SearchParamDefinition(name="targetcode", path="ConceptMap.element.target.code", description="Code that identifies the target element", type="token")
    public static final String SP_TARGETCODE = "targetcode";
    @SearchParamDefinition(name="status", path="ConceptMap.status", description="Status of the concept map", type="token")
    public static final String SP_STATUS = "status";

    public ConceptMap() {
    }

    public ConceptMap(Enumeration<Enumerations.ConformanceResourceStatus> status, Type source, Type target) {
        this.status = status;
        this.source = source;
        this.target = target;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ConceptMap setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ConceptMap setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ConceptMap setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ConceptMap setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ConceptMap setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ConceptMap setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ConceptMap setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ConceptMap setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public ConceptMap setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ConceptMap setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ConceptMap setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ConceptMap setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ConceptMap setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ConceptMapContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ConceptMapContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ConceptMapContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConceptMapContactComponent addContact() {
        ConceptMapContactComponent t = new ConceptMapContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ConceptMapContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ConceptMap addContact(ConceptMapContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ConceptMapContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ConceptMap setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ConceptMap setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ConceptMap setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ConceptMap setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public ConceptMap addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public ConceptMap setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public ConceptMap setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ConceptMap.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ConceptMap setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ConceptMap setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Type getSource() {
        return this.source;
    }

    public UriType getSourceUriType() throws FHIRException {
        if (!(this.source instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (UriType)this.source;
    }

    public boolean hasSourceUriType() {
        return this.source instanceof UriType;
    }

    public Reference getSourceReference() throws FHIRException {
        if (!(this.source instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
        }
        return (Reference)this.source;
    }

    public boolean hasSourceReference() {
        return this.source instanceof Reference;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public ConceptMap setSource(Type value) {
        this.source = value;
        return this;
    }

    public Type getTarget() {
        return this.target;
    }

    public UriType getTargetUriType() throws FHIRException {
        if (!(this.target instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (UriType)this.target;
    }

    public boolean hasTargetUriType() {
        return this.target instanceof UriType;
    }

    public Reference getTargetReference() throws FHIRException {
        if (!(this.target instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Reference)this.target;
    }

    public boolean hasTargetReference() {
        return this.target instanceof Reference;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ConceptMap setTarget(Type value) {
        this.target = value;
        return this;
    }

    public List<SourceElementComponent> getElement() {
        if (this.element == null) {
            this.element = new ArrayList<SourceElementComponent>();
        }
        return this.element;
    }

    public boolean hasElement() {
        if (this.element == null) {
            return false;
        }
        for (SourceElementComponent item : this.element) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SourceElementComponent addElement() {
        SourceElementComponent t = new SourceElementComponent();
        if (this.element == null) {
            this.element = new ArrayList<SourceElementComponent>();
        }
        this.element.add(t);
        return t;
    }

    public ConceptMap addElement(SourceElementComponent t) {
        if (t == null) {
            return this;
        }
        if (this.element == null) {
            this.element = new ArrayList<SourceElementComponent>();
        }
        this.element.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this concept map when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this concept map is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this concept map when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the concept map when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name describing the concept map.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the concept map.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "This ConceptMap was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the concept map.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date this version of the concept map was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the concept map changes.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the use of the concept map - reason for definition, conditions of use, etc.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of concept map instances.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("requirements", "string", "Explains why this concept map is needed and why it has been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the concept map and/or its contents.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("source[x]", "uri|Reference(ValueSet|StructureDefinition)", "The source value set that specifies the concepts that are being mapped.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property("target[x]", "uri|Reference(ValueSet|StructureDefinition)", "The target value set provides context to the mappings. Note that the mapping is made between concepts, not between value sets, but the value set provides important context about how the concept mapping choices are made.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("element", "", "Mappings for an individual concept in the source to one or more concepts in the target.", 0, Integer.MAX_VALUE, this.element));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ConceptMapContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("source[x]")) {
            this.source = (Type)value;
        } else if (name.equals("target[x]")) {
            this.target = (Type)value;
        } else if (name.equals("element")) {
            this.getElement().add((SourceElementComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.date");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.copyright");
        }
        if (name.equals("sourceUri")) {
            this.source = new UriType();
            return this.source;
        }
        if (name.equals("sourceReference")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals("targetUri")) {
            this.target = new UriType();
            return this.target;
        }
        if (name.equals("targetReference")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("element")) {
            return this.addElement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ConceptMap";
    }

    @Override
    public ConceptMap copy() {
        ConceptMap dst = new ConceptMap();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ConceptMapContactComponent>();
            for (ConceptMapContactComponent conceptMapContactComponent : this.contact) {
                dst.contact.add(conceptMapContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Type type = dst.target = this.target == null ? null : this.target.copy();
        if (this.element != null) {
            dst.element = new ArrayList<SourceElementComponent>();
            for (SourceElementComponent sourceElementComponent : this.element) {
                dst.element.add(sourceElementComponent.copy());
            }
        }
        return dst;
    }

    protected ConceptMap typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other;
        return ConceptMap.compareDeep(this.url, o.url, true) && ConceptMap.compareDeep(this.identifier, o.identifier, true) && ConceptMap.compareDeep(this.version, o.version, true) && ConceptMap.compareDeep(this.name, o.name, true) && ConceptMap.compareDeep(this.status, o.status, true) && ConceptMap.compareDeep(this.experimental, o.experimental, true) && ConceptMap.compareDeep(this.publisher, o.publisher, true) && ConceptMap.compareDeep(this.contact, o.contact, true) && ConceptMap.compareDeep(this.date, o.date, true) && ConceptMap.compareDeep(this.description, o.description, true) && ConceptMap.compareDeep(this.useContext, o.useContext, true) && ConceptMap.compareDeep(this.requirements, o.requirements, true) && ConceptMap.compareDeep(this.copyright, o.copyright, true) && ConceptMap.compareDeep(this.source, o.source, true) && ConceptMap.compareDeep(this.target, o.target, true) && ConceptMap.compareDeep(this.element, o.element, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ConceptMap)) {
            return false;
        }
        ConceptMap o = (ConceptMap)other;
        return ConceptMap.compareValues(this.url, o.url, true) && ConceptMap.compareValues(this.version, o.version, true) && ConceptMap.compareValues(this.name, o.name, true) && ConceptMap.compareValues(this.status, o.status, true) && ConceptMap.compareValues(this.experimental, o.experimental, true) && ConceptMap.compareValues(this.publisher, o.publisher, true) && ConceptMap.compareValues(this.date, o.date, true) && ConceptMap.compareValues(this.description, o.description, true) && ConceptMap.compareValues(this.requirements, o.requirements, true) && ConceptMap.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.source != null && !this.source.isEmpty() || this.target != null && !this.target.isEmpty() || this.element != null && !this.element.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ConceptMap;
    }

    @Block
    public static class OtherElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="element", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to element/field/ValueSet mapping depends on", formalDefinition="A reference to a specific concept that holds a coded value. This can be an element in a FHIR resource, or a specific reference to a data element in a different specification (e.g. HL7 v2) or a general reference to a kind of data field, or a reference to a value set with an appropriately narrow definition.")
        protected UriType element;
        @Child(name="codeSystem", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code System (if necessary)", formalDefinition="An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).")
        protected UriType codeSystem;
        @Child(name="code", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the referenced element", formalDefinition="Identity (code or path) or the element/item/ValueSet that the map depends on / refers to.")
        protected StringType code;
        private static final long serialVersionUID = 1488522448L;

        public OtherElementComponent() {
        }

        public OtherElementComponent(UriType element, UriType codeSystem, StringType code) {
            this.element = element;
            this.codeSystem = codeSystem;
            this.code = code;
        }

        public UriType getElementElement() {
            if (this.element == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.element");
                }
                if (Configuration.doAutoCreate()) {
                    this.element = new UriType();
                }
            }
            return this.element;
        }

        public boolean hasElementElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public boolean hasElement() {
            return this.element != null && !this.element.isEmpty();
        }

        public OtherElementComponent setElementElement(UriType value) {
            this.element = value;
            return this;
        }

        public String getElement() {
            return this.element == null ? null : (String)this.element.getValue();
        }

        public OtherElementComponent setElement(String value) {
            if (this.element == null) {
                this.element = new UriType();
            }
            this.element.setValue(value);
            return this;
        }

        public UriType getCodeSystemElement() {
            if (this.codeSystem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.codeSystem");
                }
                if (Configuration.doAutoCreate()) {
                    this.codeSystem = new UriType();
                }
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystemElement() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public boolean hasCodeSystem() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public OtherElementComponent setCodeSystemElement(UriType value) {
            this.codeSystem = value;
            return this;
        }

        public String getCodeSystem() {
            return this.codeSystem == null ? null : (String)this.codeSystem.getValue();
        }

        public OtherElementComponent setCodeSystem(String value) {
            if (this.codeSystem == null) {
                this.codeSystem = new UriType();
            }
            this.codeSystem.setValue(value);
            return this;
        }

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OtherElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OtherElementComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public OtherElementComponent setCode(String value) {
            if (this.code == null) {
                this.code = new StringType();
            }
            this.code.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("element", "uri", "A reference to a specific concept that holds a coded value. This can be an element in a FHIR resource, or a specific reference to a data element in a different specification (e.g. HL7 v2) or a general reference to a kind of data field, or a reference to a value set with an appropriately narrow definition.", 0, Integer.MAX_VALUE, this.element));
            childrenList.add(new Property("codeSystem", "uri", "An absolute URI that identifies the code system of the dependency code (if the source/dependency is a value set that crosses code systems).", 0, Integer.MAX_VALUE, this.codeSystem));
            childrenList.add(new Property("code", "string", "Identity (code or path) or the element/item/ValueSet that the map depends on / refers to.", 0, Integer.MAX_VALUE, this.code));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("element")) {
                this.element = this.castToUri(value);
            } else if (name.equals("codeSystem")) {
                this.codeSystem = this.castToUri(value);
            } else if (name.equals("code")) {
                this.code = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("element")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.element");
            }
            if (name.equals("codeSystem")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.codeSystem");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.code");
            }
            return super.addChild(name);
        }

        @Override
        public OtherElementComponent copy() {
            OtherElementComponent dst = new OtherElementComponent();
            this.copyValues(dst);
            dst.element = this.element == null ? null : this.element.copy();
            dst.codeSystem = this.codeSystem == null ? null : this.codeSystem.copy();
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other;
            return OtherElementComponent.compareDeep(this.element, o.element, true) && OtherElementComponent.compareDeep(this.codeSystem, o.codeSystem, true) && OtherElementComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OtherElementComponent)) {
                return false;
            }
            OtherElementComponent o = (OtherElementComponent)other;
            return OtherElementComponent.compareValues(this.element, o.element, true) && OtherElementComponent.compareValues(this.codeSystem, o.codeSystem, true) && OtherElementComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.element != null && !this.element.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.code != null && !this.code.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ConceptMap.element.target.dependsOn";
        }
    }

    @Block
    public static class TargetElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="codeSystem", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="System of the target (if necessary)", formalDefinition="An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems).")
        protected UriType codeSystem;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies the target element", formalDefinition="Identity (code or path) or the element/item that the map refers to.")
        protected CodeType code;
        @Child(name="equivalence", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="equivalent | equal | wider | subsumes | narrower | specializes | inexact | unmatched | disjoint", formalDefinition="The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).")
        protected Enumeration<Enumerations.ConceptMapEquivalence> equivalence;
        @Child(name="comments", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of status/issues in mapping", formalDefinition="A description of status/issues in mapping that conveys additional information not represented in  the structured data.")
        protected StringType comments;
        @Child(name="dependsOn", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other elements required for this mapping (from context)", formalDefinition="A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.")
        protected List<OtherElementComponent> dependsOn;
        @Child(name="product", type={OtherElementComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Other concepts that this mapping also produces", formalDefinition="A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.")
        protected List<OtherElementComponent> product;
        private static final long serialVersionUID = -804990059L;

        public TargetElementComponent() {
        }

        public TargetElementComponent(Enumeration<Enumerations.ConceptMapEquivalence> equivalence) {
            this.equivalence = equivalence;
        }

        public UriType getCodeSystemElement() {
            if (this.codeSystem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.codeSystem");
                }
                if (Configuration.doAutoCreate()) {
                    this.codeSystem = new UriType();
                }
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystemElement() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public boolean hasCodeSystem() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public TargetElementComponent setCodeSystemElement(UriType value) {
            this.codeSystem = value;
            return this;
        }

        public String getCodeSystem() {
            return this.codeSystem == null ? null : (String)this.codeSystem.getValue();
        }

        public TargetElementComponent setCodeSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.codeSystem = null;
            } else {
                if (this.codeSystem == null) {
                    this.codeSystem = new UriType();
                }
                this.codeSystem.setValue(value);
            }
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TargetElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TargetElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.ConceptMapEquivalence> getEquivalenceElement() {
            if (this.equivalence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.equivalence");
                }
                if (Configuration.doAutoCreate()) {
                    this.equivalence = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
                }
            }
            return this.equivalence;
        }

        public boolean hasEquivalenceElement() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public boolean hasEquivalence() {
            return this.equivalence != null && !this.equivalence.isEmpty();
        }

        public TargetElementComponent setEquivalenceElement(Enumeration<Enumerations.ConceptMapEquivalence> value) {
            this.equivalence = value;
            return this;
        }

        public Enumerations.ConceptMapEquivalence getEquivalence() {
            return this.equivalence == null ? null : (Enumerations.ConceptMapEquivalence)((Object)this.equivalence.getValue());
        }

        public TargetElementComponent setEquivalence(Enumerations.ConceptMapEquivalence value) {
            if (this.equivalence == null) {
                this.equivalence = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
            }
            this.equivalence.setValue((Object)value);
            return this;
        }

        public StringType getCommentsElement() {
            if (this.comments == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TargetElementComponent.comments");
                }
                if (Configuration.doAutoCreate()) {
                    this.comments = new StringType();
                }
            }
            return this.comments;
        }

        public boolean hasCommentsElement() {
            return this.comments != null && !this.comments.isEmpty();
        }

        public boolean hasComments() {
            return this.comments != null && !this.comments.isEmpty();
        }

        public TargetElementComponent setCommentsElement(StringType value) {
            this.comments = value;
            return this;
        }

        public String getComments() {
            return this.comments == null ? null : (String)this.comments.getValue();
        }

        public TargetElementComponent setComments(String value) {
            if (Utilities.noString((String)value)) {
                this.comments = null;
            } else {
                if (this.comments == null) {
                    this.comments = new StringType();
                }
                this.comments.setValue(value);
            }
            return this;
        }

        public List<OtherElementComponent> getDependsOn() {
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            return this.dependsOn;
        }

        public boolean hasDependsOn() {
            if (this.dependsOn == null) {
                return false;
            }
            for (OtherElementComponent item : this.dependsOn) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addDependsOn() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return t;
        }

        public TargetElementComponent addDependsOn(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dependsOn == null) {
                this.dependsOn = new ArrayList<OtherElementComponent>();
            }
            this.dependsOn.add(t);
            return this;
        }

        public List<OtherElementComponent> getProduct() {
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            return this.product;
        }

        public boolean hasProduct() {
            if (this.product == null) {
                return false;
            }
            for (OtherElementComponent item : this.product) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OtherElementComponent addProduct() {
            OtherElementComponent t = new OtherElementComponent();
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return t;
        }

        public TargetElementComponent addProduct(OtherElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.product == null) {
                this.product = new ArrayList<OtherElementComponent>();
            }
            this.product.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("codeSystem", "uri", "An absolute URI that identifies the code system of the target code (if the target is a value set that cross code systems).", 0, Integer.MAX_VALUE, this.codeSystem));
            childrenList.add(new Property("code", "code", "Identity (code or path) or the element/item that the map refers to.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("equivalence", "code", "The equivalence between the source and target concepts (counting for the dependencies and products). The equivalence is read from target to source (e.g. the target is 'wider' than the source).", 0, Integer.MAX_VALUE, this.equivalence));
            childrenList.add(new Property("comments", "string", "A description of status/issues in mapping that conveys additional information not represented in  the structured data.", 0, Integer.MAX_VALUE, this.comments));
            childrenList.add(new Property("dependsOn", "", "A set of additional dependencies for this mapping to hold. This mapping is only applicable if the specified element can be resolved, and it has the specified value.", 0, Integer.MAX_VALUE, this.dependsOn));
            childrenList.add(new Property(ConceptMap.SP_PRODUCT, "@ConceptMap.element.target.dependsOn", "A set of additional outcomes from this mapping to other elements. To properly execute this mapping, the specified element must be mapped to some data element or source that is in context. The mapping may still be useful without a place for the additional data elements, but the equivalence cannot be relied on.", 0, Integer.MAX_VALUE, this.product));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("codeSystem")) {
                this.codeSystem = this.castToUri(value);
            } else if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("equivalence")) {
                this.equivalence = new Enumerations.ConceptMapEquivalenceEnumFactory().fromType(value);
            } else if (name.equals("comments")) {
                this.comments = this.castToString(value);
            } else if (name.equals("dependsOn")) {
                this.getDependsOn().add((OtherElementComponent)value);
            } else if (name.equals(ConceptMap.SP_PRODUCT)) {
                this.getProduct().add((OtherElementComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeSystem")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.codeSystem");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.code");
            }
            if (name.equals("equivalence")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.equivalence");
            }
            if (name.equals("comments")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.comments");
            }
            if (name.equals("dependsOn")) {
                return this.addDependsOn();
            }
            if (name.equals(ConceptMap.SP_PRODUCT)) {
                return this.addProduct();
            }
            return super.addChild(name);
        }

        @Override
        public TargetElementComponent copy() {
            TargetElementComponent dst = new TargetElementComponent();
            this.copyValues(dst);
            dst.codeSystem = this.codeSystem == null ? null : this.codeSystem.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.equivalence = this.equivalence == null ? null : this.equivalence.copy();
            StringType stringType = dst.comments = this.comments == null ? null : this.comments.copy();
            if (this.dependsOn != null) {
                dst.dependsOn = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.dependsOn) {
                    dst.dependsOn.add(i.copy());
                }
            }
            if (this.product != null) {
                dst.product = new ArrayList<OtherElementComponent>();
                for (OtherElementComponent i : this.product) {
                    dst.product.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other;
            return TargetElementComponent.compareDeep(this.codeSystem, o.codeSystem, true) && TargetElementComponent.compareDeep(this.code, o.code, true) && TargetElementComponent.compareDeep(this.equivalence, o.equivalence, true) && TargetElementComponent.compareDeep(this.comments, o.comments, true) && TargetElementComponent.compareDeep(this.dependsOn, o.dependsOn, true) && TargetElementComponent.compareDeep(this.product, o.product, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TargetElementComponent)) {
                return false;
            }
            TargetElementComponent o = (TargetElementComponent)other;
            return TargetElementComponent.compareValues(this.codeSystem, o.codeSystem, true) && TargetElementComponent.compareValues(this.code, o.code, true) && TargetElementComponent.compareValues(this.equivalence, o.equivalence, true) && TargetElementComponent.compareValues(this.comments, o.comments, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.code != null && !this.code.isEmpty() || this.equivalence != null && !this.equivalence.isEmpty() || this.comments != null && !this.comments.isEmpty() || this.dependsOn != null && !this.dependsOn.isEmpty() || this.product != null && !this.product.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ConceptMap.element.target";
        }
    }

    @Block
    public static class SourceElementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="codeSystem", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code System (if value set crosses code systems)", formalDefinition="An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system).")
        protected UriType codeSystem;
        @Child(name="code", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies element being mapped", formalDefinition="Identity (code or path) or the element/item being mapped.")
        protected CodeType code;
        @Child(name="target", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept in target system for element", formalDefinition="A concept from the target value set that this concept maps to.")
        protected List<TargetElementComponent> target;
        private static final long serialVersionUID = -458143877L;

        public UriType getCodeSystemElement() {
            if (this.codeSystem == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.codeSystem");
                }
                if (Configuration.doAutoCreate()) {
                    this.codeSystem = new UriType();
                }
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystemElement() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public boolean hasCodeSystem() {
            return this.codeSystem != null && !this.codeSystem.isEmpty();
        }

        public SourceElementComponent setCodeSystemElement(UriType value) {
            this.codeSystem = value;
            return this;
        }

        public String getCodeSystem() {
            return this.codeSystem == null ? null : (String)this.codeSystem.getValue();
        }

        public SourceElementComponent setCodeSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.codeSystem = null;
            } else {
                if (this.codeSystem == null) {
                    this.codeSystem = new UriType();
                }
                this.codeSystem.setValue(value);
            }
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SourceElementComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SourceElementComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public SourceElementComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public List<TargetElementComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            return this.target;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (TargetElementComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TargetElementComponent addTarget() {
            TargetElementComponent t = new TargetElementComponent();
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return t;
        }

        public SourceElementComponent addTarget(TargetElementComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<TargetElementComponent>();
            }
            this.target.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("codeSystem", "uri", "An absolute URI that identifies the Code System (if the source is a value set that crosses more than one code system).", 0, Integer.MAX_VALUE, this.codeSystem));
            childrenList.add(new Property("code", "code", "Identity (code or path) or the element/item being mapped.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property(ConceptMap.SP_TARGET, "", "A concept from the target value set that this concept maps to.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("codeSystem")) {
                this.codeSystem = this.castToUri(value);
            } else if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals(ConceptMap.SP_TARGET)) {
                this.getTarget().add((TargetElementComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("codeSystem")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.codeSystem");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.code");
            }
            if (name.equals(ConceptMap.SP_TARGET)) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public SourceElementComponent copy() {
            SourceElementComponent dst = new SourceElementComponent();
            this.copyValues(dst);
            dst.codeSystem = this.codeSystem == null ? null : this.codeSystem.copy();
            CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
            if (this.target != null) {
                dst.target = new ArrayList<TargetElementComponent>();
                for (TargetElementComponent i : this.target) {
                    dst.target.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other;
            return SourceElementComponent.compareDeep(this.codeSystem, o.codeSystem, true) && SourceElementComponent.compareDeep(this.code, o.code, true) && SourceElementComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SourceElementComponent)) {
                return false;
            }
            SourceElementComponent o = (SourceElementComponent)other;
            return SourceElementComponent.compareValues(this.codeSystem, o.codeSystem, true) && SourceElementComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.code != null && !this.code.isEmpty() || this.target != null && !this.target.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ConceptMap.element";
        }
    }

    @Block
    public static class ConceptMapContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of a individual to contact", formalDefinition="The name of an individual to contact regarding the concept map.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptMapContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ConceptMapContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ConceptMapContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ConceptMapContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ConceptMap.SP_NAME, "string", "The name of an individual to contact regarding the concept map.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ConceptMap.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ConceptMap.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a singleton property ConceptMap.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptMapContactComponent copy() {
            ConceptMapContactComponent dst = new ConceptMapContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptMapContactComponent)) {
                return false;
            }
            ConceptMapContactComponent o = (ConceptMapContactComponent)other;
            return ConceptMapContactComponent.compareDeep(this.name, o.name, true) && ConceptMapContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptMapContactComponent)) {
                return false;
            }
            ConceptMapContactComponent o = (ConceptMapContactComponent)other;
            return ConceptMapContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ConceptMap.contact";
        }
    }
}

