/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Annotation")
public class Annotation
extends Type
implements ICompositeType {
    @Child(name="author", type={Practitioner.class, Patient.class, RelatedPerson.class, StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual responsible for the annotation", formalDefinition="The individual responsible for making the annotation.")
    protected Type author;
    @Child(name="time", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the annotation was made", formalDefinition="Indicates when this particular annotation was made.")
    protected DateTimeType time;
    @Child(name="text", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The annotation  - text content", formalDefinition="The text of the annotation.")
    protected StringType text;
    private static final long serialVersionUID = -575590381L;

    public Annotation() {
    }

    public Annotation(StringType text) {
        this.text = text;
    }

    public Type getAuthor() {
        return this.author;
    }

    public Reference getAuthorReference() throws FHIRException {
        if (!(this.author instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.author.getClass().getName() + " was encountered");
        }
        return (Reference)this.author;
    }

    public boolean hasAuthorReference() {
        return this.author instanceof Reference;
    }

    public StringType getAuthorStringType() throws FHIRException {
        if (!(this.author instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.author.getClass().getName() + " was encountered");
        }
        return (StringType)this.author;
    }

    public boolean hasAuthorStringType() {
        return this.author instanceof StringType;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Annotation setAuthor(Type value) {
        this.author = value;
        return this;
    }

    public DateTimeType getTimeElement() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotation.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DateTimeType();
            }
        }
        return this.time;
    }

    public boolean hasTimeElement() {
        return this.time != null && !this.time.isEmpty();
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public Annotation setTimeElement(DateTimeType value) {
        this.time = value;
        return this;
    }

    public Date getTime() {
        return this.time == null ? null : (Date)this.time.getValue();
    }

    public Annotation setTime(Date value) {
        if (value == null) {
            this.time = null;
        } else {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            this.time.setValue(value);
        }
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotation.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public Annotation setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public Annotation setText(String value) {
        if (this.text == null) {
            this.text = new StringType();
        }
        this.text.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("time", "dateTime", "Indicates when this particular annotation was made.", 0, Integer.MAX_VALUE, this.time));
        childrenList.add(new Property("text", "string", "The text of the annotation.", 0, Integer.MAX_VALUE, this.text));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("author[x]")) {
            this.author = (Type)value;
        } else if (name.equals("time")) {
            this.time = this.castToDateTime(value);
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("authorReference")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("authorString")) {
            this.author = new StringType();
            return this.author;
        }
        if (name.equals("time")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotation.time");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a singleton property Annotation.text");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Annotation";
    }

    @Override
    public Annotation copy() {
        Annotation dst = new Annotation();
        this.copyValues(dst);
        dst.author = this.author == null ? null : this.author.copy();
        dst.time = this.time == null ? null : this.time.copy();
        dst.text = this.text == null ? null : this.text.copy();
        return dst;
    }

    @Override
    protected Annotation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Annotation)) {
            return false;
        }
        Annotation o = (Annotation)other;
        return Annotation.compareDeep(this.author, o.author, true) && Annotation.compareDeep(this.time, o.time, true) && Annotation.compareDeep(this.text, o.text, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Annotation)) {
            return false;
        }
        Annotation o = (Annotation)other;
        return Annotation.compareValues(this.time, o.time, true) && Annotation.compareValues(this.text, o.text, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.author != null && !this.author.isEmpty() || this.time != null && !this.time.isEmpty() || this.text != null && !this.text.isEmpty());
    }
}

