/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.utils.client.ClientUtils;
import org.hl7.fhir.dstu2.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2.utils.client.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class FHIRToolingClient {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String hostKey = "http.proxyHost";
    public static final String portKey = "http.proxyPort";
    private static final int TIMEOUT_NORMAL = 1;
    private static final int TIMEOUT_OPERATION = 2;
    private static final int TIMEOUT_OPERATION_LONG = 3;
    private String base;
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat;
    private HttpHost proxy;
    private int maxResultSetSize = -1;
    private Conformance conf;
    private ClientUtils utils = new ClientUtils();

    public FHIRToolingClient(String baseServiceUrl, String userAgent) throws URISyntaxException {
        this.preferredResourceFormat = ResourceFormat.RESOURCE_XML;
        this.utils.setUserAgent(userAgent);
        this.detectProxy();
        this.initialize(baseServiceUrl);
    }

    public FHIRToolingClient(String baseServiceUrl, String userAgent, String username, String password) throws URISyntaxException {
        this.preferredResourceFormat = ResourceFormat.RESOURCE_XML;
        this.utils.setUserAgent(userAgent);
        this.utils.setUsername(username);
        this.utils.setPassword(password);
        this.detectProxy();
        this.initialize(baseServiceUrl);
    }

    public void configureProxy(String proxyHost, int proxyPort) {
        this.utils.setProxy(new HttpHost(proxyHost, proxyPort));
    }

    public void detectProxy() {
        String host = System.getenv(hostKey);
        String port = System.getenv(portKey);
        if (host == null) {
            host = System.getProperty(hostKey);
        }
        if (port == null) {
            port = System.getProperty(portKey);
        }
        if (host != null && port != null) {
            this.configureProxy(host, Integer.parseInt(port));
        }
    }

    public void initialize(String baseServiceUrl) throws URISyntaxException {
        this.base = baseServiceUrl;
        this.resourceAddress = new ResourceAddress(baseServiceUrl);
        this.maxResultSetSize = -1;
        this.checkConformance();
    }

    private void checkConformance() {
        try {
            this.conf = this.getConformanceStatementQuick();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    public void setMaximumRecordCount(int maxResultSetSize) {
        this.maxResultSetSize = maxResultSetSize;
    }

    public Conformance getConformanceStatement() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatement(false);
    }

    public Conformance getConformanceStatement(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)this.utils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.getPreferredResourceFormat(), 1).getReference() : (Conformance)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(false), this.getPreferredResourceFormat(), 1).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public Conformance getConformanceStatementQuick() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatementQuick(false);
    }

    public Conformance getConformanceStatementQuick(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)this.utils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.getPreferredResourceFormat(), 1).getReference() : (Conformance)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(true), this.getPreferredResourceFormat(), 1).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public <T extends Resource> T read(Class<T> resourceClass, String id) {
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.getPreferredResourceFormat(), 1);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T vread(Class<T> resourceClass, String id, String version) {
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(resourceClass, id, version), this.getPreferredResourceFormat(), 1);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T getCanonical(Class<T> resourceClass, String canonicalURL) {
        ResourceRequest result = null;
        try {
            result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndCanonical(resourceClass, canonicalURL), this.getPreferredResourceFormat(), 1);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        Bundle bnd = (Bundle)result.getPayload();
        if (bnd.getEntry().size() == 0) {
            throw new EFhirClientException("No matching resource found for canonical URL '" + canonicalURL + "'");
        }
        if (bnd.getEntry().size() > 1) {
            throw new EFhirClientException("Multiple matching resources found for canonical URL '" + canonicalURL + "'");
        }
        return (T)bnd.getEntry().get(0).getResource();
    }

    public Resource update(Resource resource) {
        ResourceRequest result = null;
        try {
            List<Header> headers = null;
            result = this.utils.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resource.getClass(), resource.getId()), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 2);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            result.addSuccessStatus(201);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resource.getClass(), resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> T update(Class<T> resourceClass, T resource, String id) {
        ResourceRequest result = null;
        try {
            List<Header> headers = null;
            result = this.utils.issuePutRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 2);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            result.addSuccessStatus(201);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            throw new EFhirClientException("An error has occurred while trying to update this resource", e);
        }
        try {
            OperationOutcome operationOutcome = (OperationOutcome)result.getPayload();
            ResourceAddress.ResourceVersionedIdentifier resVersionedIdentifier = ResourceAddress.parseCreateLocation(result.getLocation());
            return this.vread(resourceClass, resVersionedIdentifier.getId(), resVersionedIdentifier.getVersionId());
        }
        catch (ClassCastException classCastException) {
            return result.getPayload();
        }
    }

    public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
        boolean complex = false;
        for (Parameters.ParametersParameterComponent p : params.getParameter()) {
            complex = complex || !(p.getValue() instanceof PrimitiveType);
        }
        Object searchResults = null;
        String ps = "";
        try {
            if (!complex) {
                for (Parameters.ParametersParameterComponent p : params.getParameter()) {
                    if (!(p.getValue() instanceof PrimitiveType)) continue;
                    ps = ps + p.getName() + "=" + Utilities.encodeUri((String)((PrimitiveType)p.getValue()).asStringValue()) + "&";
                }
            }
            ResourceRequest result = complex ? this.utils.issuePostRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), 3) : this.utils.issueGetResourceRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), this.getPreferredResourceFormat(), 3);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
            if (result.getPayload() instanceof Parameters) {
                return (Parameters)result.getPayload();
            }
            Parameters p_out = new Parameters();
            p_out.addParameter().setName("return").setResource((Resource)result.getPayload());
            return p_out;
        }
        catch (Exception e) {
            this.handleException("Error performing tx2 operation '" + name + ": " + e.getMessage() + "' (parameters = \"" + ps + "\")", e);
            return null;
        }
    }

    public Bundle transaction(Bundle batch) {
        Bundle transactionResult = null;
        try {
            transactionResult = this.utils.postBatchRequest(this.resourceAddress.getBaseServiceUri(), this.utils.getFeedAsByteArray(batch, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), 1 + batch.getEntry().size());
        }
        catch (Exception e) {
            this.handleException("An error occurred trying to process this transaction request", e);
        }
        return transactionResult;
    }

    public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
        ResourceRequest result = null;
        try {
            result = this.utils.issuePostRequest(this.resourceAddress.resolveValidateUri(resourceClass, id), this.utils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), 3);
            result.addErrorStatus(400);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to validate this resource", e);
        }
        return (OperationOutcome)result.getPayload();
    }

    protected void handleException(String message, Exception e) throws EFhirClientException {
        if (e instanceof EFhirClientException) {
            throw (EFhirClientException)e;
        }
        throw new EFhirClientException(message, e);
    }

    protected boolean isJson(String format) {
        boolean isJson = false;
        if (format.toLowerCase().contains("json")) {
            isJson = true;
        }
        return isJson;
    }

    public Bundle fetchFeed(String url) {
        Bundle feed = null;
        try {
            feed = this.utils.issueGetFeedRequest(new URI(url), this.getPreferredResourceFormat());
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to retrieve history since last update", e);
        }
        return feed;
    }

    public ValueSet expandValueset(ValueSet source) {
        List<Header> headers = null;
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand"), this.utils.getResourceAsByteArray(source, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 3);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ValueSet)result.getPayload();
    }

    public Parameters lookupCode(Map<String, String> params) {
        ResourceRequest result = this.utils.issueGetResourceRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "lookup", params), this.getPreferredResourceFormat(), 1);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public ValueSet expandValueset(ValueSet source, Parameters expParams, Map<String, String> params) {
        List<Header> headers = null;
        Parameters p = expParams == null ? new Parameters() : expParams.copy();
        p.addParameter().setName("valueSet").setResource(source);
        for (String n : params.keySet()) {
            p.addParameter().setName(n).setValue(new StringType(params.get(n)));
        }
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand", params), this.utils.getResourceAsByteArray(p, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 4);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ValueSet)result.getPayload();
    }

    public String getAddress() {
        return this.base;
    }

    public ConceptMap initializeClosure(String name) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        List<Header> headers = null;
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 1);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }

    public ConceptMap updateClosure(String name, Coding coding) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        params.addParameter().setName("concept").setValue(coding);
        List<Header> headers = null;
        ResourceRequest result = this.utils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), this.utils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, 2);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }

    public int getTimeout() {
        return this.utils.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.utils.setTimeout(timeout);
    }

    public String getUsername() {
        return this.utils.getUsername();
    }

    public void setUsername(String username) {
        this.utils.setUsername(username);
    }

    public String getPassword() {
        return this.utils.getPassword();
    }

    public void setPassword(String password) {
        this.utils.setPassword(password);
    }

    public Parameters getTerminologyCapabilities() {
        return (Parameters)this.utils.issueGetResourceRequest(this.resourceAddress.resolveMetadataTxCaps(), this.getPreferredResourceFormat(), 1).getReference();
    }

    public ToolingClientLogger getLogger() {
        return this.utils.getLogger();
    }

    public void setLogger(ToolingClientLogger logger) {
        this.utils.setLogger(logger);
    }

    public int getRetryCount() {
        return this.utils.getRetryCount();
    }

    public void setRetryCount(int retryCount) {
        this.utils.setRetryCount(retryCount);
    }

    public String getUserAgent() {
        return this.utils.getUserAgent();
    }

    public void setUserAgent(String userAgent) {
        this.utils.setUserAgent(userAgent);
    }

    public String getServerVersion() {
        return this.conf == null ? null : this.conf.getSoftware().getVersion();
    }
}

