/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.terminologies;

import org.hl7.fhir.dstu2.model.Meta;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;

public class ValueSetUtilities {
    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new UriType("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition"));
        return vs;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType t : vs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/valueset-shareable-definition")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }
}

