/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ValueSet", profile="http://hl7.org/fhir/Profile/ValueSet")
public class ValueSet
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Globally unique logical identifier for  value set", formalDefinition="An absolute URL that is used to identify this value set when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this value set is (or will be) published.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the value set (e.g. HL7 v2 / CDA)", formalDefinition="Formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier for this version of the value set", formalDefinition="Used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Informal name for this value set", formalDefinition="A free text natural language name describing the value set.")
    protected StringType name;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the value set.")
    protected Enumeration<Enumerations.ConformanceResourceStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This valueset was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="publisher", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the individual or organization that published the value set.")
    protected StringType publisher;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the publisher", formalDefinition="Contacts to assist a user in finding and communicating with the publisher.")
    protected List<ValueSetContactComponent> contact;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date for given status", formalDefinition="The date that the value set status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes (e.g. the 'content logical definition').")
    protected DateTimeType date;
    @Child(name="lockedDate", type={DateType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Fixed date for all referenced code systems and value sets", formalDefinition="If a locked date is defined, then the Content Logical Definition must be evaluated using the current version of all referenced code system(s) and value set instances as of the locked date.")
    protected DateType lockedDate;
    @Child(name="description", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human language description of the value set", formalDefinition="A free text natural language description of the use of the value set - reason for definition, \"the semantic space\" to be included in the value set, conditions of use, etc. The description may include a list of expected usages for the value set and can also describe the approach taken to build the value set.")
    protected StringType description;
    @Child(name="useContext", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of value set definitions.")
    protected List<CodeableConcept> useContext;
    @Child(name="immutable", type={BooleanType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates whether or not any change to the content logical definition may occur", formalDefinition="If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.")
    protected BooleanType immutable;
    @Child(name="requirements", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why needed", formalDefinition="Explains why this value set is needed and why it has been constrained as it has.")
    protected StringType requirements;
    @Child(name="copyright", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.")
    protected StringType copyright;
    @Child(name="extensible", type={BooleanType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this is intended to be used with an extensible binding", formalDefinition="Whether this is intended to be used with an extensible binding or not.")
    protected BooleanType extensible;
    @Child(name="codeSystem", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An inline code system, which is part of this value set", formalDefinition="A definition of a code system, inlined into the value set (as a packaging convenience). Note that the inline code system may be used from other value sets by referring to its (codeSystem.system) directly.")
    protected ValueSetCodeSystemComponent codeSystem;
    @Child(name="compose", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When value set includes codes from elsewhere", formalDefinition="A set of criteria that provide the content logical definition of the value set by including or excluding codes from outside this value set.")
    protected ValueSetComposeComponent compose;
    @Child(name="expansion", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used when the value set is \"expanded\"", formalDefinition="A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.")
    protected ValueSetExpansionComponent expansion;
    private static final long serialVersionUID = -467533312L;
    @SearchParamDefinition(name="date", path="ValueSet.date", description="The value set publication date", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="ValueSet.identifier", description="The identifier for the value set", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="ValueSet.codeSystem.concept.code", description="A code defined in the value set", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="description", path="ValueSet.description", description="Text search in the description of the value set", type="string")
    public static final String SP_DESCRIPTION = "description";
    @SearchParamDefinition(name="version", path="ValueSet.version", description="The version identifier of the value set", type="token")
    public static final String SP_VERSION = "version";
    @SearchParamDefinition(name="url", path="ValueSet.url", description="The logical URL for the value set", type="uri")
    public static final String SP_URL = "url";
    @SearchParamDefinition(name="expansion", path="ValueSet.expansion.identifier", description="Uniquely identifies this expansion", type="uri")
    public static final String SP_EXPANSION = "expansion";
    @SearchParamDefinition(name="reference", path="ValueSet.compose.include.system", description="A code system included or excluded in the value set or an imported value set", type="uri")
    public static final String SP_REFERENCE = "reference";
    @SearchParamDefinition(name="system", path="ValueSet.codeSystem.system", description="The system for any codes defined by this value set", type="uri")
    public static final String SP_SYSTEM = "system";
    @SearchParamDefinition(name="name", path="ValueSet.name", description="The name of the value set", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="context", path="ValueSet.useContext", description="A use context assigned to the value set", type="token")
    public static final String SP_CONTEXT = "context";
    @SearchParamDefinition(name="publisher", path="ValueSet.publisher", description="Name of the publisher of the value set", type="string")
    public static final String SP_PUBLISHER = "publisher";
    @SearchParamDefinition(name="status", path="ValueSet.status", description="The status of the value set", type="token")
    public static final String SP_STATUS = "status";

    public ValueSet() {
    }

    public ValueSet(Enumeration<Enumerations.ConformanceResourceStatus> status) {
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ValueSet setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ValueSet setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public ValueSet setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ValueSet setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ValueSet setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ValueSet setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ValueSet setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.ConformanceResourceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ValueSet setStatusElement(Enumeration<Enumerations.ConformanceResourceStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.ConformanceResourceStatus getStatus() {
        return this.status == null ? null : (Enumerations.ConformanceResourceStatus)((Object)this.status.getValue());
    }

    public ValueSet setStatus(Enumerations.ConformanceResourceStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public ValueSet setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public ValueSet setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public ValueSet setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public ValueSet setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ValueSetContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ValueSetContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ValueSetContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ValueSetContactComponent addContact() {
        ValueSetContactComponent t = new ValueSetContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ValueSetContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public ValueSet addContact(ValueSetContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ValueSetContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public ValueSet setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public ValueSet setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public DateType getLockedDateElement() {
        if (this.lockedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.lockedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lockedDate = new DateType();
            }
        }
        return this.lockedDate;
    }

    public boolean hasLockedDateElement() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public boolean hasLockedDate() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public ValueSet setLockedDateElement(DateType value) {
        this.lockedDate = value;
        return this;
    }

    public Date getLockedDate() {
        return this.lockedDate == null ? null : (Date)this.lockedDate.getValue();
    }

    public ValueSet setLockedDate(Date value) {
        if (value == null) {
            this.lockedDate = null;
        } else {
            if (this.lockedDate == null) {
                this.lockedDate = new DateType();
            }
            this.lockedDate.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ValueSet setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ValueSet setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (CodeableConcept item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUseContext() {
        CodeableConcept t = new CodeableConcept();
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return t;
    }

    public ValueSet addUseContext(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        this.useContext.add(t);
        return this;
    }

    public BooleanType getImmutableElement() {
        if (this.immutable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.immutable");
            }
            if (Configuration.doAutoCreate()) {
                this.immutable = new BooleanType();
            }
        }
        return this.immutable;
    }

    public boolean hasImmutableElement() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public boolean hasImmutable() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public ValueSet setImmutableElement(BooleanType value) {
        this.immutable = value;
        return this;
    }

    public boolean getImmutable() {
        return this.immutable == null || this.immutable.isEmpty() ? false : (Boolean)this.immutable.getValue();
    }

    public ValueSet setImmutable(boolean value) {
        if (this.immutable == null) {
            this.immutable = new BooleanType();
        }
        this.immutable.setValue((Object)value);
        return this;
    }

    public StringType getRequirementsElement() {
        if (this.requirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.requirements");
            }
            if (Configuration.doAutoCreate()) {
                this.requirements = new StringType();
            }
        }
        return this.requirements;
    }

    public boolean hasRequirementsElement() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null && !this.requirements.isEmpty();
    }

    public ValueSet setRequirementsElement(StringType value) {
        this.requirements = value;
        return this;
    }

    public String getRequirements() {
        return this.requirements == null ? null : (String)this.requirements.getValue();
    }

    public ValueSet setRequirements(String value) {
        if (Utilities.noString((String)value)) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ValueSet setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ValueSet setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public BooleanType getExtensibleElement() {
        if (this.extensible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.extensible");
            }
            if (Configuration.doAutoCreate()) {
                this.extensible = new BooleanType();
            }
        }
        return this.extensible;
    }

    public boolean hasExtensibleElement() {
        return this.extensible != null && !this.extensible.isEmpty();
    }

    public boolean hasExtensible() {
        return this.extensible != null && !this.extensible.isEmpty();
    }

    public ValueSet setExtensibleElement(BooleanType value) {
        this.extensible = value;
        return this;
    }

    public boolean getExtensible() {
        return this.extensible == null || this.extensible.isEmpty() ? false : (Boolean)this.extensible.getValue();
    }

    public ValueSet setExtensible(boolean value) {
        if (this.extensible == null) {
            this.extensible = new BooleanType();
        }
        this.extensible.setValue((Object)value);
        return this;
    }

    public ValueSetCodeSystemComponent getCodeSystem() {
        if (this.codeSystem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.codeSystem");
            }
            if (Configuration.doAutoCreate()) {
                this.codeSystem = new ValueSetCodeSystemComponent();
            }
        }
        return this.codeSystem;
    }

    public boolean hasCodeSystem() {
        return this.codeSystem != null && !this.codeSystem.isEmpty();
    }

    public ValueSet setCodeSystem(ValueSetCodeSystemComponent value) {
        this.codeSystem = value;
        return this;
    }

    public ValueSetComposeComponent getCompose() {
        if (this.compose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.compose");
            }
            if (Configuration.doAutoCreate()) {
                this.compose = new ValueSetComposeComponent();
            }
        }
        return this.compose;
    }

    public boolean hasCompose() {
        return this.compose != null && !this.compose.isEmpty();
    }

    public ValueSet setCompose(ValueSetComposeComponent value) {
        this.compose = value;
        return this;
    }

    public ValueSetExpansionComponent getExpansion() {
        if (this.expansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.expansion");
            }
            if (Configuration.doAutoCreate()) {
                this.expansion = new ValueSetExpansionComponent();
            }
        }
        return this.expansion;
    }

    public boolean hasExpansion() {
        return this.expansion != null && !this.expansion.isEmpty();
    }

    public ValueSet setExpansion(ValueSetExpansionComponent value) {
        this.expansion = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this value set when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this value set is (or will be) published.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "Used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_NAME, "string", "A free text natural language name describing the value set.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the value set.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("experimental", "boolean", "This valueset was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        childrenList.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the value set.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("contact", "", "Contacts to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date that the value set status was last changed. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes (e.g. the 'content logical definition').", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("lockedDate", SP_DATE, "If a locked date is defined, then the Content Logical Definition must be evaluated using the current version of all referenced code system(s) and value set instances as of the locked date.", 0, Integer.MAX_VALUE, this.lockedDate));
        childrenList.add(new Property(SP_DESCRIPTION, "string", "A free text natural language description of the use of the value set - reason for definition, \"the semantic space\" to be included in the value set, conditions of use, etc. The description may include a list of expected usages for the value set and can also describe the approach taken to build the value set.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("useContext", "CodeableConcept", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of value set definitions.", 0, Integer.MAX_VALUE, this.useContext));
        childrenList.add(new Property("immutable", "boolean", "If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.", 0, Integer.MAX_VALUE, this.immutable));
        childrenList.add(new Property("requirements", "string", "Explains why this value set is needed and why it has been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
        childrenList.add(new Property("copyright", "string", "A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.", 0, Integer.MAX_VALUE, this.copyright));
        childrenList.add(new Property("extensible", "boolean", "Whether this is intended to be used with an extensible binding or not.", 0, Integer.MAX_VALUE, this.extensible));
        childrenList.add(new Property("codeSystem", "", "A definition of a code system, inlined into the value set (as a packaging convenience). Note that the inline code system may be used from other value sets by referring to its (codeSystem.system) directly.", 0, Integer.MAX_VALUE, this.codeSystem));
        childrenList.add(new Property("compose", "", "A set of criteria that provide the content logical definition of the value set by including or excluding codes from outside this value set.", 0, Integer.MAX_VALUE, this.compose));
        childrenList.add(new Property(SP_EXPANSION, "", "A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.", 0, Integer.MAX_VALUE, this.expansion));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new Enumerations.ConformanceResourceStatusEnumFactory().fromType(value);
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add((ValueSetContactComponent)value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("lockedDate")) {
            this.lockedDate = this.castToDate(value);
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToString(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToCodeableConcept(value));
        } else if (name.equals("immutable")) {
            this.immutable = this.castToBoolean(value);
        } else if (name.equals("requirements")) {
            this.requirements = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToString(value);
        } else if (name.equals("extensible")) {
            this.extensible = this.castToBoolean(value);
        } else if (name.equals("codeSystem")) {
            this.codeSystem = (ValueSetCodeSystemComponent)value;
        } else if (name.equals("compose")) {
            this.compose = (ValueSetComposeComponent)value;
        } else if (name.equals(SP_EXPANSION)) {
            this.expansion = (ValueSetExpansionComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.experimental");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.date");
        }
        if (name.equals("lockedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.lockedDate");
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("immutable")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.immutable");
        }
        if (name.equals("requirements")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.requirements");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.copyright");
        }
        if (name.equals("extensible")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.extensible");
        }
        if (name.equals("codeSystem")) {
            this.codeSystem = new ValueSetCodeSystemComponent();
            return this.codeSystem;
        }
        if (name.equals("compose")) {
            this.compose = new ValueSetComposeComponent();
            return this.compose;
        }
        if (name.equals(SP_EXPANSION)) {
            this.expansion = new ValueSetExpansionComponent();
            return this.expansion;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ValueSet";
    }

    @Override
    public ValueSet copy() {
        ValueSet dst = new ValueSet();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ValueSetContactComponent>();
            for (ValueSetContactComponent valueSetContactComponent : this.contact) {
                dst.contact.add(valueSetContactComponent.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.lockedDate = this.lockedDate == null ? null : this.lockedDate.copy();
        StringType stringType2 = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.useContext) {
                dst.useContext.add(codeableConcept.copy());
            }
        }
        dst.immutable = this.immutable == null ? null : this.immutable.copy();
        dst.requirements = this.requirements == null ? null : this.requirements.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.extensible = this.extensible == null ? null : this.extensible.copy();
        dst.codeSystem = this.codeSystem == null ? null : this.codeSystem.copy();
        dst.compose = this.compose == null ? null : this.compose.copy();
        dst.expansion = this.expansion == null ? null : this.expansion.copy();
        return dst;
    }

    protected ValueSet typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other;
        return ValueSet.compareDeep(this.url, o.url, true) && ValueSet.compareDeep(this.identifier, o.identifier, true) && ValueSet.compareDeep(this.version, o.version, true) && ValueSet.compareDeep(this.name, o.name, true) && ValueSet.compareDeep(this.status, o.status, true) && ValueSet.compareDeep(this.experimental, o.experimental, true) && ValueSet.compareDeep(this.publisher, o.publisher, true) && ValueSet.compareDeep(this.contact, o.contact, true) && ValueSet.compareDeep(this.date, o.date, true) && ValueSet.compareDeep(this.lockedDate, o.lockedDate, true) && ValueSet.compareDeep(this.description, o.description, true) && ValueSet.compareDeep(this.useContext, o.useContext, true) && ValueSet.compareDeep(this.immutable, o.immutable, true) && ValueSet.compareDeep(this.requirements, o.requirements, true) && ValueSet.compareDeep(this.copyright, o.copyright, true) && ValueSet.compareDeep(this.extensible, o.extensible, true) && ValueSet.compareDeep(this.codeSystem, o.codeSystem, true) && ValueSet.compareDeep(this.compose, o.compose, true) && ValueSet.compareDeep(this.expansion, o.expansion, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other;
        return ValueSet.compareValues(this.url, o.url, true) && ValueSet.compareValues(this.version, o.version, true) && ValueSet.compareValues(this.name, o.name, true) && ValueSet.compareValues(this.status, o.status, true) && ValueSet.compareValues(this.experimental, o.experimental, true) && ValueSet.compareValues(this.publisher, o.publisher, true) && ValueSet.compareValues(this.date, o.date, true) && ValueSet.compareValues(this.lockedDate, o.lockedDate, true) && ValueSet.compareValues(this.description, o.description, true) && ValueSet.compareValues(this.immutable, o.immutable, true) && ValueSet.compareValues(this.requirements, o.requirements, true) && ValueSet.compareValues(this.copyright, o.copyright, true) && ValueSet.compareValues(this.extensible, o.extensible, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.url != null && !this.url.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.name != null && !this.name.isEmpty() || this.status != null && !this.status.isEmpty() || this.experimental != null && !this.experimental.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.date != null && !this.date.isEmpty() || this.lockedDate != null && !this.lockedDate.isEmpty() || this.description != null && !this.description.isEmpty() || this.useContext != null && !this.useContext.isEmpty() || this.immutable != null && !this.immutable.isEmpty() || this.requirements != null && !this.requirements.isEmpty() || this.copyright != null && !this.copyright.isEmpty() || this.extensible != null && !this.extensible.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.compose != null && !this.compose.isEmpty() || this.expansion != null && !this.expansion.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ValueSet;
    }

    @Block
    public static class ValueSetExpansionContainsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="System value for the code", formalDefinition="An absolute URI which is the code system in which the code for this item in the expansion is defined.")
        protected UriType system;
        @Child(name="abstract", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If user cannot select this entry", formalDefinition="If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.")
        protected BooleanType abstract_;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Version in which this code/display is defined", formalDefinition="The version of this code system that defined this code and/or display. This should only be used with code systems that do not enforce concept permanence.")
        protected StringType version;
        @Child(name="code", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code - if blank, this is not a selectable code", formalDefinition="The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User display for the concept", formalDefinition="The recommended display for this item in the expansion.")
        protected StringType display;
        @Child(name="contains", type={ValueSetExpansionContainsComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes contained under this entry", formalDefinition="Other codes and entries contained under this entry in the hierarchy.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = -2038349483L;

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ValueSetExpansionContainsComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ValueSetExpansionContainsComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public BooleanType getAbstractElement() {
            if (this.abstract_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.abstract_");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstract_ = new BooleanType();
                }
            }
            return this.abstract_;
        }

        public boolean hasAbstractElement() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public boolean hasAbstract() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public ValueSetExpansionContainsComponent setAbstractElement(BooleanType value) {
            this.abstract_ = value;
            return this;
        }

        public boolean getAbstract() {
            return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
        }

        public ValueSetExpansionContainsComponent setAbstract(boolean value) {
            if (this.abstract_ == null) {
                this.abstract_ = new BooleanType();
            }
            this.abstract_.setValue((Object)value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ValueSetExpansionContainsComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ValueSetExpansionContainsComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ValueSetExpansionContainsComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ValueSetExpansionContainsComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ValueSetExpansionContainsComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ValueSetExpansionContainsComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_SYSTEM, "uri", "An absolute URI which is the code system in which the code for this item in the expansion is defined.", 0, Integer.MAX_VALUE, this.system));
            childrenList.add(new Property("abstract", "boolean", "If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.", 0, Integer.MAX_VALUE, this.abstract_));
            childrenList.add(new Property(ValueSet.SP_VERSION, "string", "The version of this code system that defined this code and/or display. This should only be used with code systems that do not enforce concept permanence.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("display", "string", "The recommended display for this item in the expansion.", 0, Integer.MAX_VALUE, this.display));
            childrenList.add(new Property("contains", "@ValueSet.expansion.contains", "Other codes and entries contained under this entry in the hierarchy.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                this.system = this.castToUri(value);
            } else if (name.equals("abstract")) {
                this.abstract_ = this.castToBoolean(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals(ValueSet.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.system");
            }
            if (name.equals("abstract")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.abstract");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
            }
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.display");
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionContainsComponent copy() {
            ValueSetExpansionContainsComponent dst = new ValueSetExpansionContainsComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent i : this.contains) {
                    dst.contains.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other;
            return ValueSetExpansionContainsComponent.compareDeep(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareDeep(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareDeep(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareDeep(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareDeep(this.display, o.display, true) && ValueSetExpansionContainsComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other;
            return ValueSetExpansionContainsComponent.compareValues(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareValues(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareValues(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareValues(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.abstract_ != null && !this.abstract_.isEmpty() || this.version != null && !this.version.isEmpty() || this.code != null && !this.code.isEmpty() || this.display != null && !this.display.isEmpty() || this.contains != null && !this.contains.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.contains";
        }
    }

    @Block
    public static class ValueSetExpansionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name as assigned by the server", formalDefinition="The name of the parameter.")
        protected StringType name;
        @Child(name="value", type={StringType.class, BooleanType.class, IntegerType.class, DecimalType.class, UriType.class, CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the named parameter", formalDefinition="The value of the parameter.")
        protected Type value;
        private static final long serialVersionUID = 1172641169L;

        public ValueSetExpansionParameterComponent() {
        }

        public ValueSetExpansionParameterComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ValueSetExpansionParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ValueSetExpansionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this.value instanceof UriType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this.value instanceof CodeType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ValueSetExpansionParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_NAME, "string", "The name of the parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value[x]", "string|boolean|integer|decimal|uri|code", "The value of the parameter.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.name");
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionParameterComponent copy() {
            ValueSetExpansionParameterComponent dst = new ValueSetExpansionParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other;
            return ValueSetExpansionParameterComponent.compareDeep(this.name, o.name, true) && ValueSetExpansionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other;
            return ValueSetExpansionParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.parameter";
        }
    }

    @Block
    public static class ValueSetExpansionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Uniquely identifies this expansion", formalDefinition="An identifier that uniquely identifies this expansion of the valueset. Systems may re-use the same identifier as long as the expansion and the definition remain the same, but are not required to do so.")
        protected UriType identifier;
        @Child(name="timestamp", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time ValueSet expansion happened", formalDefinition="The time at which the expansion was produced by the expanding system.")
        protected DateTimeType timestamp;
        @Child(name="total", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total number of codes in the expansion", formalDefinition="The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.")
        protected IntegerType total;
        @Child(name="offset", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Offset at which this resource starts", formalDefinition="If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL not be present.")
        protected IntegerType offset;
        @Child(name="parameter", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter that controlled the expansion process", formalDefinition="A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.")
        protected List<ValueSetExpansionParameterComponent> parameter;
        @Child(name="contains", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes in the value set", formalDefinition="The codes that are contained in the value set expansion.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = -43471993L;

        public ValueSetExpansionComponent() {
        }

        public ValueSetExpansionComponent(UriType identifier, DateTimeType timestamp) {
            this.identifier = identifier;
            this.timestamp = timestamp;
        }

        public UriType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new UriType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValueSetExpansionComponent setIdentifierElement(UriType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ValueSetExpansionComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new UriType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public DateTimeType getTimestampElement() {
            if (this.timestamp == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.timestamp");
                }
                if (Configuration.doAutoCreate()) {
                    this.timestamp = new DateTimeType();
                }
            }
            return this.timestamp;
        }

        public boolean hasTimestampElement() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public boolean hasTimestamp() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public ValueSetExpansionComponent setTimestampElement(DateTimeType value) {
            this.timestamp = value;
            return this;
        }

        public Date getTimestamp() {
            return this.timestamp == null ? null : (Date)this.timestamp.getValue();
        }

        public ValueSetExpansionComponent setTimestamp(Date value) {
            if (this.timestamp == null) {
                this.timestamp = new DateTimeType();
            }
            this.timestamp.setValue(value);
            return this;
        }

        public IntegerType getTotalElement() {
            if (this.total == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.total");
                }
                if (Configuration.doAutoCreate()) {
                    this.total = new IntegerType();
                }
            }
            return this.total;
        }

        public boolean hasTotalElement() {
            return this.total != null && !this.total.isEmpty();
        }

        public boolean hasTotal() {
            return this.total != null && !this.total.isEmpty();
        }

        public ValueSetExpansionComponent setTotalElement(IntegerType value) {
            this.total = value;
            return this;
        }

        public int getTotal() {
            return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
        }

        public ValueSetExpansionComponent setTotal(int value) {
            if (this.total == null) {
                this.total = new IntegerType();
            }
            this.total.setValue((Object)value);
            return this;
        }

        public IntegerType getOffsetElement() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new IntegerType();
                }
            }
            return this.offset;
        }

        public boolean hasOffsetElement() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public ValueSetExpansionComponent setOffsetElement(IntegerType value) {
            this.offset = value;
            return this;
        }

        public int getOffset() {
            return this.offset == null || this.offset.isEmpty() ? 0 : (Integer)this.offset.getValue();
        }

        public ValueSetExpansionComponent setOffset(int value) {
            if (this.offset == null) {
                this.offset = new IntegerType();
            }
            this.offset.setValue((Object)value);
            return this;
        }

        public List<ValueSetExpansionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            return this.parameter;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (ValueSetExpansionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionParameterComponent addParameter() {
            ValueSetExpansionParameterComponent t = new ValueSetExpansionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public ValueSetExpansionComponent addParameter(ValueSetExpansionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_IDENTIFIER, "uri", "An identifier that uniquely identifies this expansion of the valueset. Systems may re-use the same identifier as long as the expansion and the definition remain the same, but are not required to do so.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("timestamp", "dateTime", "The time at which the expansion was produced by the expanding system.", 0, Integer.MAX_VALUE, this.timestamp));
            childrenList.add(new Property("total", "integer", "The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.", 0, Integer.MAX_VALUE, this.total));
            childrenList.add(new Property("offset", "integer", "If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL not be present.", 0, Integer.MAX_VALUE, this.offset));
            childrenList.add(new Property("parameter", "", "A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.", 0, Integer.MAX_VALUE, this.parameter));
            childrenList.add(new Property("contains", "", "The codes that are contained in the value set expansion.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                this.identifier = this.castToUri(value);
            } else if (name.equals("timestamp")) {
                this.timestamp = this.castToDateTime(value);
            } else if (name.equals("total")) {
                this.total = this.castToInteger(value);
            } else if (name.equals("offset")) {
                this.offset = this.castToInteger(value);
            } else if (name.equals("parameter")) {
                this.getParameter().add((ValueSetExpansionParameterComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.identifier");
            }
            if (name.equals("timestamp")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.timestamp");
            }
            if (name.equals("total")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.total");
            }
            if (name.equals("offset")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.offset");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionComponent copy() {
            ValueSetExpansionComponent dst = new ValueSetExpansionComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
            dst.total = this.total == null ? null : this.total.copy();
            IntegerType integerType = dst.offset = this.offset == null ? null : this.offset.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
                for (ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : this.parameter) {
                    dst.parameter.add(valueSetExpansionParameterComponent.copy());
                }
            }
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                    dst.contains.add(valueSetExpansionContainsComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other;
            return ValueSetExpansionComponent.compareDeep(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareDeep(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareDeep(this.total, o.total, true) && ValueSetExpansionComponent.compareDeep(this.offset, o.offset, true) && ValueSetExpansionComponent.compareDeep(this.parameter, o.parameter, true) && ValueSetExpansionComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other;
            return ValueSetExpansionComponent.compareValues(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareValues(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareValues(this.total, o.total, true) && ValueSetExpansionComponent.compareValues(this.offset, o.offset, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.timestamp != null && !this.timestamp.isEmpty() || this.total != null && !this.total.isEmpty() || this.offset != null && !this.offset.isEmpty() || this.parameter != null && !this.parameter.isEmpty() || this.contains != null && !this.contains.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion";
        }
    }

    @Block
    public static class ConceptSetFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A property defined by the code system", formalDefinition="A code that identifies a property defined in the code system.")
        protected CodeType property;
        @Child(name="op", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="= | is-a | is-not-a | regex | in | not-in", formalDefinition="The kind of operation to perform as a part of the filter criteria.")
        protected Enumeration<FilterOperator> op;
        @Child(name="value", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code from the system, or regex criteria", formalDefinition="The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value.")
        protected CodeType value;
        private static final long serialVersionUID = 1985515000L;

        public ConceptSetFilterComponent() {
        }

        public ConceptSetFilterComponent(CodeType property, Enumeration<FilterOperator> op, CodeType value) {
            this.property = property;
            this.op = op;
            this.value = value;
        }

        public CodeType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new CodeType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public ConceptSetFilterComponent setPropertyElement(CodeType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public ConceptSetFilterComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new CodeType();
            }
            this.property.setValue(value);
            return this;
        }

        public Enumeration<FilterOperator> getOpElement() {
            if (this.op == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.op");
                }
                if (Configuration.doAutoCreate()) {
                    this.op = new Enumeration<FilterOperator>(new FilterOperatorEnumFactory());
                }
            }
            return this.op;
        }

        public boolean hasOpElement() {
            return this.op != null && !this.op.isEmpty();
        }

        public boolean hasOp() {
            return this.op != null && !this.op.isEmpty();
        }

        public ConceptSetFilterComponent setOpElement(Enumeration<FilterOperator> value) {
            this.op = value;
            return this;
        }

        public FilterOperator getOp() {
            return this.op == null ? null : (FilterOperator)((Object)this.op.getValue());
        }

        public ConceptSetFilterComponent setOp(FilterOperator value) {
            if (this.op == null) {
                this.op = new Enumeration<FilterOperator>(new FilterOperatorEnumFactory());
            }
            this.op.setValue((Object)value);
            return this;
        }

        public CodeType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new CodeType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptSetFilterComponent setValueElement(CodeType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptSetFilterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new CodeType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("property", ValueSet.SP_CODE, "A code that identifies a property defined in the code system.", 0, Integer.MAX_VALUE, this.property));
            childrenList.add(new Property("op", ValueSet.SP_CODE, "The kind of operation to perform as a part of the filter criteria.", 0, Integer.MAX_VALUE, this.op));
            childrenList.add(new Property("value", ValueSet.SP_CODE, "The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = this.castToCode(value);
            } else if (name.equals("op")) {
                this.op = new FilterOperatorEnumFactory().fromType(value);
            } else if (name.equals("value")) {
                this.value = this.castToCode(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.property");
            }
            if (name.equals("op")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.op");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetFilterComponent copy() {
            ConceptSetFilterComponent dst = new ConceptSetFilterComponent();
            this.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.op = this.op == null ? null : this.op.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other;
            return ConceptSetFilterComponent.compareDeep(this.property, o.property, true) && ConceptSetFilterComponent.compareDeep(this.op, o.op, true) && ConceptSetFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other;
            return ConceptSetFilterComponent.compareValues(this.property, o.property, true) && ConceptSetFilterComponent.compareValues(this.op, o.op, true) && ConceptSetFilterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.property != null && !this.property.isEmpty() || this.op != null && !this.op.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.filter";
        }
    }

    @Block
    public static class ConceptReferenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or expression from system", formalDefinition="Specifies a code for the concept to be included or excluded.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Test to display for this code for this value set", formalDefinition="The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.")
        protected StringType display;
        @Child(name="designation", type={ConceptDefinitionDesignationComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for this valueset", formalDefinition="Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptDefinitionDesignationComponent> designation;
        private static final long serialVersionUID = -1513912691L;

        public ConceptReferenceComponent() {
        }

        public ConceptReferenceComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptReferenceComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptReferenceComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptReferenceComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptReferenceComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ConceptDefinitionDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            return this.designation;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptDefinitionDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionDesignationComponent addDesignation() {
            ConceptDefinitionDesignationComponent t = new ConceptDefinitionDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptReferenceComponent addDesignation(ConceptDefinitionDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "Specifies a code for the concept to be included or excluded.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("display", "string", "The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.", 0, Integer.MAX_VALUE, this.display));
            childrenList.add(new Property("designation", "@ValueSet.codeSystem.concept.designation", "Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.display");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptReferenceComponent copy() {
            ConceptReferenceComponent dst = new ConceptReferenceComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
                for (ConceptDefinitionDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other;
            return ConceptReferenceComponent.compareDeep(this.code, o.code, true) && ConceptReferenceComponent.compareDeep(this.display, o.display, true) && ConceptReferenceComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other;
            return ConceptReferenceComponent.compareValues(this.code, o.code, true) && ConceptReferenceComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.display != null && !this.display.isEmpty() || this.designation != null && !this.designation.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.concept";
        }
    }

    @Block
    public static class ConceptSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The system the codes come from", formalDefinition="An absolute URI which is the code system from which the selected codes come from.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system that the codes are selected from.")
        protected StringType version;
        @Child(name="concept", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A concept defined in the system", formalDefinition="Specifies a concept to be included or excluded.")
        protected List<ConceptReferenceComponent> concept;
        @Child(name="filter", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Select codes/concepts by their properties (including relationships)", formalDefinition="Select concepts by specify a matching criteria based on the properties (including relationships) defined by the system. If multiple filters are specified, they SHALL all be true.")
        protected List<ConceptSetFilterComponent> filter;
        private static final long serialVersionUID = -196054471L;

        public ConceptSetComponent() {
        }

        public ConceptSetComponent(UriType system) {
            this.system = system;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ConceptSetComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ConceptSetComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ConceptSetComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ConceptSetComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptReferenceComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceComponent addConcept() {
            ConceptReferenceComponent t = new ConceptReferenceComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptSetComponent addConcept(ConceptReferenceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return this;
        }

        public List<ConceptSetFilterComponent> getFilter() {
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            return this.filter;
        }

        public boolean hasFilter() {
            if (this.filter == null) {
                return false;
            }
            for (ConceptSetFilterComponent item : this.filter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetFilterComponent addFilter() {
            ConceptSetFilterComponent t = new ConceptSetFilterComponent();
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return t;
        }

        public ConceptSetComponent addFilter(ConceptSetFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_SYSTEM, "uri", "An absolute URI which is the code system from which the selected codes come from.", 0, Integer.MAX_VALUE, this.system));
            childrenList.add(new Property(ValueSet.SP_VERSION, "string", "The version of the code system that the codes are selected from.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("concept", "", "Specifies a concept to be included or excluded.", 0, Integer.MAX_VALUE, this.concept));
            childrenList.add(new Property("filter", "", "Select concepts by specify a matching criteria based on the properties (including relationships) defined by the system. If multiple filters are specified, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                this.system = this.castToUri(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptReferenceComponent)value);
            } else if (name.equals("filter")) {
                this.getFilter().add((ConceptSetFilterComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.system");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("filter")) {
                return this.addFilter();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetComponent copy() {
            ConceptSetComponent dst = new ConceptSetComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            StringType stringType = dst.version = this.version == null ? null : this.version.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptReferenceComponent>();
                for (ConceptReferenceComponent conceptReferenceComponent : this.concept) {
                    dst.concept.add(conceptReferenceComponent.copy());
                }
            }
            if (this.filter != null) {
                dst.filter = new ArrayList<ConceptSetFilterComponent>();
                for (ConceptSetFilterComponent conceptSetFilterComponent : this.filter) {
                    dst.filter.add(conceptSetFilterComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other;
            return ConceptSetComponent.compareDeep(this.system, o.system, true) && ConceptSetComponent.compareDeep(this.version, o.version, true) && ConceptSetComponent.compareDeep(this.concept, o.concept, true) && ConceptSetComponent.compareDeep(this.filter, o.filter, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other;
            return ConceptSetComponent.compareValues(this.system, o.system, true) && ConceptSetComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.version != null && !this.version.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.filter != null && !this.filter.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include";
        }
    }

    @Block
    public static class ValueSetComposeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="import", type={UriType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Import the contents of another value set", formalDefinition="Includes the contents of the referenced value set as a part of the contents of this value set. This is an absolute URI that is a reference to ValueSet.uri.")
        protected List<UriType> import_;
        @Child(name="include", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Include one or more codes from a code system", formalDefinition="Include one or more codes from a code system.")
        protected List<ConceptSetComponent> include;
        @Child(name="exclude", type={ConceptSetComponent.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Explicitly exclude codes", formalDefinition="Exclude one or more codes from the value set.")
        protected List<ConceptSetComponent> exclude;
        private static final long serialVersionUID = -703166694L;

        public List<UriType> getImport() {
            if (this.import_ == null) {
                this.import_ = new ArrayList<UriType>();
            }
            return this.import_;
        }

        public boolean hasImport() {
            if (this.import_ == null) {
                return false;
            }
            for (UriType item : this.import_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addImportElement() {
            UriType t = new UriType();
            if (this.import_ == null) {
                this.import_ = new ArrayList<UriType>();
            }
            this.import_.add(t);
            return t;
        }

        public ValueSetComposeComponent addImport(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.import_ == null) {
                this.import_ = new ArrayList<UriType>();
            }
            this.import_.add(t);
            return this;
        }

        public boolean hasImport(String value) {
            if (this.import_ == null) {
                return false;
            }
            for (UriType v : this.import_) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ConceptSetComponent> getInclude() {
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            return this.include;
        }

        public boolean hasInclude() {
            if (this.include == null) {
                return false;
            }
            for (ConceptSetComponent item : this.include) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addInclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return t;
        }

        public ValueSetComposeComponent addInclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return this;
        }

        public List<ConceptSetComponent> getExclude() {
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            return this.exclude;
        }

        public boolean hasExclude() {
            if (this.exclude == null) {
                return false;
            }
            for (ConceptSetComponent item : this.exclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addExclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return t;
        }

        public ValueSetComposeComponent addExclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("import", "uri", "Includes the contents of the referenced value set as a part of the contents of this value set. This is an absolute URI that is a reference to ValueSet.uri.", 0, Integer.MAX_VALUE, this.import_));
            childrenList.add(new Property("include", "", "Include one or more codes from a code system.", 0, Integer.MAX_VALUE, this.include));
            childrenList.add(new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set.", 0, Integer.MAX_VALUE, this.exclude));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("import")) {
                this.getImport().add(this.castToUri(value));
            } else if (name.equals("include")) {
                this.getInclude().add((ConceptSetComponent)value);
            } else if (name.equals("exclude")) {
                this.getExclude().add((ConceptSetComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("import")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.import");
            }
            if (name.equals("include")) {
                return this.addInclude();
            }
            if (name.equals("exclude")) {
                return this.addExclude();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetComposeComponent copy() {
            ValueSetComposeComponent dst = new ValueSetComposeComponent();
            this.copyValues(dst);
            if (this.import_ != null) {
                dst.import_ = new ArrayList<UriType>();
                for (UriType uriType : this.import_) {
                    dst.import_.add(uriType.copy());
                }
            }
            if (this.include != null) {
                dst.include = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent conceptSetComponent : this.include) {
                    dst.include.add(conceptSetComponent.copy());
                }
            }
            if (this.exclude != null) {
                dst.exclude = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent conceptSetComponent : this.exclude) {
                    dst.exclude.add(conceptSetComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other;
            return ValueSetComposeComponent.compareDeep(this.import_, o.import_, true) && ValueSetComposeComponent.compareDeep(this.include, o.include, true) && ValueSetComposeComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other;
            return ValueSetComposeComponent.compareValues(this.import_, o.import_, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.import_ != null && !this.import_.isEmpty() || this.include != null && !this.include.isEmpty() || this.exclude != null && !this.exclude.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose";
        }
    }

    @Block
    public static class ConceptDefinitionDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human language of the designation", formalDefinition="The language this designation is defined for.")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Details how this designation would be used", formalDefinition="A code that details how this designation would be used.")
        protected Coding use;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The text value for this designation", formalDefinition="The text value for this designation.")
        protected StringType value;
        private static final long serialVersionUID = 1515662414L;

        public ConceptDefinitionDesignationComponent() {
        }

        public ConceptDefinitionDesignationComponent(StringType value) {
            this.value = value;
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ConceptDefinitionDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionDesignationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptDefinitionDesignationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptDefinitionDesignationComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("language", ValueSet.SP_CODE, "The language this designation is defined for.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("use", "Coding", "A code that details how this designation would be used.", 0, Integer.MAX_VALUE, this.use));
            childrenList.add(new Property("value", "string", "The text value for this designation.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionDesignationComponent copy() {
            ConceptDefinitionDesignationComponent dst = new ConceptDefinitionDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other;
            return ConceptDefinitionDesignationComponent.compareDeep(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareDeep(this.use, o.use, true) && ConceptDefinitionDesignationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionDesignationComponent)) {
                return false;
            }
            ConceptDefinitionDesignationComponent o = (ConceptDefinitionDesignationComponent)other;
            return ConceptDefinitionDesignationComponent.compareValues(this.language, o.language, true) && ConceptDefinitionDesignationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.language != null && !this.language.isEmpty() || this.use != null && !this.use.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.codeSystem.concept.designation";
        }
    }

    @Block
    public static class ConceptDefinitionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that identifies concept", formalDefinition="A code - a text symbol - that uniquely identifies the concept within the code system.")
        protected CodeType code;
        @Child(name="abstract", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If this code is not for use as a real concept", formalDefinition="If this code is not for use as a real concept.")
        protected BooleanType abstract_;
        @Child(name="display", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text to display to the user", formalDefinition="A human readable string that is the recommended default way to present this concept to a user.")
        protected StringType display;
        @Child(name="definition", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Formal definition", formalDefinition="The formal definition of the concept. The value set resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.")
        protected StringType definition;
        @Child(name="designation", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for the concept", formalDefinition="Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptDefinitionDesignationComponent> designation;
        @Child(name="concept", type={ConceptDefinitionComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Child Concepts (is-a/contains/categorizes)", formalDefinition="Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) and can only be determined by examining the definitions of the concepts.")
        protected List<ConceptDefinitionComponent> concept;
        private static final long serialVersionUID = -318560292L;

        public ConceptDefinitionComponent() {
        }

        public ConceptDefinitionComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptDefinitionComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptDefinitionComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public BooleanType getAbstractElement() {
            if (this.abstract_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.abstract_");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstract_ = new BooleanType();
                }
            }
            return this.abstract_;
        }

        public boolean hasAbstractElement() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public boolean hasAbstract() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public ConceptDefinitionComponent setAbstractElement(BooleanType value) {
            this.abstract_ = value;
            return this;
        }

        public boolean getAbstract() {
            return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
        }

        public ConceptDefinitionComponent setAbstract(boolean value) {
            if (this.abstract_ == null) {
                this.abstract_ = new BooleanType();
            }
            this.abstract_.setValue((Object)value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptDefinitionComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptDefinitionComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public StringType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptDefinitionComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new StringType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public ConceptDefinitionComponent setDefinitionElement(StringType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public ConceptDefinitionComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new StringType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public List<ConceptDefinitionDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            return this.designation;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptDefinitionDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionDesignationComponent addDesignation() {
            ConceptDefinitionDesignationComponent t = new ConceptDefinitionDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptDefinitionComponent addDesignation(ConceptDefinitionDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public List<ConceptDefinitionComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptDefinitionComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionComponent addConcept() {
            ConceptDefinitionComponent t = new ConceptDefinitionComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptDefinitionComponent addConcept(ConceptDefinitionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "A code - a text symbol - that uniquely identifies the concept within the code system.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("abstract", "boolean", "If this code is not for use as a real concept.", 0, Integer.MAX_VALUE, this.abstract_));
            childrenList.add(new Property("display", "string", "A human readable string that is the recommended default way to present this concept to a user.", 0, Integer.MAX_VALUE, this.display));
            childrenList.add(new Property("definition", "string", "The formal definition of the concept. The value set resource does not make formal definitions required, because of the prevalence of legacy systems. However, they are highly recommended, as without them there is no formal meaning associated with the concept.", 0, Integer.MAX_VALUE, this.definition));
            childrenList.add(new Property("designation", "", "Additional representations for the concept - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
            childrenList.add(new Property("concept", "@ValueSet.codeSystem.concept", "Defines children of a concept to produce a hierarchy of concepts. The nature of the relationships is variable (is-a/contains/categorizes) and can only be determined by examining the definitions of the concepts.", 0, Integer.MAX_VALUE, this.concept));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("abstract")) {
                this.abstract_ = this.castToBoolean(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptDefinitionDesignationComponent)value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptDefinitionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.code");
            }
            if (name.equals("abstract")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.abstract");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.display");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.definition");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptDefinitionComponent copy() {
            ConceptDefinitionComponent dst = new ConceptDefinitionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            dst.display = this.display == null ? null : this.display.copy();
            StringType stringType = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptDefinitionDesignationComponent>();
                for (ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : this.designation) {
                    dst.designation.add(conceptDefinitionDesignationComponent.copy());
                }
            }
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptDefinitionComponent>();
                for (ConceptDefinitionComponent conceptDefinitionComponent : this.concept) {
                    dst.concept.add(conceptDefinitionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other;
            return ConceptDefinitionComponent.compareDeep(this.code, o.code, true) && ConceptDefinitionComponent.compareDeep(this.abstract_, o.abstract_, true) && ConceptDefinitionComponent.compareDeep(this.display, o.display, true) && ConceptDefinitionComponent.compareDeep(this.definition, o.definition, true) && ConceptDefinitionComponent.compareDeep(this.designation, o.designation, true) && ConceptDefinitionComponent.compareDeep(this.concept, o.concept, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ConceptDefinitionComponent)) {
                return false;
            }
            ConceptDefinitionComponent o = (ConceptDefinitionComponent)other;
            return ConceptDefinitionComponent.compareValues(this.code, o.code, true) && ConceptDefinitionComponent.compareValues(this.abstract_, o.abstract_, true) && ConceptDefinitionComponent.compareValues(this.display, o.display, true) && ConceptDefinitionComponent.compareValues(this.definition, o.definition, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.abstract_ != null && !this.abstract_.isEmpty() || this.display != null && !this.display.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.designation != null && !this.designation.isEmpty() || this.concept != null && !this.concept.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.codeSystem.concept";
        }
    }

    @Block
    public static class ValueSetCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI to identify the code system (e.g. in Coding.system)", formalDefinition="An absolute URI that is used to reference this code system, including in [Coding]{datatypes.html#Coding}.system.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version (for use in Coding.version)", formalDefinition="The version of this code system that defines the codes. Note that the version is optional because a well maintained code system does not suffer from versioning, and therefore the version does not need to be maintained. However many code systems are not well maintained, and the version needs to be defined and tracked.")
        protected StringType version;
        @Child(name="caseSensitive", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If code comparison is case sensitive", formalDefinition="If code comparison is case sensitive when codes within this system are compared to each other.")
        protected BooleanType caseSensitive;
        @Child(name="concept", type={}, order=4, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concepts in the code system", formalDefinition="Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meaning of the hierarchical relationships are.")
        protected List<ConceptDefinitionComponent> concept;
        private static final long serialVersionUID = -1109401192L;

        public ValueSetCodeSystemComponent() {
        }

        public ValueSetCodeSystemComponent(UriType system) {
            this.system = system;
        }

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetCodeSystemComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ValueSetCodeSystemComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ValueSetCodeSystemComponent setSystem(String value) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetCodeSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ValueSetCodeSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ValueSetCodeSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public BooleanType getCaseSensitiveElement() {
            if (this.caseSensitive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetCodeSystemComponent.caseSensitive");
                }
                if (Configuration.doAutoCreate()) {
                    this.caseSensitive = new BooleanType();
                }
            }
            return this.caseSensitive;
        }

        public boolean hasCaseSensitiveElement() {
            return this.caseSensitive != null && !this.caseSensitive.isEmpty();
        }

        public boolean hasCaseSensitive() {
            return this.caseSensitive != null && !this.caseSensitive.isEmpty();
        }

        public ValueSetCodeSystemComponent setCaseSensitiveElement(BooleanType value) {
            this.caseSensitive = value;
            return this;
        }

        public boolean getCaseSensitive() {
            return this.caseSensitive == null || this.caseSensitive.isEmpty() ? false : (Boolean)this.caseSensitive.getValue();
        }

        public ValueSetCodeSystemComponent setCaseSensitive(boolean value) {
            if (this.caseSensitive == null) {
                this.caseSensitive = new BooleanType();
            }
            this.caseSensitive.setValue((Object)value);
            return this;
        }

        public List<ConceptDefinitionComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptDefinitionComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptDefinitionComponent addConcept() {
            ConceptDefinitionComponent t = new ConceptDefinitionComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ValueSetCodeSystemComponent addConcept(ConceptDefinitionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptDefinitionComponent>();
            }
            this.concept.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_SYSTEM, "uri", "An absolute URI that is used to reference this code system, including in [Coding]{datatypes.html#Coding}.system.", 0, Integer.MAX_VALUE, this.system));
            childrenList.add(new Property(ValueSet.SP_VERSION, "string", "The version of this code system that defines the codes. Note that the version is optional because a well maintained code system does not suffer from versioning, and therefore the version does not need to be maintained. However many code systems are not well maintained, and the version needs to be defined and tracked.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("caseSensitive", "boolean", "If code comparison is case sensitive when codes within this system are compared to each other.", 0, Integer.MAX_VALUE, this.caseSensitive));
            childrenList.add(new Property("concept", "", "Concepts that are in the code system. The concept definitions are inherently hierarchical, but the definitions must be consulted to determine what the meaning of the hierarchical relationships are.", 0, Integer.MAX_VALUE, this.concept));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                this.system = this.castToUri(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("caseSensitive")) {
                this.caseSensitive = this.castToBoolean(value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptDefinitionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_SYSTEM)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.system");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
            }
            if (name.equals("caseSensitive")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.caseSensitive");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetCodeSystemComponent copy() {
            ValueSetCodeSystemComponent dst = new ValueSetCodeSystemComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.version = this.version == null ? null : this.version.copy();
            BooleanType booleanType = dst.caseSensitive = this.caseSensitive == null ? null : this.caseSensitive.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptDefinitionComponent>();
                for (ConceptDefinitionComponent i : this.concept) {
                    dst.concept.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetCodeSystemComponent)) {
                return false;
            }
            ValueSetCodeSystemComponent o = (ValueSetCodeSystemComponent)other;
            return ValueSetCodeSystemComponent.compareDeep(this.system, o.system, true) && ValueSetCodeSystemComponent.compareDeep(this.version, o.version, true) && ValueSetCodeSystemComponent.compareDeep(this.caseSensitive, o.caseSensitive, true) && ValueSetCodeSystemComponent.compareDeep(this.concept, o.concept, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetCodeSystemComponent)) {
                return false;
            }
            ValueSetCodeSystemComponent o = (ValueSetCodeSystemComponent)other;
            return ValueSetCodeSystemComponent.compareValues(this.system, o.system, true) && ValueSetCodeSystemComponent.compareValues(this.version, o.version, true) && ValueSetCodeSystemComponent.compareValues(this.caseSensitive, o.caseSensitive, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.system != null && !this.system.isEmpty() || this.version != null && !this.version.isEmpty() || this.caseSensitive != null && !this.caseSensitive.isEmpty() || this.concept != null && !this.concept.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.codeSystem";
        }
    }

    @Block
    public static class ValueSetContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of an individual to contact", formalDefinition="The name of an individual to contact regarding the value set.")
        protected StringType name;
        @Child(name="telecom", type={ContactPoint.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Contact details for individual or publisher", formalDefinition="Contact details for individual (if a name was provided) or the publisher.")
        protected List<ContactPoint> telecom;
        private static final long serialVersionUID = -1179697803L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ValueSetContactComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ValueSetContactComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ValueSetContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ValueSet.SP_NAME, "string", "The name of an individual to contact regarding the value set.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "Contact details for individual (if a name was provided) or the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.name");
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetContactComponent copy() {
            ValueSetContactComponent dst = new ValueSetContactComponent();
            this.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValueSetContactComponent)) {
                return false;
            }
            ValueSetContactComponent o = (ValueSetContactComponent)other;
            return ValueSetContactComponent.compareDeep(this.name, o.name, true) && ValueSetContactComponent.compareDeep(this.telecom, o.telecom, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValueSetContactComponent)) {
                return false;
            }
            ValueSetContactComponent o = (ValueSetContactComponent)other;
            return ValueSetContactComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ValueSet.contact";
        }
    }

    public static class FilterOperatorEnumFactory
    implements EnumFactory<FilterOperator> {
        @Override
        public FilterOperator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("=".equals(codeString)) {
                return FilterOperator.EQUAL;
            }
            if ("is-a".equals(codeString)) {
                return FilterOperator.ISA;
            }
            if ("is-not-a".equals(codeString)) {
                return FilterOperator.ISNOTA;
            }
            if ("regex".equals(codeString)) {
                return FilterOperator.REGEX;
            }
            if ("in".equals(codeString)) {
                return FilterOperator.IN;
            }
            if ("not-in".equals(codeString)) {
                return FilterOperator.NOTIN;
            }
            throw new IllegalArgumentException("Unknown FilterOperator code '" + codeString + "'");
        }

        public Enumeration<FilterOperator> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.EQUAL);
            }
            if ("is-a".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.ISA);
            }
            if ("is-not-a".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.ISNOTA);
            }
            if ("regex".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.REGEX);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.NOTIN);
            }
            throw new FHIRException("Unknown FilterOperator code '" + codeString + "'");
        }

        @Override
        public String toCode(FilterOperator code) {
            if (code == FilterOperator.EQUAL) {
                return "=";
            }
            if (code == FilterOperator.ISA) {
                return "is-a";
            }
            if (code == FilterOperator.ISNOTA) {
                return "is-not-a";
            }
            if (code == FilterOperator.REGEX) {
                return "regex";
            }
            if (code == FilterOperator.IN) {
                return "in";
            }
            if (code == FilterOperator.NOTIN) {
                return "not-in";
            }
            return "?";
        }
    }

    public static enum FilterOperator {
        EQUAL,
        ISA,
        ISNOTA,
        REGEX,
        IN,
        NOTIN,
        NULL;


        public static FilterOperator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return EQUAL;
            }
            if ("is-a".equals(codeString)) {
                return ISA;
            }
            if ("is-not-a".equals(codeString)) {
                return ISNOTA;
            }
            if ("regex".equals(codeString)) {
                return REGEX;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            throw new FHIRException("Unknown FilterOperator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case ISA: {
                    return "is-a";
                }
                case ISNOTA: {
                    return "is-not-a";
                }
                case REGEX: {
                    return "regex";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUAL: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case ISA: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case ISNOTA: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case REGEX: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case IN: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUAL: {
                    return "The specified property of the code equals the provided value.";
                }
                case ISA: {
                    return "Includes all concept ids that have a transitive is-a relationship with the concept Id provided as the value, including the provided concept itself.";
                }
                case ISNOTA: {
                    return "The specified property of the code does not have an is-a relationship with the provided value.";
                }
                case REGEX: {
                    return "The specified property of the code  matches the regex specified in the provided value.";
                }
                case IN: {
                    return "The specified property of the code is in the set of codes or concepts specified in the provided value (comma separated list).";
                }
                case NOTIN: {
                    return "The specified property of the code is not in the set of codes or concepts specified in the provided value (comma separated list).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUAL: {
                    return "Equals";
                }
                case ISA: {
                    return "Is A (by subsumption)";
                }
                case ISNOTA: {
                    return "Not (Is A) (by subsumption)";
                }
                case REGEX: {
                    return "Regular Expression";
                }
                case IN: {
                    return "In Set";
                }
                case NOTIN: {
                    return "Not in Set";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

