/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ProcessRequest", profile="http://hl7.org/fhir/Profile/ProcessRequest")
public class ProcessRequest
extends DomainResource {
    @Child(name="action", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="cancel | poll | reprocess | status", formalDefinition="The type of processing action being requested, for example Reversal, Readjudication, StatusRequest,PendedRequest.")
    protected Enumeration<ActionList> action;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The ProcessRequest business identifier.")
    protected List<Identifier> identifier;
    @Child(name="ruleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="target", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target of the request", formalDefinition="The organization which is the target of the request.")
    protected Reference target;
    protected Organization targetTarget;
    @Child(name="provider", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the action specified in thise request.")
    protected Reference provider;
    protected Practitioner providerTarget;
    @Child(name="organization", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the action speccified in thise request.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="request", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Request reference", formalDefinition="Reference of resource which is the target or subject of this action.")
    protected Reference request;
    protected Resource requestTarget;
    @Child(name="response", type={}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Response reference", formalDefinition="Reference of a prior response to resource which is the target or subject of this action.")
    protected Reference response;
    protected Resource responseTarget;
    @Child(name="nullify", type={BooleanType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Nullify", formalDefinition="If true remove all history excluding audit.")
    protected BooleanType nullify;
    @Child(name="reference", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference number/string", formalDefinition="A reference to supply which authenticates the process.")
    protected StringType reference;
    @Child(name="item", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Items to re-adjudicate", formalDefinition="List of top level items to be re-adjudicated, if none specified then the entire submission is re-adjudicated.")
    protected List<ItemsComponent> item;
    @Child(name="include", type={StringType.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource type(s) to include", formalDefinition="Names of resource types to include.")
    protected List<StringType> include;
    @Child(name="exclude", type={StringType.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource type(s) to exclude", formalDefinition="Names of resource types to exclude.")
    protected List<StringType> exclude;
    @Child(name="period", type={Period.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period", formalDefinition="A period of time during which the fulfilling resources would have been created.")
    protected Period period;
    private static final long serialVersionUID = -1332331220L;
    @SearchParamDefinition(name="identifier", path="ProcessRequest.identifier", description="The business identifier of the ProcessRequest", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="provider", path="ProcessRequest.provider", description="The provider who regenerated this request", type="reference")
    public static final String SP_PROVIDER = "provider";
    @SearchParamDefinition(name="organization", path="ProcessRequest.organization", description="The organization who generated this request", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="action", path="ProcessRequest.action", description="The action requested by this resource", type="token")
    public static final String SP_ACTION = "action";

    public ProcessRequest() {
    }

    public ProcessRequest(Enumeration<ActionList> action) {
        this.action = action;
    }

    public Enumeration<ActionList> getActionElement() {
        if (this.action == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.action");
            }
            if (Configuration.doAutoCreate()) {
                this.action = new Enumeration<ActionList>(new ActionListEnumFactory());
            }
        }
        return this.action;
    }

    public boolean hasActionElement() {
        return this.action != null && !this.action.isEmpty();
    }

    public boolean hasAction() {
        return this.action != null && !this.action.isEmpty();
    }

    public ProcessRequest setActionElement(Enumeration<ActionList> value) {
        this.action = value;
        return this;
    }

    public ActionList getAction() {
        return this.action == null ? null : (ActionList)((Object)this.action.getValue());
    }

    public ProcessRequest setAction(ActionList value) {
        if (this.action == null) {
            this.action = new Enumeration<ActionList>(new ActionListEnumFactory());
        }
        this.action.setValue((Object)value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProcessRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public ProcessRequest setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public ProcessRequest setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ProcessRequest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ProcessRequest setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new Reference();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public ProcessRequest setTarget(Reference value) {
        this.target = value;
        return this;
    }

    public Organization getTargetTarget() {
        if (this.targetTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.target");
            }
            if (Configuration.doAutoCreate()) {
                this.targetTarget = new Organization();
            }
        }
        return this.targetTarget;
    }

    public ProcessRequest setTargetTarget(Organization value) {
        this.targetTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public ProcessRequest setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Practitioner getProviderTarget() {
        if (this.providerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.providerTarget = new Practitioner();
            }
        }
        return this.providerTarget;
    }

    public ProcessRequest setProviderTarget(Practitioner value) {
        this.providerTarget = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ProcessRequest setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public ProcessRequest setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ProcessRequest setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Resource getRequestTarget() {
        return this.requestTarget;
    }

    public ProcessRequest setRequestTarget(Resource value) {
        this.requestTarget = value;
        return this;
    }

    public Reference getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new Reference();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public ProcessRequest setResponse(Reference value) {
        this.response = value;
        return this;
    }

    public Resource getResponseTarget() {
        return this.responseTarget;
    }

    public ProcessRequest setResponseTarget(Resource value) {
        this.responseTarget = value;
        return this;
    }

    public BooleanType getNullifyElement() {
        if (this.nullify == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.nullify");
            }
            if (Configuration.doAutoCreate()) {
                this.nullify = new BooleanType();
            }
        }
        return this.nullify;
    }

    public boolean hasNullifyElement() {
        return this.nullify != null && !this.nullify.isEmpty();
    }

    public boolean hasNullify() {
        return this.nullify != null && !this.nullify.isEmpty();
    }

    public ProcessRequest setNullifyElement(BooleanType value) {
        this.nullify = value;
        return this;
    }

    public boolean getNullify() {
        return this.nullify == null || this.nullify.isEmpty() ? false : (Boolean)this.nullify.getValue();
    }

    public ProcessRequest setNullify(boolean value) {
        if (this.nullify == null) {
            this.nullify = new BooleanType();
        }
        this.nullify.setValue((Object)value);
        return this;
    }

    public StringType getReferenceElement() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new StringType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public ProcessRequest setReferenceElement(StringType value) {
        this.reference = value;
        return this;
    }

    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public ProcessRequest setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new StringType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public List<ItemsComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemsComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemsComponent addItem() {
        ItemsComponent t = new ItemsComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ProcessRequest addItem(ItemsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return this;
    }

    public List<StringType> getInclude() {
        if (this.include == null) {
            this.include = new ArrayList<StringType>();
        }
        return this.include;
    }

    public boolean hasInclude() {
        if (this.include == null) {
            return false;
        }
        for (StringType item : this.include) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addIncludeElement() {
        StringType t = new StringType();
        if (this.include == null) {
            this.include = new ArrayList<StringType>();
        }
        this.include.add(t);
        return t;
    }

    public ProcessRequest addInclude(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.include == null) {
            this.include = new ArrayList<StringType>();
        }
        this.include.add(t);
        return this;
    }

    public boolean hasInclude(String value) {
        if (this.include == null) {
            return false;
        }
        for (StringType v : this.include) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getExclude() {
        if (this.exclude == null) {
            this.exclude = new ArrayList<StringType>();
        }
        return this.exclude;
    }

    public boolean hasExclude() {
        if (this.exclude == null) {
            return false;
        }
        for (StringType item : this.exclude) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addExcludeElement() {
        StringType t = new StringType();
        if (this.exclude == null) {
            this.exclude = new ArrayList<StringType>();
        }
        this.exclude.add(t);
        return t;
    }

    public ProcessRequest addExclude(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.exclude == null) {
            this.exclude = new ArrayList<StringType>();
        }
        this.exclude.add(t);
        return this;
    }

    public boolean hasExclude(String value) {
        if (this.exclude == null) {
            return false;
        }
        for (StringType v : this.exclude) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcessRequest.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public ProcessRequest setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_ACTION, "code", "The type of processing action being requested, for example Reversal, Readjudication, StatusRequest,PendedRequest.", 0, Integer.MAX_VALUE, this.action));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The ProcessRequest business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when this resource was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("target", "Reference(Organization)", "The organization which is the target of the request.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property(SP_PROVIDER, "Reference(Practitioner)", "The practitioner who is responsible for the action specified in thise request.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization which is responsible for the action speccified in thise request.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("request", "Reference(Any)", "Reference of resource which is the target or subject of this action.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("response", "Reference(Any)", "Reference of a prior response to resource which is the target or subject of this action.", 0, Integer.MAX_VALUE, this.response));
        childrenList.add(new Property("nullify", "boolean", "If true remove all history excluding audit.", 0, Integer.MAX_VALUE, this.nullify));
        childrenList.add(new Property("reference", "string", "A reference to supply which authenticates the process.", 0, Integer.MAX_VALUE, this.reference));
        childrenList.add(new Property("item", "", "List of top level items to be re-adjudicated, if none specified then the entire submission is re-adjudicated.", 0, Integer.MAX_VALUE, this.item));
        childrenList.add(new Property("include", "string", "Names of resource types to include.", 0, Integer.MAX_VALUE, this.include));
        childrenList.add(new Property("exclude", "string", "Names of resource types to exclude.", 0, Integer.MAX_VALUE, this.exclude));
        childrenList.add(new Property("period", "Period", "A period of time during which the fulfilling resources would have been created.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_ACTION)) {
            this.action = new ActionListEnumFactory().fromType(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target")) {
            this.target = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = this.castToReference(value);
        } else if (name.equals("request")) {
            this.request = this.castToReference(value);
        } else if (name.equals("response")) {
            this.response = this.castToReference(value);
        } else if (name.equals("nullify")) {
            this.nullify = this.castToBoolean(value);
        } else if (name.equals("reference")) {
            this.reference = this.castToString(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemsComponent)value);
        } else if (name.equals("include")) {
            this.getInclude().add(this.castToString(value));
        } else if (name.equals("exclude")) {
            this.getExclude().add(this.castToString(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_ACTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.action");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.created");
        }
        if (name.equals("target")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("request")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("response")) {
            this.response = new Reference();
            return this.response;
        }
        if (name.equals("nullify")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.nullify");
        }
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.reference");
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("include")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.include");
        }
        if (name.equals("exclude")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.exclude");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProcessRequest";
    }

    @Override
    public ProcessRequest copy() {
        ProcessRequest dst = new ProcessRequest();
        this.copyValues(dst);
        Enumeration<ActionList> enumeration = dst.action = this.action == null ? null : this.action.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.response = this.response == null ? null : this.response.copy();
        dst.nullify = this.nullify == null ? null : this.nullify.copy();
        StringType stringType = dst.reference = this.reference == null ? null : this.reference.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemsComponent>();
            for (ItemsComponent itemsComponent : this.item) {
                dst.item.add(itemsComponent.copy());
            }
        }
        if (this.include != null) {
            dst.include = new ArrayList<StringType>();
            for (StringType stringType2 : this.include) {
                dst.include.add(stringType2.copy());
            }
        }
        if (this.exclude != null) {
            dst.exclude = new ArrayList<StringType>();
            for (StringType stringType3 : this.exclude) {
                dst.exclude.add(stringType3.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        return dst;
    }

    protected ProcessRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ProcessRequest)) {
            return false;
        }
        ProcessRequest o = (ProcessRequest)other;
        return ProcessRequest.compareDeep(this.action, o.action, true) && ProcessRequest.compareDeep(this.identifier, o.identifier, true) && ProcessRequest.compareDeep(this.ruleset, o.ruleset, true) && ProcessRequest.compareDeep(this.originalRuleset, o.originalRuleset, true) && ProcessRequest.compareDeep(this.created, o.created, true) && ProcessRequest.compareDeep(this.target, o.target, true) && ProcessRequest.compareDeep(this.provider, o.provider, true) && ProcessRequest.compareDeep(this.organization, o.organization, true) && ProcessRequest.compareDeep(this.request, o.request, true) && ProcessRequest.compareDeep(this.response, o.response, true) && ProcessRequest.compareDeep(this.nullify, o.nullify, true) && ProcessRequest.compareDeep(this.reference, o.reference, true) && ProcessRequest.compareDeep(this.item, o.item, true) && ProcessRequest.compareDeep(this.include, o.include, true) && ProcessRequest.compareDeep(this.exclude, o.exclude, true) && ProcessRequest.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ProcessRequest)) {
            return false;
        }
        ProcessRequest o = (ProcessRequest)other;
        return ProcessRequest.compareValues(this.action, o.action, true) && ProcessRequest.compareValues(this.created, o.created, true) && ProcessRequest.compareValues(this.nullify, o.nullify, true) && ProcessRequest.compareValues(this.reference, o.reference, true) && ProcessRequest.compareValues(this.include, o.include, true) && ProcessRequest.compareValues(this.exclude, o.exclude, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.action != null && !this.action.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.target != null && !this.target.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.request != null && !this.request.isEmpty() || this.response != null && !this.response.isEmpty() || this.nullify != null && !this.nullify.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.item != null && !this.item.isEmpty() || this.include != null && !this.include.isEmpty() || this.exclude != null && !this.exclude.isEmpty() || this.period != null && !this.period.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProcessRequest;
    }

    @Block
    public static class ItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected IntegerType sequenceLinkId;
        private static final long serialVersionUID = -1598360600L;

        public ItemsComponent() {
        }

        public ItemsComponent(IntegerType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public IntegerType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new IntegerType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ItemsComponent setSequenceLinkIdElement(IntegerType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ItemsComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new IntegerType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "integer", "A service line number.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToInteger(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ProcessRequest.sequenceLinkId");
            }
            return super.addChild(name);
        }

        @Override
        public ItemsComponent copy() {
            ItemsComponent dst = new ItemsComponent();
            this.copyValues(dst);
            dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.sequenceLinkId == null || this.sequenceLinkId.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ProcessRequest.item";
        }
    }

    public static class ActionListEnumFactory
    implements EnumFactory<ActionList> {
        @Override
        public ActionList fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("cancel".equals(codeString)) {
                return ActionList.CANCEL;
            }
            if ("poll".equals(codeString)) {
                return ActionList.POLL;
            }
            if ("reprocess".equals(codeString)) {
                return ActionList.REPROCESS;
            }
            if ("status".equals(codeString)) {
                return ActionList.STATUS;
            }
            throw new IllegalArgumentException("Unknown ActionList code '" + codeString + "'");
        }

        public Enumeration<ActionList> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("cancel".equals(codeString)) {
                return new Enumeration<ActionList>(this, ActionList.CANCEL);
            }
            if ("poll".equals(codeString)) {
                return new Enumeration<ActionList>(this, ActionList.POLL);
            }
            if ("reprocess".equals(codeString)) {
                return new Enumeration<ActionList>(this, ActionList.REPROCESS);
            }
            if ("status".equals(codeString)) {
                return new Enumeration<ActionList>(this, ActionList.STATUS);
            }
            throw new FHIRException("Unknown ActionList code '" + codeString + "'");
        }

        @Override
        public String toCode(ActionList code) {
            if (code == ActionList.CANCEL) {
                return "cancel";
            }
            if (code == ActionList.POLL) {
                return "poll";
            }
            if (code == ActionList.REPROCESS) {
                return "reprocess";
            }
            if (code == ActionList.STATUS) {
                return "status";
            }
            return "?";
        }
    }

    public static enum ActionList {
        CANCEL,
        POLL,
        REPROCESS,
        STATUS,
        NULL;


        public static ActionList fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("cancel".equals(codeString)) {
                return CANCEL;
            }
            if ("poll".equals(codeString)) {
                return POLL;
            }
            if ("reprocess".equals(codeString)) {
                return REPROCESS;
            }
            if ("status".equals(codeString)) {
                return STATUS;
            }
            throw new FHIRException("Unknown ActionList code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CANCEL: {
                    return "cancel";
                }
                case POLL: {
                    return "poll";
                }
                case REPROCESS: {
                    return "reprocess";
                }
                case STATUS: {
                    return "status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CANCEL: {
                    return "http://hl7.org/fhir/actionlist";
                }
                case POLL: {
                    return "http://hl7.org/fhir/actionlist";
                }
                case REPROCESS: {
                    return "http://hl7.org/fhir/actionlist";
                }
                case STATUS: {
                    return "http://hl7.org/fhir/actionlist";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CANCEL: {
                    return "Cancel, reverse or nullify the target resource.";
                }
                case POLL: {
                    return "Check for previously un-read/ not-retrieved resources.";
                }
                case REPROCESS: {
                    return "Re-process the target resource.";
                }
                case STATUS: {
                    return "Retrieve the processing status of the target resource.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CANCEL: {
                    return "Cancel, Reverse or Nullify";
                }
                case POLL: {
                    return "Poll";
                }
                case REPROCESS: {
                    return "Re-Process";
                }
                case STATUS: {
                    return "Status Check";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

