/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.OidType;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingObjectSelection", profile="http://hl7.org/fhir/Profile/ImagingObjectSelection")
public class ImagingObjectSelection
extends DomainResource {
    @Child(name="uid", type={OidType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Instance UID", formalDefinition="Instance UID of the DICOM KOS SOP Instances represented in this resource.")
    protected OidType uid;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient of the selected objects", formalDefinition="A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingObjectSelection.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="title", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for selection", formalDefinition="The reason for, or significance of, the selection of objects referenced in the resource.")
    protected CodeableConcept title;
    @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description text", formalDefinition="Text description of the DICOM SOP instances selected in the ImagingObjectSelection. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.")
    protected StringType description;
    @Child(name="author", type={Practitioner.class, Device.class, Organization.class, Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author (human or machine)", formalDefinition="Author of ImagingObjectSelection. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="authoringTime", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Authoring time of the selection", formalDefinition="Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).")
    protected DateTimeType authoringTime;
    @Child(name="study", type={}, order=6, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study identity of the selected instances", formalDefinition="Study identity and locating information of the DICOM SOP instances in the selection.")
    protected List<StudyComponent> study;
    private static final long serialVersionUID = -1961832713L;
    @SearchParamDefinition(name="identifier", path="ImagingObjectSelection.uid", description="UID of key DICOM object selection", type="uri")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="authoring-time", path="ImagingObjectSelection.authoringTime", description="Time of key DICOM object selection authoring", type="date")
    public static final String SP_AUTHORINGTIME = "authoring-time";
    @SearchParamDefinition(name="selected-study", path="ImagingObjectSelection.study.uid", description="Study selected in key DICOM object selection", type="uri")
    public static final String SP_SELECTEDSTUDY = "selected-study";
    @SearchParamDefinition(name="author", path="ImagingObjectSelection.author", description="Author of key DICOM object selection", type="reference")
    public static final String SP_AUTHOR = "author";
    @SearchParamDefinition(name="patient", path="ImagingObjectSelection.patient", description="Subject of key DICOM object selection", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="title", path="ImagingObjectSelection.title", description="Title of key DICOM object selection", type="token")
    public static final String SP_TITLE = "title";

    public ImagingObjectSelection() {
    }

    public ImagingObjectSelection(OidType uid, Reference patient, CodeableConcept title) {
        this.uid = uid;
        this.patient = patient;
        this.title = title;
    }

    public OidType getUidElement() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OidType();
            }
        }
        return this.uid;
    }

    public boolean hasUidElement() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ImagingObjectSelection setUidElement(OidType value) {
        this.uid = value;
        return this;
    }

    public String getUid() {
        return this.uid == null ? null : (String)this.uid.getValue();
    }

    public ImagingObjectSelection setUid(String value) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingObjectSelection setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingObjectSelection setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public CodeableConcept getTitle() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new CodeableConcept();
            }
        }
        return this.title;
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public ImagingObjectSelection setTitle(CodeableConcept value) {
        this.title = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingObjectSelection setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingObjectSelection setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public ImagingObjectSelection setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public ImagingObjectSelection setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public DateTimeType getAuthoringTimeElement() {
        if (this.authoringTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingObjectSelection.authoringTime");
            }
            if (Configuration.doAutoCreate()) {
                this.authoringTime = new DateTimeType();
            }
        }
        return this.authoringTime;
    }

    public boolean hasAuthoringTimeElement() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public boolean hasAuthoringTime() {
        return this.authoringTime != null && !this.authoringTime.isEmpty();
    }

    public ImagingObjectSelection setAuthoringTimeElement(DateTimeType value) {
        this.authoringTime = value;
        return this;
    }

    public Date getAuthoringTime() {
        return this.authoringTime == null ? null : (Date)this.authoringTime.getValue();
    }

    public ImagingObjectSelection setAuthoringTime(Date value) {
        if (value == null) {
            this.authoringTime = null;
        } else {
            if (this.authoringTime == null) {
                this.authoringTime = new DateTimeType();
            }
            this.authoringTime.setValue(value);
        }
        return this;
    }

    public List<StudyComponent> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        return this.study;
    }

    public boolean hasStudy() {
        if (this.study == null) {
            return false;
        }
        for (StudyComponent item : this.study) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StudyComponent addStudy() {
        StudyComponent t = new StudyComponent();
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return t;
    }

    public ImagingObjectSelection addStudy(StudyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.study == null) {
            this.study = new ArrayList<StudyComponent>();
        }
        this.study.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("uid", "oid", "Instance UID of the DICOM KOS SOP Instances represented in this resource.", 0, Integer.MAX_VALUE, this.uid));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingObjectSelection.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_TITLE, "CodeableConcept", "The reason for, or significance of, the selection of objects referenced in the resource.", 0, Integer.MAX_VALUE, this.title));
        childrenList.add(new Property("description", "string", "Text description of the DICOM SOP instances selected in the ImagingObjectSelection. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Device|Organization|Patient|RelatedPerson)", "Author of ImagingObjectSelection. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("authoringTime", "dateTime", "Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).", 0, Integer.MAX_VALUE, this.authoringTime));
        childrenList.add(new Property("study", "", "Study identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.study));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = this.castToOid(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToCodeableConcept(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals("authoringTime")) {
            this.authoringTime = this.castToDateTime(value);
        } else if (name.equals("study")) {
            this.getStudy().add((StudyComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_TITLE)) {
            this.title = new CodeableConcept();
            return this.title;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.description");
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("authoringTime")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.authoringTime");
        }
        if (name.equals("study")) {
            return this.addStudy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingObjectSelection";
    }

    @Override
    public ImagingObjectSelection copy() {
        ImagingObjectSelection dst = new ImagingObjectSelection();
        this.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.author = this.author == null ? null : this.author.copy();
        DateTimeType dateTimeType = dst.authoringTime = this.authoringTime == null ? null : this.authoringTime.copy();
        if (this.study != null) {
            dst.study = new ArrayList<StudyComponent>();
            for (StudyComponent i : this.study) {
                dst.study.add(i.copy());
            }
        }
        return dst;
    }

    protected ImagingObjectSelection typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImagingObjectSelection)) {
            return false;
        }
        ImagingObjectSelection o = (ImagingObjectSelection)other;
        return ImagingObjectSelection.compareDeep(this.uid, o.uid, true) && ImagingObjectSelection.compareDeep(this.patient, o.patient, true) && ImagingObjectSelection.compareDeep(this.title, o.title, true) && ImagingObjectSelection.compareDeep(this.description, o.description, true) && ImagingObjectSelection.compareDeep(this.author, o.author, true) && ImagingObjectSelection.compareDeep(this.authoringTime, o.authoringTime, true) && ImagingObjectSelection.compareDeep(this.study, o.study, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImagingObjectSelection)) {
            return false;
        }
        ImagingObjectSelection o = (ImagingObjectSelection)other;
        return ImagingObjectSelection.compareValues(this.uid, o.uid, true) && ImagingObjectSelection.compareValues(this.description, o.description, true) && ImagingObjectSelection.compareValues(this.authoringTime, o.authoringTime, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.title != null && !this.title.isEmpty() || this.description != null && !this.description.isEmpty() || this.author != null && !this.author.isEmpty() || this.authoringTime != null && !this.authoringTime.isEmpty() || this.study != null && !this.study.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingObjectSelection;
    }

    @Block
    public static class FramesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="frameNumbers", type={UnsignedIntType.class}, order=1, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Frame numbers", formalDefinition="The frame numbers in the frame set.")
        protected List<UnsignedIntType> frameNumbers;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve frame URL", formalDefinition="WADO-RS URL to retrieve the DICOM frames.")
        protected UriType url;
        private static final long serialVersionUID = -2068206970L;

        public FramesComponent() {
        }

        public FramesComponent(UriType url) {
            this.url = url;
        }

        public List<UnsignedIntType> getFrameNumbers() {
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            return this.frameNumbers;
        }

        public boolean hasFrameNumbers() {
            if (this.frameNumbers == null) {
                return false;
            }
            for (UnsignedIntType item : this.frameNumbers) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UnsignedIntType addFrameNumbersElement() {
            UnsignedIntType t = new UnsignedIntType();
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            this.frameNumbers.add(t);
            return t;
        }

        public FramesComponent addFrameNumbers(int value) {
            UnsignedIntType t = new UnsignedIntType();
            t.setValue((Object)value);
            if (this.frameNumbers == null) {
                this.frameNumbers = new ArrayList<UnsignedIntType>();
            }
            this.frameNumbers.add(t);
            return this;
        }

        public boolean hasFrameNumbers(int value) {
            if (this.frameNumbers == null) {
                return false;
            }
            for (UnsignedIntType v : this.frameNumbers) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create FramesComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public FramesComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public FramesComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("frameNumbers", "unsignedInt", "The frame numbers in the frame set.", 0, Integer.MAX_VALUE, this.frameNumbers));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the DICOM frames.", 0, Integer.MAX_VALUE, this.url));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("frameNumbers")) {
                this.getFrameNumbers().add(this.castToUnsignedInt(value));
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("frameNumbers")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.frameNumbers");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            return super.addChild(name);
        }

        @Override
        public FramesComponent copy() {
            FramesComponent dst = new FramesComponent();
            this.copyValues(dst);
            if (this.frameNumbers != null) {
                dst.frameNumbers = new ArrayList<UnsignedIntType>();
                for (UnsignedIntType i : this.frameNumbers) {
                    dst.frameNumbers.add(i.copy());
                }
            }
            dst.url = this.url == null ? null : this.url.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof FramesComponent)) {
                return false;
            }
            FramesComponent o = (FramesComponent)other;
            return FramesComponent.compareDeep(this.frameNumbers, o.frameNumbers, true) && FramesComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof FramesComponent)) {
                return false;
            }
            FramesComponent o = (FramesComponent)other;
            return FramesComponent.compareValues(this.frameNumbers, o.frameNumbers, true) && FramesComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.frameNumbers != null && !this.frameNumbers.isEmpty() || this.url != null && !this.url.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series.instance.frames";
        }
    }

    @Block
    public static class InstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sopClass", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="SOP class UID of instance", formalDefinition="SOP class UID of the selected instance.")
        protected OidType sopClass;
        @Child(name="uid", type={OidType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Selected instance UID", formalDefinition="SOP Instance UID of the selected instance.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve instance URL", formalDefinition="WADO-RS URL to retrieve the DICOM SOP Instance.")
        protected UriType url;
        @Child(name="frames", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The frame set", formalDefinition="Identity and location information of the frames in the selected instance.")
        protected List<FramesComponent> frames;
        private static final long serialVersionUID = 1641180916L;

        public InstanceComponent() {
        }

        public InstanceComponent(OidType sopClass, OidType uid, UriType url) {
            this.sopClass = sopClass;
            this.uid = uid;
            this.url = url;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public InstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public InstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public InstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public InstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InstanceComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public InstanceComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public InstanceComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public List<FramesComponent> getFrames() {
            if (this.frames == null) {
                this.frames = new ArrayList<FramesComponent>();
            }
            return this.frames;
        }

        public boolean hasFrames() {
            if (this.frames == null) {
                return false;
            }
            for (FramesComponent item : this.frames) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public FramesComponent addFrames() {
            FramesComponent t = new FramesComponent();
            if (this.frames == null) {
                this.frames = new ArrayList<FramesComponent>();
            }
            this.frames.add(t);
            return t;
        }

        public InstanceComponent addFrames(FramesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.frames == null) {
                this.frames = new ArrayList<FramesComponent>();
            }
            this.frames.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sopClass", "oid", "SOP class UID of the selected instance.", 0, Integer.MAX_VALUE, this.sopClass));
            childrenList.add(new Property("uid", "oid", "SOP Instance UID of the selected instance.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the DICOM SOP Instance.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("frames", "", "Identity and location information of the frames in the selected instance.", 0, Integer.MAX_VALUE, this.frames));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("frames")) {
                this.getFrames().add((FramesComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.sopClass");
            }
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("frames")) {
                return this.addFrames();
            }
            return super.addChild(name);
        }

        @Override
        public InstanceComponent copy() {
            InstanceComponent dst = new InstanceComponent();
            this.copyValues(dst);
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.uid = this.uid == null ? null : this.uid.copy();
            UriType uriType = dst.url = this.url == null ? null : this.url.copy();
            if (this.frames != null) {
                dst.frames = new ArrayList<FramesComponent>();
                for (FramesComponent i : this.frames) {
                    dst.frames.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && InstanceComponent.compareDeep(this.uid, o.uid, true) && InstanceComponent.compareDeep(this.url, o.url, true) && InstanceComponent.compareDeep(this.frames, o.frames, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof InstanceComponent)) {
                return false;
            }
            InstanceComponent o = (InstanceComponent)other;
            return InstanceComponent.compareValues(this.sopClass, o.sopClass, true) && InstanceComponent.compareValues(this.uid, o.uid, true) && InstanceComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sopClass != null && !this.sopClass.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.frames != null && !this.frames.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series.instance";
        }
    }

    @Block
    public static class SeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Series instance UID", formalDefinition="Series instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve series URL", formalDefinition="WADO-RS URL to retrieve the series. Note that this URL retrieves all SOP instances of the series not only those in the selection.")
        protected UriType url;
        @Child(name="instance", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The selected instance", formalDefinition="Identity and locating information of the selected DICOM SOP instances.")
        protected List<InstanceComponent> instance;
        private static final long serialVersionUID = 229247770L;

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public SeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public SeriesComponent setUid(String value) {
            if (Utilities.noString((String)value)) {
                this.uid = null;
            } else {
                if (this.uid == null) {
                    this.uid = new OidType();
                }
                this.uid.setValue(value);
            }
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SeriesComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public SeriesComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public SeriesComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public List<InstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            return this.instance;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (InstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InstanceComponent addInstance() {
            InstanceComponent t = new InstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public SeriesComponent addInstance(InstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<InstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Series instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the series. Note that this URL retrieves all SOP instances of the series not only those in the selection.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("instance", "", "Identity and locating information of the selected DICOM SOP instances.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("instance")) {
                this.getInstance().add((InstanceComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public SeriesComponent copy() {
            SeriesComponent dst = new SeriesComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            UriType uriType = dst.url = this.url == null ? null : this.url.copy();
            if (this.instance != null) {
                dst.instance = new ArrayList<InstanceComponent>();
                for (InstanceComponent i : this.instance) {
                    dst.instance.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareDeep(this.uid, o.uid, true) && SeriesComponent.compareDeep(this.url, o.url, true) && SeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SeriesComponent)) {
                return false;
            }
            SeriesComponent o = (SeriesComponent)other;
            return SeriesComponent.compareValues(this.uid, o.uid, true) && SeriesComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.instance != null && !this.instance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study.series";
        }
    }

    @Block
    public static class StudyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Study instance UID", formalDefinition="Study instance UID of the SOP instances in the selection.")
        protected OidType uid;
        @Child(name="url", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Retrieve study URL", formalDefinition="WADO-RS URL to retrieve the study. Note that this URL retrieves all SOP instances of the study, not only those in the selection.")
        protected UriType url;
        @Child(name="imagingStudy", type={ImagingStudy.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to ImagingStudy", formalDefinition="Reference to the Imaging Study in FHIR form.")
        protected Reference imagingStudy;
        protected ImagingStudy imagingStudyTarget;
        @Child(name="series", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series identity of the selected instances", formalDefinition="Series identity and locating information of the DICOM SOP instances in the selection.")
        protected List<SeriesComponent> series;
        private static final long serialVersionUID = 341246743L;

        public StudyComponent() {
        }

        public StudyComponent(OidType uid) {
            this.uid = uid;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public StudyComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public StudyComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public StudyComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public StudyComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public Reference getImagingStudy() {
            if (this.imagingStudy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudy = new Reference();
                }
            }
            return this.imagingStudy;
        }

        public boolean hasImagingStudy() {
            return this.imagingStudy != null && !this.imagingStudy.isEmpty();
        }

        public StudyComponent setImagingStudy(Reference value) {
            this.imagingStudy = value;
            return this;
        }

        public ImagingStudy getImagingStudyTarget() {
            if (this.imagingStudyTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StudyComponent.imagingStudy");
                }
                if (Configuration.doAutoCreate()) {
                    this.imagingStudyTarget = new ImagingStudy();
                }
            }
            return this.imagingStudyTarget;
        }

        public StudyComponent setImagingStudyTarget(ImagingStudy value) {
            this.imagingStudyTarget = value;
            return this;
        }

        public List<SeriesComponent> getSeries() {
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            return this.series;
        }

        public boolean hasSeries() {
            if (this.series == null) {
                return false;
            }
            for (SeriesComponent item : this.series) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SeriesComponent addSeries() {
            SeriesComponent t = new SeriesComponent();
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return t;
        }

        public StudyComponent addSeries(SeriesComponent t) {
            if (t == null) {
                return this;
            }
            if (this.series == null) {
                this.series = new ArrayList<SeriesComponent>();
            }
            this.series.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("uid", "oid", "Study instance UID of the SOP instances in the selection.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("url", "uri", "WADO-RS URL to retrieve the study. Note that this URL retrieves all SOP instances of the study, not only those in the selection.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("imagingStudy", "Reference(ImagingStudy)", "Reference to the Imaging Study in FHIR form.", 0, Integer.MAX_VALUE, this.imagingStudy));
            childrenList.add(new Property("series", "", "Series identity and locating information of the DICOM SOP instances in the selection.", 0, Integer.MAX_VALUE, this.series));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = this.castToOid(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("imagingStudy")) {
                this.imagingStudy = this.castToReference(value);
            } else if (name.equals("series")) {
                this.getSeries().add((SeriesComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.uid");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingObjectSelection.url");
            }
            if (name.equals("imagingStudy")) {
                this.imagingStudy = new Reference();
                return this.imagingStudy;
            }
            if (name.equals("series")) {
                return this.addSeries();
            }
            return super.addChild(name);
        }

        @Override
        public StudyComponent copy() {
            StudyComponent dst = new StudyComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.url = this.url == null ? null : this.url.copy();
            Reference reference = dst.imagingStudy = this.imagingStudy == null ? null : this.imagingStudy.copy();
            if (this.series != null) {
                dst.series = new ArrayList<SeriesComponent>();
                for (SeriesComponent i : this.series) {
                    dst.series.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareDeep(this.uid, o.uid, true) && StudyComponent.compareDeep(this.url, o.url, true) && StudyComponent.compareDeep(this.imagingStudy, o.imagingStudy, true) && StudyComponent.compareDeep(this.series, o.series, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof StudyComponent)) {
                return false;
            }
            StudyComponent o = (StudyComponent)other;
            return StudyComponent.compareValues(this.uid, o.uid, true) && StudyComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.url != null && !this.url.isEmpty() || this.imagingStudy != null && !this.imagingStudy.isEmpty() || this.series != null && !this.series.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingObjectSelection.study";
        }
    }
}

