/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.Constants;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.dstu2.model.PrimitiveType;

@DatatypeDef(name="base64Binary")
public class Base64BinaryType
extends PrimitiveType<byte[]> {
    private static final long serialVersionUID = 3L;

    public Base64BinaryType() {
    }

    public Base64BinaryType(byte[] theBytes) {
        this.setValue(theBytes);
    }

    public Base64BinaryType(String theValue) {
        this.setValueAsString(theValue);
    }

    @Override
    public void setValueAsString(String theValue) {
        if (theValue != null) {
            this.checkValidBase64(theValue);
        }
        super.setValueAsString(theValue);
    }

    @Override
    protected byte[] parse(String theValue) {
        if (theValue != null) {
            return Base64.decodeBase64((byte[])theValue.getBytes(Constants.CHARSET_UTF8));
        }
        return null;
    }

    @Override
    protected String encode(byte[] theValue) {
        if (theValue == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])theValue), Constants.CHARSET_UTF8);
    }

    @Override
    public Base64BinaryType copy() {
        return new Base64BinaryType((byte[])this.getValue());
    }

    @Override
    public String fhirType() {
        return "base64Binary";
    }

    public void checkValidBase64(String toCheck) throws DataFormatException {
        if (!Base64.isBase64((byte[])toCheck.getBytes())) {
            throw new DataFormatException("");
        }
    }
}

