/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.validation;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.DefaultProfileValidationSupport;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r4.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.TypeDetails;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.hl7.fhir.r4.utils.IResourceValidator;
import org.hl7.fhir.r4.validation.InstanceValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirInstanceValidator.class);
    private boolean myAnyExtensionsAllowed = true;
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private DocumentBuilderFactory myDocBuilderFactory = DocumentBuilderFactory.newInstance();
    private boolean myNoTerminologyChecks;
    private StructureDefinition myStructureDefintion;
    private IValidationSupport myValidationSupport;

    public FhirInstanceValidator() {
        this((IValidationSupport)new DefaultProfileValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myDocBuilderFactory.setNamespaceAware(true);
        this.myValidationSupport = theValidationSupport;
    }

    private String determineResourceName(Document theDocument) {
        Element root = null;
        NodeList list = theDocument.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            root = (Element)list.item(i);
            break;
        }
        root = theDocument.getDocumentElement();
        return root.getLocalName();
    }

    private ArrayList<String> determineIfProfilesSpecified(Document theDocument) {
        ArrayList<String> profileNames = new ArrayList<String>();
        NodeList list = theDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().compareToIgnoreCase("meta") != 0) continue;
            NodeList metaList = list.item(i).getChildNodes();
            for (int j = 0; j < metaList.getLength(); ++j) {
                if (metaList.item(j).getNodeName().compareToIgnoreCase("profile") != 0) continue;
                profileNames.add(metaList.item(j).getAttributes().item(0).getNodeValue());
            }
            break;
        }
        return profileNames;
    }

    private StructureDefinition findStructureDefinitionForResourceName(FhirContext theCtx, String resourceName) {
        String sdName = null;
        try {
            URL testIfUrl = new URL(resourceName);
            sdName = resourceName;
        }
        catch (MalformedURLException e) {
            sdName = "http://hl7.org/fhir/StructureDefinition/" + resourceName;
        }
        StructureDefinition profile = this.myStructureDefintion != null ? this.myStructureDefintion : this.myValidationSupport.fetchStructureDefinition(theCtx, sdName);
        return profile;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isNoTerminologyChecks() {
        return this.myNoTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.myNoTerminologyChecks = theNoTerminologyChecks;
    }

    public void setStructureDefintion(StructureDefinition theStructureDefintion) {
        this.myStructureDefintion = theStructureDefintion;
    }

    protected List<ValidationMessage> validate(FhirContext theCtx, String theInput, EncodingEnum theEncoding) {
        InstanceValidator v;
        HapiWorkerContext workerContext = new HapiWorkerContext(theCtx, this.myValidationSupport);
        NullEvaluationContext evaluationCtx = new NullEvaluationContext();
        try {
            v = new InstanceValidator((IWorkerContext)workerContext, evaluationCtx);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        v.setBestPracticeWarningLevel(this.getBestPracticeWarningLevel());
        v.setAnyExtensionsAllowed(this.isAnyExtensionsAllowed());
        v.setResourceIdRule(IResourceValidator.IdStatus.OPTIONAL);
        v.setNoTerminologyChecks(this.isNoTerminologyChecks());
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (theEncoding == EncodingEnum.XML) {
            Document document;
            try {
                DocumentBuilder builder = this.myDocBuilderFactory.newDocumentBuilder();
                InputSource src = new InputSource(new StringReader(theInput));
                document = builder.parse(src);
            }
            catch (Exception e2) {
                ourLog.error("Failure to parse XML input", (Throwable)e2);
                ValidationMessage m = new ValidationMessage();
                m.setLevel(ValidationMessage.IssueSeverity.FATAL);
                m.setMessage("Failed to parse input, it does not appear to be valid XML:" + e2.getMessage());
                return Collections.singletonList(m);
            }
            ArrayList<String> resourceNames = this.determineIfProfilesSpecified(document);
            if (resourceNames.isEmpty()) {
                resourceNames.add(this.determineResourceName(document));
            }
            for (String resourceName : resourceNames) {
                Iterator profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
                if (profile != null) {
                    try {
                        v.validate(null, messages, document, profile.getUrl());
                        continue;
                    }
                    catch (Exception e) {
                        ourLog.error("Failure during validation", (Throwable)e);
                        throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                    }
                }
                profile = this.findStructureDefinitionForResourceName(theCtx, this.determineResourceName(document));
                if (profile == null) continue;
                try {
                    v.validate(null, messages, document, profile.getUrl());
                }
                catch (Exception e) {
                    ourLog.error("Failure during validation", (Throwable)e);
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else if (theEncoding == EncodingEnum.JSON) {
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(theInput, JsonObject.class);
            ArrayList<String> resourceNames = new ArrayList<String>();
            JsonArray profiles = null;
            try {
                profiles = json.getAsJsonObject("meta").getAsJsonArray("profile");
                for (JsonElement element : profiles) {
                    resourceNames.add(element.getAsString());
                }
            }
            catch (Exception e) {
                resourceNames.add(json.get("resourceType").getAsString());
            }
            for (String resourceName : resourceNames) {
                StructureDefinition profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
                if (profile != null) {
                    try {
                        v.validate(null, messages, json, profile.getUrl());
                        continue;
                    }
                    catch (Exception e) {
                        throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                    }
                }
                profile = this.findStructureDefinitionForResourceName(theCtx, json.get("resourceType").getAsString());
                if (profile == null) continue;
                try {
                    v.validate(null, messages, json, profile.getUrl());
                }
                catch (Exception e) {
                    ourLog.error("Failure during validation", (Throwable)e);
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + theEncoding);
        }
        for (int i = 0; i < messages.size(); ++i) {
            ValidationMessage next = (ValidationMessage)messages.get(i);
            if (!"Binding has no source, so can't be checked".equals(next.getMessage())) continue;
            messages.remove(i);
            --i;
        }
        return messages;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theCtx) {
        return this.validate(theCtx.getFhirContext(), theCtx.getResourceAsString(), theCtx.getResourceAsStringEncoding());
    }

    public static class NullEvaluationContext
    implements FHIRPathEngine.IEvaluationContext {
        public TypeDetails checkFunction(Object theAppContext, String theFunctionName, List<TypeDetails> theParameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(Object theAppContext, String theFunctionName, List<List<Base>> theParameters) {
            return null;
        }

        public boolean log(String theArgument, List<Base> theFocus) {
            return false;
        }

        public Base resolveConstant(Object theAppContext, String theName) throws PathEngineException {
            return null;
        }

        public TypeDetails resolveConstantType(Object theAppContext, String theName) throws PathEngineException {
            return null;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String theFunctionName) {
            return null;
        }

        public Base resolveReference(Object theAppContext, String theUrl) {
            return null;
        }
    }
}

