/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.QuestionnaireResponse;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.TimeType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.IWorkerContext;
import org.hl7.fhir.instance.validation.BaseValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class QuestionnaireResponseValidator
extends BaseValidator {
    private IWorkerContext myWorkerCtx;

    public QuestionnaireResponseValidator(IWorkerContext theWorkerCtx) {
        this.myWorkerCtx = theWorkerCtx;
    }

    private Set<Class<? extends Type>> allowedTypes(Class<? extends Type> theClass0) {
        HashSet<Class<? extends Type>> retVal = new HashSet<Class<? extends Type>>();
        retVal.add(theClass0);
        return Collections.unmodifiableSet(retVal);
    }

    private Set<Class<? extends Type>> determineAllowedAnswerTypes(Questionnaire.AnswerFormat type) {
        Set<Class<? extends Type>> allowedAnswerTypes;
        switch (type) {
            case ATTACHMENT: {
                allowedAnswerTypes = this.allowedTypes(Attachment.class);
                break;
            }
            case BOOLEAN: {
                allowedAnswerTypes = this.allowedTypes(BooleanType.class);
                break;
            }
            case CHOICE: {
                allowedAnswerTypes = this.allowedTypes(Coding.class);
                break;
            }
            case DATE: {
                allowedAnswerTypes = this.allowedTypes(DateType.class);
                break;
            }
            case DATETIME: {
                allowedAnswerTypes = this.allowedTypes(DateTimeType.class);
                break;
            }
            case DECIMAL: {
                allowedAnswerTypes = this.allowedTypes(DecimalType.class);
                break;
            }
            case INSTANT: {
                allowedAnswerTypes = this.allowedTypes(InstantType.class);
                break;
            }
            case INTEGER: {
                allowedAnswerTypes = this.allowedTypes(IntegerType.class);
                break;
            }
            case OPENCHOICE: {
                allowedAnswerTypes = this.allowedTypes(Coding.class);
                break;
            }
            case QUANTITY: {
                allowedAnswerTypes = this.allowedTypes(Quantity.class);
                break;
            }
            case REFERENCE: {
                allowedAnswerTypes = this.allowedTypes(Reference.class);
                break;
            }
            case STRING: {
                allowedAnswerTypes = this.allowedTypes(StringType.class);
                break;
            }
            case TEXT: {
                allowedAnswerTypes = this.allowedTypes(StringType.class);
                break;
            }
            case TIME: {
                allowedAnswerTypes = this.allowedTypes(TimeType.class);
                break;
            }
            case URL: {
                allowedAnswerTypes = this.allowedTypes(UriType.class);
                break;
            }
            default: {
                allowedAnswerTypes = Collections.emptySet();
            }
        }
        return allowedAnswerTypes;
    }

    private List<QuestionnaireResponse.QuestionComponent> findAnswersByLinkId(List<QuestionnaireResponse.QuestionComponent> theQuestion, String theLinkId) {
        Validate.notBlank((CharSequence)theLinkId, (String)"theLinkId must not be blank", (Object[])new Object[0]);
        ArrayList<QuestionnaireResponse.QuestionComponent> retVal = new ArrayList<QuestionnaireResponse.QuestionComponent>();
        for (QuestionnaireResponse.QuestionComponent next : theQuestion) {
            if (!theLinkId.equals(next.getLinkId())) continue;
            retVal.add(next);
        }
        return retVal;
    }

    private List<QuestionnaireResponse.GroupComponent> findGroupByLinkId(List<QuestionnaireResponse.GroupComponent> theGroups, String theLinkId) {
        Validate.notBlank((CharSequence)theLinkId, (String)"theLinkId must not be blank", (Object[])new Object[0]);
        ArrayList<QuestionnaireResponse.GroupComponent> retVal = new ArrayList<QuestionnaireResponse.GroupComponent>();
        for (QuestionnaireResponse.GroupComponent next : theGroups) {
            if (!theLinkId.equals(next.getLinkId())) continue;
            retVal.add(next);
        }
        return retVal;
    }

    private Questionnaire getQuestionnaire(QuestionnaireResponse theAnswers, Reference theQuestionnaireRef) {
        Questionnaire retVal;
        if (theQuestionnaireRef.getReferenceElement().isLocal()) {
            retVal = (Questionnaire)theQuestionnaireRef.getResource();
            if (retVal == null) {
                for (Resource next : theAnswers.getContained()) {
                    if (!theQuestionnaireRef.getReferenceElement().getValue().equals(next.getId())) continue;
                    retVal = (Questionnaire)next;
                }
            }
        } else {
            retVal = (Questionnaire)this.myWorkerCtx.fetchResource(Questionnaire.class, theQuestionnaireRef.getReferenceElement().getValue());
        }
        return retVal;
    }

    private ValueSet getValueSet(QuestionnaireResponse theAnswers, Reference theQuestionnaireRef) {
        ValueSet retVal;
        if (theQuestionnaireRef.getReferenceElement().isLocal()) {
            retVal = (ValueSet)theQuestionnaireRef.getResource();
            if (retVal == null) {
                for (Resource next : theAnswers.getContained()) {
                    if (!theQuestionnaireRef.getReferenceElement().getValue().equals(next.getId())) continue;
                    retVal = (ValueSet)next;
                }
            }
        } else {
            retVal = (ValueSet)this.myWorkerCtx.fetchResource(ValueSet.class, theQuestionnaireRef.getReferenceElement().getValue());
        }
        return retVal;
    }

    public void validate(List<ValidationMessage> theErrors, QuestionnaireResponse theAnswers) {
        LinkedList<String> pathStack = new LinkedList<String>();
        pathStack.add("QuestionnaireResponse");
        pathStack.add("questionnaire");
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, pathStack, theAnswers.hasQuestionnaire(), "QuestionnaireResponse does not specity which questionnaire it is providing answers to")) {
            return;
        }
        Reference questionnaireRef = theAnswers.getQuestionnaire();
        Questionnaire questionnaire = this.getQuestionnaire(theAnswers, questionnaireRef);
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, pathStack, questionnaire != null, "Questionnaire {0} is not found in the WorkerContext", theAnswers.getQuestionnaire().getReference())) {
            return;
        }
        QuestionnaireResponse.QuestionnaireResponseStatus status = theAnswers.getStatus();
        boolean validateRequired = false;
        if (status == QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED || status == QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED) {
            validateRequired = true;
        }
        pathStack.removeLast();
        pathStack.add("group(0)");
        this.validateGroup(theErrors, questionnaire.getGroup(), theAnswers.getGroup(), pathStack, theAnswers, validateRequired);
    }

    private void validateGroup(List<ValidationMessage> theErrors, Questionnaire.GroupComponent theQuestGroup, QuestionnaireResponse.GroupComponent theAnsGroup, LinkedList<String> thePathStack, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        int i;
        Questionnaire.QuestionComponent nextQuestion2;
        for (Object next : theAnsGroup.getQuestion()) {
            this.rule(theErrors, ValidationMessage.IssueType.INVALID, thePathStack, StringUtils.isNotBlank((CharSequence)next.getLinkId()), "Question found with no linkId");
        }
        HashSet<String> allowedQuestions = new HashSet<String>();
        for (Questionnaire.QuestionComponent nextQuestion2 : theQuestGroup.getQuestion()) {
            allowedQuestions.add(nextQuestion2.getLinkId());
        }
        for (i = 0; i < theQuestGroup.getQuestion().size(); ++i) {
            nextQuestion2 = (Questionnaire.QuestionComponent)theQuestGroup.getQuestion().get(i);
            this.validateQuestion(theErrors, nextQuestion2, theAnsGroup, thePathStack, theAnswers, theValidateRequired);
        }
        for (i = 0; i < theAnsGroup.getQuestion().size(); ++i) {
            nextQuestion2 = (QuestionnaireResponse.QuestionComponent)theAnsGroup.getQuestion().get(i);
            thePathStack.add("question(" + i + ")");
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, allowedQuestions.contains(nextQuestion2.getLinkId()), "Found answer with linkId[{0}] but this ID is not allowed at this position", nextQuestion2.getLinkId());
            thePathStack.remove();
        }
        this.validateGroupGroups(theErrors, theQuestGroup, theAnsGroup, thePathStack, theAnswers, theValidateRequired);
    }

    private void validateGroupGroups(List<ValidationMessage> theErrors, Questionnaire.GroupComponent theQuestGroup, QuestionnaireResponse.GroupComponent theAnsGroup, LinkedList<String> thePathSpec, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        this.validateGroups(theErrors, theQuestGroup.getGroup(), theAnsGroup.getGroup(), thePathSpec, theAnswers, theValidateRequired);
    }

    private void validateGroups(List<ValidationMessage> theErrors, List<Questionnaire.GroupComponent> theQuestionGroups, List<QuestionnaireResponse.GroupComponent> theAnswerGroups, LinkedList<String> thePathStack, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        HashSet<String> allowedGroups = new HashSet<String>();
        for (Questionnaire.GroupComponent nextQuestionGroup : theQuestionGroups) {
            String linkId = nextQuestionGroup.getLinkId();
            allowedGroups.add(linkId);
            List<QuestionnaireResponse.GroupComponent> answerGroups = this.findGroupByLinkId(theAnswerGroups, linkId);
            if (answerGroups.isEmpty()) {
                if (!nextQuestionGroup.getRequired()) continue;
                if (theValidateRequired) {
                    this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Missing required group with linkId[{0}]", linkId);
                    continue;
                }
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Missing required group with linkId[{0}]", linkId);
                continue;
            }
            if (answerGroups.size() > 1 && !nextQuestionGroup.getRepeats()) {
                int index = theAnswerGroups.indexOf(answerGroups.get(1));
                thePathStack.add("group(" + index + ")");
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Multiple repetitions of group with linkId[{0}] found at this position, but this group can not repeat", linkId);
                thePathStack.removeLast();
            }
            for (QuestionnaireResponse.GroupComponent nextAnswerGroup : answerGroups) {
                int index = theAnswerGroups.indexOf(nextAnswerGroup);
                thePathStack.add("group(" + index + ")");
                this.validateGroup(theErrors, nextQuestionGroup, nextAnswerGroup, thePathStack, theAnswers, theValidateRequired);
                thePathStack.removeLast();
            }
        }
        int idx = -1;
        for (QuestionnaireResponse.GroupComponent next : theAnswerGroups) {
            ++idx;
            if (allowedGroups.contains(next.getLinkId())) continue;
            thePathStack.add("group(" + idx + ")");
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Group with linkId[{0}] found at this position, but this group does not exist at this position in Questionnaire", next.getLinkId());
            thePathStack.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateQuestion(List<ValidationMessage> theErrors, Questionnaire.QuestionComponent theQuestion, QuestionnaireResponse.GroupComponent theAnsGroup, LinkedList<String> thePathStack, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        List<QuestionnaireResponse.QuestionComponent> answers;
        String linkId = theQuestion.getLinkId();
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, thePathStack, StringUtils.isNotBlank((CharSequence)linkId), "Questionnaire is invalid, question found with no link ID")) {
            return;
        }
        Questionnaire.AnswerFormat type = theQuestion.getType();
        if (type == null) {
            if (theQuestion.getGroup().isEmpty()) {
                this.rule(theErrors, ValidationMessage.IssueType.INVALID, thePathStack, false, "Questionnaire in invalid, no type and no groups specified for question with link ID[{0}]", linkId);
                return;
            }
            type = Questionnaire.AnswerFormat.NULL;
        }
        if ((answers = this.findAnswersByLinkId(theAnsGroup.getQuestion(), linkId)).size() > 1) {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired(), "Multiple answers repetitions found with linkId[{0}]", linkId);
        }
        if (answers.size() == 0) {
            if (theValidateRequired) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired(), "Missing answer to required question with linkId[{0}]", linkId);
            } else {
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired(), "Missing answer to required question with linkId[{0}]", linkId);
            }
            return;
        }
        QuestionnaireResponse.QuestionComponent answerQuestion = answers.get(0);
        try {
            thePathStack.add("question(" + answers.indexOf(answerQuestion) + ")");
            this.validateQuestionAnswers(theErrors, theQuestion, thePathStack, type, answerQuestion, theAnswers, theValidateRequired);
        }
        finally {
            thePathStack.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateQuestionAnswers(List<ValidationMessage> theErrors, Questionnaire.QuestionComponent theQuestion, LinkedList<String> thePathStack, Questionnaire.AnswerFormat type, QuestionnaireResponse.QuestionComponent answerQuestion, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        String linkId = theQuestion.getLinkId();
        Set<Class<? extends Type>> allowedAnswerTypes = this.determineAllowedAnswerTypes(type);
        if (allowedAnswerTypes.isEmpty()) {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, answerQuestion.isEmpty(), "Question with linkId[{0}] has no answer type but an answer was provided", linkId);
        } else {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, answerQuestion.getAnswer().size() <= 1 || theQuestion.getRepeats(), "Multiple answers to non repeating question with linkId[{0}]", linkId);
            if (theValidateRequired) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired() || !answerQuestion.getAnswer().isEmpty(), "Missing answer to required question with linkId[{0}]", linkId);
            } else {
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired() || !answerQuestion.getAnswer().isEmpty(), "Missing answer to required question with linkId[{0}]", linkId);
            }
        }
        int answerIdx = -1;
        for (QuestionnaireResponse.QuestionAnswerComponent nextAnswer : answerQuestion.getAnswer()) {
            ++answerIdx;
            try {
                thePathStack.add("answer(" + answerIdx + ")");
                Type nextValue = nextAnswer.getValue();
                if (!allowedAnswerTypes.contains(nextValue.getClass())) {
                    this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] found of type [{1}] but this is invalid for question of type [{2}]", linkId, nextValue.getClass().getSimpleName(), type.toCode());
                    continue;
                }
                if (type == Questionnaire.AnswerFormat.CHOICE || type == Questionnaire.AnswerFormat.OPENCHOICE) {
                    String optionsRef;
                    Coding coding = (Coding)nextAnswer.getValue();
                    if (StringUtils.isBlank((CharSequence)coding.getCode()) && StringUtils.isBlank((CharSequence)coding.getSystem()) && StringUtils.isBlank((CharSequence)coding.getSystem())) {
                        this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] is of type coding, but none of code, system, and display are populated", linkId);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)coding.getCode()) && StringUtils.isBlank((CharSequence)coding.getSystem())) {
                        if (type != Questionnaire.AnswerFormat.OPENCHOICE) {
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] is of type only has a display populated (no code or system) but question does not allow {1}", linkId, Questionnaire.AnswerFormat.OPENCHOICE.name());
                            continue;
                        }
                    } else if (StringUtils.isBlank((CharSequence)coding.getCode()) || StringUtils.isBlank((CharSequence)coding.getSystem())) {
                        this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] has a coding, but this coding does not contain a code and system (both must be present, or neither is the question allows {1})", linkId, Questionnaire.AnswerFormat.OPENCHOICE.name());
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)(optionsRef = theQuestion.getOptions().getReference()))) {
                        ValueSet valueSet = this.getValueSet(theAnswers, theQuestion.getOptions());
                        if (valueSet == null) {
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Question with linkId[{0}] has options ValueSet[{1}] but this ValueSet can not be found", linkId, optionsRef);
                            continue;
                        }
                        boolean found = false;
                        if (coding.getSystem().equals(valueSet.getCodeSystem().getSystem())) {
                            for (ValueSet.ConceptDefinitionComponent next : valueSet.getCodeSystem().getConcept()) {
                                if (!coding.getCode().equals(next.getCode())) continue;
                                found = true;
                                break;
                            }
                        }
                        this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, found, "Question with linkId[{0}] has answer with system[{1}] and code[{2}] but this is not a valid answer for ValueSet[{3}]", linkId, coding.getSystem(), coding.getCode(), optionsRef);
                    }
                }
                this.validateQuestionGroups(theErrors, theQuestion, nextAnswer, thePathStack, theAnswers, theValidateRequired);
            }
            finally {
                thePathStack.removeLast();
            }
        }
    }

    private void validateQuestionGroups(List<ValidationMessage> theErrors, Questionnaire.QuestionComponent theQuestion, QuestionnaireResponse.QuestionAnswerComponent theAnswer, LinkedList<String> thePathSpec, QuestionnaireResponse theAnswers, boolean theValidateRequired) {
        this.validateGroups(theErrors, theQuestion.getGroup(), theAnswer.getGroup(), thePathSpec, theAnswers, theValidateRequired);
    }
}

