/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.ElementDefinition;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.utils.FHIRPathEngine;
import org.hl7.fhir.instance.utils.IWorkerContext;
import org.hl7.fhir.instance.utils.ToolingExtensions;
import org.hl7.fhir.instance.validation.BaseValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ProfileValidator
extends BaseValidator {
    IWorkerContext context;

    public void setContext(IWorkerContext context) {
        this.context = context;
    }

    @Override
    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean b, String msg) {
        String rn = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        return super.rule(errors, type, path, b, msg, "<a href=\"" + rn.toLowerCase() + ".html\">" + rn + "</a>: " + Utilities.escapeXml((String)msg));
    }

    public List<ValidationMessage> validate(StructureDefinition profile, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        for (ElementDefinition ec : profile.getDifferential().getElement()) {
            this.checkExtensions(profile, errors, "differential", ec);
        }
        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "missing Snapshot at " + profile.getName() + "." + profile.getName());
        for (ElementDefinition ec : profile.getSnapshot().getElement()) {
            this.checkExtensions(profile, errors, "snapshot", ec);
        }
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "A snapshot is required")) {
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                this.checkExtensions(profile, errors, "snapshot", ed);
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!forBuild) continue;
                    Extension exprExt = ToolingExtensions.getExtension((Element)inv, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression");
                    if (this.inExemptList(inv.getKey()) || !this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId() + "::" + ed.getPath() + "::" + inv.getKey(), exprExt != null, "The invariant has no FHIR Path expression (" + inv.getXpath() + ")")) continue;
                    String expr = ((StringType)exprExt.getValue()).asStringValue();
                    try {
                        new FHIRPathEngine(this.context).check(null, profile.getConstrainedType(), ed.getPath(), expr);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return errors;
    }

    private boolean inExemptList(String key) {
        return key.startsWith("txt-");
    }

    private void checkExtensions(StructureDefinition profile, List<ValidationMessage> errors, String kind, ElementDefinition ec) {
        if (!ec.getType().isEmpty() && "Extension".equals(((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getCode()) && ((ElementDefinition.TypeRefComponent)ec.getType().get(0)).hasProfile()) {
            String url = (String)((UriType)((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getProfile().get(0)).getValue();
            StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), defn != null, "Unable to find Extension '" + url + "' referenced at " + profile.getUrl() + " " + kind + " " + ec.getPath() + " (" + ec.getName() + ")");
        }
    }
}

