/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.ElementDefinition;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.Timing;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.FHIRPathEngine;
import org.hl7.fhir.instance.utils.IResourceValidator;
import org.hl7.fhir.instance.utils.IWorkerContext;
import org.hl7.fhir.instance.utils.ProfileUtilities;
import org.hl7.fhir.instance.validation.BaseValidator;
import org.hl7.fhir.instance.validation.XmlLocationData;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private boolean anyExtensionsAllowed;
    private IResourceValidator.BestPracticeWarningLevel bpWarnings;
    private IResourceValidator.CheckDisplayOption checkDisplay;
    private IWorkerContext context;
    private List<String> extensionDomains = new ArrayList<String>();
    private IResourceValidator.IdStatus resourceIdRule;
    private boolean suppressLoincSnomedMessages;

    public InstanceValidator(IWorkerContext theContext) {
        this.context = theContext;
        this.source = ValidationMessage.Source.InstanceValidator;
    }

    private boolean allowUnknownExtension(String url) {
        if (url.contains("example.org") || url.contains("acme.com") || url.contains("nema.org")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private void bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Warning: {
                    this.warning(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Hint: {
                    this.hint(errors, invalid, line, col, literalPath, test, message);
                    break;
                }
            }
        }
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString((String)v1) : v1.equals(v2);
    }

    private void checkAddress(List<ValidationMessage> errors, String path, WrapperElement focus, Address fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.instance.model.Element)fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.instance.model.Element)fixed.getTextElement(), "text");
        this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city"), (org.hl7.fhir.instance.model.Element)fixed.getCityElement(), "city");
        this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state"), (org.hl7.fhir.instance.model.Element)fixed.getStateElement(), "state");
        this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country"), (org.hl7.fhir.instance.model.Element)fixed.getCountryElement(), "country");
        this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip"), (org.hl7.fhir.instance.model.Element)fixed.getPostalCodeElement(), "postalCode");
        ArrayList<WrapperElement> lines = new ArrayList<WrapperElement>();
        focus.getNamedChildren("line", lines);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lines.size() == fixed.getLine().size(), "Expected " + Integer.toString(fixed.getLine().size()) + " but found " + Integer.toString(lines.size()) + " line elements", new Object[0])) {
            for (int i = 0; i < lines.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (WrapperElement)lines.get(i), (org.hl7.fhir.instance.model.Element)fixed.getLine().get(i), "coding");
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, WrapperElement focus, Attachment fixed) {
        this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType"), (org.hl7.fhir.instance.model.Element)fixed.getContentTypeElement(), "contentType");
        this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language"), (org.hl7.fhir.instance.model.Element)fixed.getLanguageElement(), "language");
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.instance.model.Element)fixed.getDataElement(), "data");
        this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url"), (org.hl7.fhir.instance.model.Element)fixed.getUrlElement(), "url");
        this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size"), (org.hl7.fhir.instance.model.Element)fixed.getSizeElement(), "size");
        this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash"), (org.hl7.fhir.instance.model.Element)fixed.getHashElement(), "hash");
        this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title"), (org.hl7.fhir.instance.model.Element)fixed.getTitleElement(), "title");
    }

    private boolean checkCode(List<ValidationMessage> errors, WrapperElement element, String path, String code, String system, String display) {
        if (this.context.supportsSystem(system)) {
            IWorkerContext.ValidationResult s = this.context.validateCode(system, code, display);
            if (s == null || s.isOk()) {
                return true;
            }
            if (s.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage());
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else {
                return this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            }
            return true;
        }
        if (system.startsWith("http://hl7.org/fhir")) {
            if (system.equals("http://hl7.org/fhir/sid/icd-10")) {
                return true;
            }
            ValueSet vs = this.getValueSet(system);
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "Unknown Code System " + system, new Object[0])) {
                ValueSet.ConceptDefinitionComponent def = this.getCodeDefinition(vs, code);
                if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "Unknown Code (" + system + "#" + code + ")", new Object[0])) {
                    return this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Display should be '" + def.getDisplay() + "'", new Object[0]);
                }
            }
            return false;
        }
        if (system.startsWith("http://loinc.org")) {
            return true;
        }
        if (system.startsWith("http://unitsofmeasure.org")) {
            return true;
        }
        return true;
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, WrapperElement focus, CodeableConcept fixed) {
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.instance.model.Element)fixed.getTextElement(), "text");
        ArrayList<WrapperElement> codings = new ArrayList<WrapperElement>();
        focus.getNamedChildren("coding", codings);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Expected " + Integer.toString(fixed.getCoding().size()) + " but found " + Integer.toString(codings.size()) + " coding elements", new Object[0])) {
            for (int i = 0; i < codings.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (WrapperElement)codings.get(i), (org.hl7.fhir.instance.model.Element)fixed.getCoding().get(i), "coding");
            }
        }
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, WrapperElement element, StructureDefinition profile, ElementDefinition theElementCntext) {
        if (theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing (cc)", new Object[0])) {
                if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
                    ValueSet valueset = this.resolveBindingReference(binding.getValueSet());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found", new Object[0])) {
                        try {
                            CodeableConcept cc = this.readAsCodeableConcept(element);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code is required from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code should be provided from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                }
                            } else {
                                IWorkerContext.ValidationResult vr = this.context.validateCode(cc, valueset);
                                if (!vr.isOk()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code from this value set is required", new Object[0]);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code)", new Object[0]);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set)");
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept", new Object[0]);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                } else {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                }
            }
        }
    }

    private void checkCoding(List<ValidationMessage> errors, String path, WrapperElement focus, Coding fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.instance.model.Element)fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.instance.model.Element)fixed.getCodeElement(), "code");
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), (org.hl7.fhir.instance.model.Element)fixed.getDisplayElement(), "display");
        this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected"), (org.hl7.fhir.instance.model.Element)fixed.getUserSelectedElement(), "userSelected");
    }

    private void checkCoding(List<ValidationMessage> errors, String path, WrapperElement element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept) {
        String code = element.getNamedChildValue("code");
        String system = element.getNamedChildValue("system");
        String display = element.getNamedChildValue("display");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Coding.system must be an absolute reference, not a local reference", new Object[0]);
        if (system != null && code != null && this.checkCode(errors, element, path, code, system, display) && theElementCntext != null && theElementCntext.getBinding() != null) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing", new Object[0])) {
                if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
                    ValueSet valueset = this.resolveBindingReference(binding.getValueSet());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found", new Object[0])) {
                        try {
                            Coding c = this.readAsCoding(element);
                            IWorkerContext.ValidationResult vr = this.context.validateCode(c, valueset);
                            if (!vr.isOk()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is required from this value set)", new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code)", new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set)");
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept", new Object[0]);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                } else if (!inCodeableConcept) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                }
            }
        }
    }

    private void checkContactPoint(List<ValidationMessage> errors, String path, WrapperElement focus, ContactPoint fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.instance.model.Element)fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.instance.model.Element)fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.instance.model.Element)fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.instance.model.Element)fixed.getPeriod(), "period");
    }

    private void checkDeclaredProfiles(List<ValidationMessage> errors, WrapperElement resource, WrapperElement element, NodeStack stack) throws FHIRException {
        WrapperElement meta = element.getNamedChild("meta");
        if (meta != null) {
            ArrayList<WrapperElement> profiles = new ArrayList<WrapperElement>();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (WrapperElement profile : profiles) {
                String ref = profile.getAttribute("value");
                String p = stack.addToLiteralPath("meta", "profile", ":" + Integer.toString(i));
                if (!this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), p, !Utilities.noString((String)ref), "StructureDefinition reference invalid", new Object[0])) continue;
                StructureDefinition pr = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ref);
                if (this.warning(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), p, pr != null, "StructureDefinition reference \"{0}\" could not be resolved", ref) && this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), p, pr.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0])) {
                    this.validateElement(errors, pr, (ElementDefinition)pr.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false);
                }
                ++i;
            }
        }
    }

    private StructureDefinition checkExtension(List<ValidationMessage> errors, String path, WrapperElement element, ElementDefinition def, StructureDefinition profile, NodeStack stack) {
        String url = element.getAttribute("url");
        boolean isModifier = element.getName().equals("modifierExtension");
        StructureDefinition ex = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        if (ex == null) {
            if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "The extension " + url + " is unknown, and not allowed here", new Object[0])) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "Unknown extension " + url, new Object[0]);
            }
        } else {
            if (def.getIsModifier()) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension modifier mismatch: the extension element is labelled as a modifier, but the underlying extension is not", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension modifier mismatch: the extension element is not labelled as a modifier, but the underlying extension is", new Object[0]);
            }
            this.checkExtensionContext(errors, element, ex, stack, ex.getUrl());
            if (isModifier) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "The Extension '" + url + "' must be used as a modifierExtension", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "The Extension '" + url + "' must not be used as an extension (it's a modifierExtension)", new Object[0]);
            }
        }
        return ex;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, WrapperElement element, StructureDefinition definition, NodeStack stack, String extensionParent) {
        Object b;
        String extUrl = definition.getUrl();
        CommaSeparatedStringBuilder p = new CommaSeparatedStringBuilder();
        for (String lp : stack.getLogicalPaths()) {
            p.append(lp);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.DATATYPE) {
            boolean ok = false;
            b = new CommaSeparatedStringBuilder();
            for (StringType ct : definition.getContext()) {
                b.append((String)ct.getValue());
                if (!((String)ct.getValue()).equals("*") && !stack.getLogicalPaths().contains((String)ct.getValue() + ".extension")) continue;
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used on the logical path set [" + p.toString() + "] (allowed: datatype=" + b.toString() + ")", new Object[0]);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.EXTENSION) {
            boolean ok = false;
            for (StringType ct : definition.getContext()) {
                if (!((String)ct.getValue()).equals("*") && !((String)ct.getValue()).equals(extensionParent)) continue;
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used with the extension '" + extensionParent + "'", new Object[0]);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.MAPPING) {
            throw new Error("Not handled yet (extensionContext)");
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.RESOURCE) {
            boolean ok = false;
            b = new CommaSeparatedStringBuilder();
            for (StringType ct : definition.getContext()) {
                String c = (String)ct.getValue();
                b.append(c);
                if (c.equals("*") || stack.getLogicalPaths().contains(c + ".extension") || !c.startsWith("@") || stack.getLogicalPaths().contains(c.substring(1) + ".extension")) {
                    // empty if block
                }
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used on the logical path set " + p.toString() + " (allowed: resource=" + b.toString() + ")", new Object[0]);
        }
        throw new Error("Unknown context type");
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, WrapperElement focus, org.hl7.fhir.instance.model.Element fixed, String propName) {
        if (fixed != null || focus != null) {
            if (fixed == null && focus != null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "Unexpected element " + focus.getName(), new Object[0]);
            } else if (fixed != null && focus == null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "Mising element " + propName, new Object[0]);
            } else {
                String value = focus.getAttribute("value");
                if (fixed instanceof BooleanType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((BooleanType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof IntegerType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((IntegerType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof DecimalType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((DecimalType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof Base64BinaryType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((Base64BinaryType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof InstantType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((InstantType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof StringType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((StringType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UriType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UriType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateTimeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateTimeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof OidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((OidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UuidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UuidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof CodeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((CodeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof IdType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + ((IdType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof Quantity) {
                    this.checkQuantity(errors, path, focus, (Quantity)fixed);
                } else if (fixed instanceof Address) {
                    this.checkAddress(errors, path, focus, (Address)fixed);
                } else if (fixed instanceof ContactPoint) {
                    this.checkContactPoint(errors, path, focus, (ContactPoint)fixed);
                } else if (fixed instanceof Attachment) {
                    this.checkAttachment(errors, path, focus, (Attachment)fixed);
                } else if (fixed instanceof Identifier) {
                    this.checkIdentifier(errors, path, focus, (Identifier)fixed);
                } else if (fixed instanceof Coding) {
                    this.checkCoding(errors, path, focus, (Coding)fixed);
                } else if (fixed instanceof HumanName) {
                    this.checkHumanName(errors, path, focus, (HumanName)fixed);
                } else if (fixed instanceof CodeableConcept) {
                    this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed);
                } else if (fixed instanceof Timing) {
                    this.checkTiming(errors, path, focus, (Timing)fixed);
                } else if (fixed instanceof Period) {
                    this.checkPeriod(errors, path, focus, (Period)fixed);
                } else if (fixed instanceof Range) {
                    this.checkRange(errors, path, focus, (Range)fixed);
                } else if (fixed instanceof Ratio) {
                    this.checkRatio(errors, path, focus, (Ratio)fixed);
                } else if (fixed instanceof SampledData) {
                    this.checkSampledData(errors, path, focus, (SampledData)fixed);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Unhandled fixed value type " + fixed.getClass().getName(), new Object[0]);
                }
                ArrayList<WrapperElement> extensions = new ArrayList<WrapperElement>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0, "No extensions allowed", new Object[0]);
                } else if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extensions count mismatch: expected " + Integer.toString(fixed.getExtension().size()) + " but found " + Integer.toString(extensions.size()), new Object[0])) {
                    for (Extension e : fixed.getExtension()) {
                        WrapperElement ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension count mismatch: unable to find extension: " + e.getUrl(), new Object[0])) continue;
                        this.checkFixedValue(errors, path, ex.getFirstChild().getNextSibling(), (org.hl7.fhir.instance.model.Element)e.getValue(), "extension.value");
                    }
                }
            }
        }
    }

    private void checkForProcessingInstruction(List<ValidationMessage> errors, Document document) {
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, "(document)", node.getNodeType() != 7, "No processing instructions allowed in resources", new Object[0]);
        }
    }

    private void checkHumanName(List<ValidationMessage> errors, String path, WrapperElement focus, HumanName fixed) {
        int i;
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.instance.model.Element)fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), (org.hl7.fhir.instance.model.Element)fixed.getTextElement(), "text");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.instance.model.Element)fixed.getPeriod(), "period");
        ArrayList<WrapperElement> parts = new ArrayList<WrapperElement>();
        focus.getNamedChildren("family", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getFamily().size(), "Expected " + Integer.toString(fixed.getFamily().size()) + " but found " + Integer.toString(parts.size()) + " family elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".family", (WrapperElement)parts.get(i), (org.hl7.fhir.instance.model.Element)fixed.getFamily().get(i), "family");
            }
        }
        focus.getNamedChildren("given", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Expected " + Integer.toString(fixed.getGiven().size()) + " but found " + Integer.toString(parts.size()) + " given elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".given", (WrapperElement)parts.get(i), (org.hl7.fhir.instance.model.Element)fixed.getGiven().get(i), "given");
            }
        }
        focus.getNamedChildren("prefix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Expected " + Integer.toString(fixed.getPrefix().size()) + " but found " + Integer.toString(parts.size()) + " prefix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".prefix", (WrapperElement)parts.get(i), (org.hl7.fhir.instance.model.Element)fixed.getPrefix().get(i), "prefix");
            }
        }
        focus.getNamedChildren("suffix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Expected " + Integer.toString(fixed.getSuffix().size()) + " but found " + Integer.toString(parts.size()) + " suffix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".suffix", (WrapperElement)parts.get(i), (org.hl7.fhir.instance.model.Element)fixed.getSuffix().get(i), "suffix");
            }
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, WrapperElement element, ElementDefinition context) {
        String system = element.getNamedChildValue("system");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Identifier.system must be an absolute reference, not a local reference", new Object[0]);
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, WrapperElement focus, Identifier fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), (org.hl7.fhir.instance.model.Element)fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), (org.hl7.fhir.instance.model.Element)fixed.getType(), "type");
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.instance.model.Element)fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.instance.model.Element)fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.instance.model.Element)fixed.getPeriod(), "period");
        this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner"), (org.hl7.fhir.instance.model.Element)fixed.getAssigner(), "assigner");
    }

    private void checkInvariants(List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, WrapperElement resource, WrapperElement element) throws FHIRException {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            if (!inv.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) continue;
            ResourceOnWrapper res = new ResourceOnWrapper(this.context, resource, resource.getProfile());
            BaseOnWrapper e = new BaseOnWrapper(this.context, element, profile, ed, typename, typeProfile);
            String expr = inv.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression");
            FHIRPathEngine fpe = new FHIRPathEngine(this.context);
            boolean ok = true;
            try {
                ok = fpe.evaluateToBoolean((Resource)res, (Base)e, expr);
            }
            catch (PathEngineException e1) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, false, e1.getMessage() + ": " + inv.getHuman() + fpe.forLog(), new Object[0]);
            }
            if (ok) continue;
            if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getHuman() + fpe.forLog(), new Object[0]);
                continue;
            }
            if (inv.getSeverity() != ElementDefinition.ConstraintSeverity.WARNING) continue;
            this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.line(), path, ok, inv.getHuman() + fpe.forLog(), new Object[0]);
        }
    }

    private void checkPeriod(List<ValidationMessage> errors, String path, WrapperElement focus, Period fixed) {
        this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start"), (org.hl7.fhir.instance.model.Element)fixed.getStartElement(), "start");
        this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end"), (org.hl7.fhir.instance.model.Element)fixed.getEndElement(), "end");
    }

    private void checkPrimitive(List<ValidationMessage> errors, String path, String type, ElementDefinition context, WrapperElement e) {
        if (type.equals("uri")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.getAttribute("value").startsWith("oid:"), "URI values cannot start with oid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.getAttribute("value").startsWith("uuid:"), "URI values cannot start with uuid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.getAttribute("value").equals(e.getAttribute("value").trim()), "URI values cannot have leading or trailing whitespace", new Object[0]);
        }
        if (!type.equalsIgnoreCase("string") && e.hasAttribute("value") && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.getAttribute("value").length() > 0, "@value cannot be empty", new Object[0])) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.getAttribute("value").trim().equals(e.getAttribute("value")), "value should not start or finish with whitespace", new Object[0]);
        }
        if (type.equals("dateTime")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.getAttribute("value")), "The value '" + e.getAttribute("value") + "' does not have a valid year", new Object[0]);
            boolean ok = e.getAttribute("value").matches("-?[0-9]{4}(-(0[1-9]|1[0-2])(-(0[0-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?)?)?");
            if (!ok) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ok, "'" + e.getAttribute("value") + "' is not a valid date time", new Object[0]);
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.getAttribute("value")) || this.hasTimeZone(e.getAttribute("value")), "if a date has a time, it must have a timezone", new Object[0]);
        }
        if (type.equals("instant")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.getAttribute("value").matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[0-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "The instant '" + e.getAttribute("value") + "' is not valid (by regex)", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.getAttribute("value")), "The value '" + e.getAttribute("value") + "' does not have a valid year", new Object[0]);
        }
        if (type.equals("code")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.getAttribute("value")), "The code '" + e.getAttribute("value") + "' is not valid (whitespace rules)", new Object[0]);
        }
        if (context.hasBinding()) {
            this.checkPrimitiveBinding(errors, path, type, context, e);
        }
    }

    private void checkPrimitiveBinding(List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, WrapperElement element) {
        if (!element.hasAttribute("value")) {
            return;
        }
        String value = element.getAttribute("value");
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
            IWorkerContext.ValidationResult vr;
            ValueSet vs = this.resolveBindingReference(binding.getValueSet());
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "ValueSet {0} not found", this.describeReference(binding.getValueSet())) && !(vr = this.context.validateCode(null, value, null, vs)).isOk()) {
                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is required from this value set)", new Object[0]);
                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code should come from this value set unless it has no suitable code)", new Object[0]);
                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is recommended to come from this value set)");
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding has no source, so can't be checked");
        }
    }

    private void checkQuantity(List<ValidationMessage> errors, String path, WrapperElement focus, Quantity fixed) {
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), (org.hl7.fhir.instance.model.Element)fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator"), (org.hl7.fhir.instance.model.Element)fixed.getComparatorElement(), "comparator");
        this.checkFixedValue(errors, path + ".units", focus.getNamedChild("unit"), (org.hl7.fhir.instance.model.Element)fixed.getUnitElement(), "units");
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), (org.hl7.fhir.instance.model.Element)fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), (org.hl7.fhir.instance.model.Element)fixed.getCodeElement(), "code");
    }

    private void checkRange(List<ValidationMessage> errors, String path, WrapperElement focus, Range fixed) {
        this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low"), (org.hl7.fhir.instance.model.Element)fixed.getLow(), "low");
        this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high"), (org.hl7.fhir.instance.model.Element)fixed.getHigh(), "high");
    }

    private void checkRatio(List<ValidationMessage> errors, String path, WrapperElement focus, Ratio fixed) {
        this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator"), (org.hl7.fhir.instance.model.Element)fixed.getNumerator(), "numerator");
        this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator"), (org.hl7.fhir.instance.model.Element)fixed.getDenominator(), "denominator");
    }

    private void checkReference(List<ValidationMessage> errors, String path, WrapperElement element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack) {
        String ref = element.getNamedChildValue("reference");
        if (Utilities.noString((String)ref)) {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString((String)element.getNamedChildValue("display")), "A Reference without an actual reference should have a display");
            return;
        }
        WrapperElement we = this.resolve(ref, stack);
        String ft = we != null ? we.getResourceType() : this.tryParse(ref);
        if (this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Unable to determine type of target resource")) {
            boolean ok = false;
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent type : container.getType()) {
                if (!ok && type.getCode().equals("Reference")) {
                    if (!type.hasProfile() || ((String)((UriType)type.getProfile().get(0)).getValue()).equals("http://hl7.org/fhir/StructureDefinition/Resource")) {
                        ok = true;
                    } else {
                        String pr = (String)((UriType)type.getProfile().get(0)).getValue();
                        String bt = this.getBaseType(profile, pr);
                        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, bt != null, "Unable to resolve the profile reference '" + pr + "'", new Object[0])) {
                            b.append(bt);
                            ok = bt.equals(ft);
                        } else {
                            ok = true;
                        }
                    }
                }
                if (ok || !type.getCode().equals("*")) continue;
                ok = true;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Invalid Resource target type. Found " + ft + ", but expected one of (" + b.toString() + ")", new Object[0]);
        }
    }

    private String checkResourceType(String type) {
        if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
            return type;
        }
        return null;
    }

    private void checkSampledData(List<ValidationMessage> errors, String path, WrapperElement focus, SampledData fixed) {
        this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin"), (org.hl7.fhir.instance.model.Element)fixed.getOrigin(), "origin");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), (org.hl7.fhir.instance.model.Element)fixed.getPeriodElement(), "period");
        this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor"), (org.hl7.fhir.instance.model.Element)fixed.getFactorElement(), "factor");
        this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit"), (org.hl7.fhir.instance.model.Element)fixed.getLowerLimitElement(), "lowerLimit");
        this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit"), (org.hl7.fhir.instance.model.Element)fixed.getUpperLimitElement(), "upperLimit");
        this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions"), (org.hl7.fhir.instance.model.Element)fixed.getDimensionsElement(), "dimensions");
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), (org.hl7.fhir.instance.model.Element)fixed.getDataElement(), "data");
    }

    private void checkTiming(List<ValidationMessage> errors, String path, WrapperElement focus, Timing fixed) {
        this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat"), (org.hl7.fhir.instance.model.Element)fixed.getRepeat(), "value");
        ArrayList<WrapperElement> events = new ArrayList<WrapperElement>();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Expected " + Integer.toString(fixed.getEvent().size()) + " but found " + Integer.toString(events.size()) + " event elements", new Object[0])) {
            for (int i = 0; i < events.size(); ++i) {
                this.checkFixedValue(errors, path + ".event", (WrapperElement)events.get(i), (org.hl7.fhir.instance.model.Element)fixed.getEvent().get(i), "event");
            }
        }
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(Type reference) {
        if (reference == null) {
            return "null";
        }
        if (reference instanceof UriType) {
            return (String)((UriType)reference).getValue();
        }
        if (reference instanceof Reference) {
            return ((Reference)reference).getReference();
        }
        return "??";
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getCode());
        }
        return b.toString();
    }

    private boolean empty(WrapperElement element) {
        if (element.hasAttribute("value")) {
            return false;
        }
        if (element.hasAttribute("xml:id")) {
            return false;
        }
        for (WrapperElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.isXml() && !"http://hl7.org/fhir".equals(child.getNamespace())) continue;
            return false;
        }
        return true;
    }

    private ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    private String genFullUrl(String bundleBase, String entryBase, String type, String id) {
        String base;
        String string = base = Utilities.noString((String)entryBase) ? bundleBase : entryBase;
        if (Utilities.noString((String)base)) {
            return type + "/" + id;
        }
        if ("urn:uuid".equals(base) || "urn:oid".equals(base)) {
            return base + id;
        }
        return Utilities.appendSlash((String)base) + type + "/" + id;
    }

    public IResourceValidator.BestPracticeWarningLevel getBasePracticeWarningLevel() {
        return this.bpWarnings;
    }

    private String getBaseType(StructureDefinition profile, String pr) {
        StructureDefinition p = this.resolveProfile(profile, pr);
        if (p == null) {
            return null;
        }
        if (p.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
            return ((ElementDefinition)p.getSnapshot().getElement().get(0)).getPath();
        }
        return ((ElementDefinition.TypeRefComponent)((ElementDefinition)p.getSnapshot().getElement().get(0)).getType().get(0)).getCode();
    }

    public IResourceValidator.CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    public void setCheckDisplay(IResourceValidator.CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    private ValueSet.ConceptDefinitionComponent getCodeDefinition(ValueSet.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (ValueSet.ConceptDefinitionComponent g : c.getConcept()) {
            ValueSet.ConceptDefinitionComponent r = this.getCodeDefinition(g, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private ValueSet.ConceptDefinitionComponent getCodeDefinition(ValueSet vs, String code) {
        for (ValueSet.ConceptDefinitionComponent c : vs.getCodeSystem().getConcept()) {
            ValueSet.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private WrapperElement getContainedById(WrapperElement container, String id) {
        ArrayList<WrapperElement> contained = new ArrayList<WrapperElement>();
        container.getNamedChildren("contained", contained);
        for (WrapperElement we : contained) {
            WrapperElement res = we.isXml() ? we.getFirstChild() : we;
            if (!id.equals(res.getNamedChildValue("id"))) continue;
            return res;
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private ElementDefinition getCriteriaForDiscriminator(String path, ElementDefinition ed, String discriminator, StructureDefinition profile) throws DefinitionException {
        List childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)profile, (ElementDefinition)ed);
        List snapshot = null;
        if (childDefinitions.isEmpty()) {
            StructureDefinition type;
            if (ed.getType().size() == 0) {
                throw new DefinitionException("Error in profile for " + path + " no children, no type");
            }
            if (ed.getType().size() > 1) {
                throw new DefinitionException("Error in profile for " + path + " multiple types defined in slice discriminator");
            }
            if (((ElementDefinition.TypeRefComponent)ed.getType().get(0)).hasProfile()) {
                if (((ElementDefinition.TypeRefComponent)ed.getType().get(0)).getCode().equals("Reference")) {
                    discriminator = discriminator.substring(discriminator.indexOf(".") + 1);
                }
                type = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)((UriType)((ElementDefinition.TypeRefComponent)ed.getType().get(0)).getProfile().get(0)).getValue());
            } else {
                type = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + ((ElementDefinition.TypeRefComponent)ed.getType().get(0)).getCode());
            }
            snapshot = type.getSnapshot().getElement();
            ed = (ElementDefinition)snapshot.get(0);
        } else {
            snapshot = profile.getSnapshot().getElement();
        }
        String originalPath = ed.getPath();
        String goal = originalPath + "." + discriminator;
        int index = snapshot.indexOf(ed);
        assert (index > -1);
        ++index;
        while (index < snapshot.size() && !((ElementDefinition)snapshot.get(index)).getPath().equals(originalPath)) {
            if (((ElementDefinition)snapshot.get(index)).getPath().equals(goal)) {
                return (ElementDefinition)snapshot.get(index);
            }
            ++index;
        }
        throw new Error("Unable to find discriminator definition for " + goal + " in " + discriminator + " at " + path);
    }

    private WrapperElement getExtensionByUrl(List<WrapperElement> extensions, String urlSimple) {
        for (WrapperElement e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url"))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    private WrapperElement getFirstEntry(WrapperElement bundle) {
        ArrayList<WrapperElement> list = new ArrayList<WrapperElement>();
        bundle.getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        WrapperElement resource = ((WrapperElement)list.get(0)).getNamedChild("resource");
        if (resource == null) {
            return null;
        }
        return resource.getFirstChild();
    }

    private WrapperElement getFromBundle(WrapperElement bundle, String ref) {
        ArrayList<WrapperElement> entries = new ArrayList<WrapperElement>();
        bundle.getNamedChildren("entry", entries);
        for (WrapperElement we : entries) {
            String url;
            WrapperElement res = we.getNamedChild("resource").getFirstChild();
            if (res == null || !(url = this.genFullUrl(bundle.getNamedChildValue("base"), we.getNamedChildValue("base"), res.getName(), res.getNamedChildValue("id"))).endsWith(ref)) continue;
            return res;
        }
        return null;
    }

    private StructureDefinition getProfileForType(String type) {
        return (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type);
    }

    public IResourceValidator.IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    public void setResourceIdRule(IResourceValidator.IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    private Element getValueForDiscriminator(WrapperElement element, String discriminator, ElementDefinition criteria) {
        return null;
    }

    private ValueSet getValueSet(String system) {
        return this.context.fetchCodeSystem(system);
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private IResourceValidator.IdStatus idStatusForEntry(WrapperElement ep, ElementInfo ei) {
        if (this.isBundleEntry(ei.path)) {
            WrapperElement req = ep.getNamedChild("request");
            WrapperElement resp = ep.getNamedChild("response");
            WrapperElement fullUrl = ep.getNamedChild("fullUrl");
            WrapperElement method = null;
            WrapperElement url = null;
            if (req != null) {
                method = req.getNamedChild("method");
                url = req.getNamedChild("url");
            }
            if (resp != null) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                if (fullUrl.getAttribute("value").startsWith("urn:uuid:")) {
                    return IResourceValidator.IdStatus.OPTIONAL;
                }
                return IResourceValidator.IdStatus.REQUIRED;
            }
            String s = method.getAttribute("value");
            if (s.equals("PUT")) {
                if (url == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (s.equals("POST")) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.path)) {
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        return this.getResourceIdRule();
    }

    private boolean isAbsolute(String uri) {
        return Utilities.noString((String)uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:uuid:") || uri.startsWith("urn:oid:") || uri.startsWith("urn:ietf:") || uri.startsWith("urn:iso:") || this.isValidFHIRUrn(uri);
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\/");
        if (path.startsWith("/f:")) {
            return parts.length > 2 && parts[parts.length - 1].startsWith("f:resource") && (parts[parts.length - 2].equals("f:entry") || parts[parts.length - 2].startsWith("f:entry["));
        }
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (parts.length > 2 && parts[parts.length - 3].equals("entry") || parts[parts.length - 2].equals("entry"));
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\/");
        if (path.startsWith("/f:")) {
            return parts.length == 4 && parts[parts.length - 3].equals("f:Parameters") && parts[parts.length - 2].startsWith("f:parameter") && parts[parts.length - 1].startsWith("f:resource");
        }
        return parts.length == 4 && parts[parts.length - 3].equals("Parameters") && parts[parts.length - 2].startsWith("parameter") && parts[parts.length - 1].startsWith("resource");
    }

    private boolean isPrimitiveType(String type) {
        return type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("string") || type.equalsIgnoreCase("decimal") || type.equalsIgnoreCase("uri") || type.equalsIgnoreCase("base64Binary") || type.equalsIgnoreCase("instant") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("uuid") || type.equalsIgnoreCase("id") || type.equalsIgnoreCase("xhtml") || type.equalsIgnoreCase("markdown") || type.equalsIgnoreCase("dateTime") || type.equalsIgnoreCase("time") || type.equalsIgnoreCase("code") || type.equalsIgnoreCase("oid") || type.equalsIgnoreCase("id");
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    private boolean isValidFHIRUrn(String uri) {
        return uri.equals("urn:x-fhir:uk:id:nhs-number");
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!v.trim().equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    private CodeableConcept readAsCodeableConcept(WrapperElement element) {
        CodeableConcept cc = new CodeableConcept();
        ArrayList<WrapperElement> list = new ArrayList<WrapperElement>();
        element.getNamedChildren("coding", list);
        for (WrapperElement item : list) {
            cc.addCoding(this.readAsCoding(item));
        }
        cc.setText(element.getNamedChildValue("text"));
        return cc;
    }

    private Coding readAsCoding(WrapperElement item) {
        Coding c = new Coding();
        c.setSystem(item.getNamedChildValue("system"));
        c.setVersion(item.getNamedChildValue("version"));
        c.setCode(item.getNamedChildValue("code"));
        c.setDisplay(item.getNamedChildValue("display"));
        return c;
    }

    private WrapperElement resolve(String ref, NodeStack stack) {
        if (ref.startsWith("#")) {
            while (stack != null && stack.getElement() != null) {
                WrapperElement res = this.getContainedById(stack.getElement(), ref.substring(1));
                if (res != null) {
                    return res;
                }
                stack = stack.parent;
            }
            return null;
        }
        while (stack != null && stack.getElement() != null) {
            WrapperElement res;
            if ("Bundle".equals(stack.getElement().getResourceType()) && (res = this.getFromBundle(stack.getElement(), ref.substring(1))) != null) {
                return res;
            }
            stack = stack.parent;
        }
        return null;
    }

    private ValueSet resolveBindingReference(Type reference) {
        if (reference instanceof UriType) {
            return (ValueSet)this.context.fetchResource(ValueSet.class, ((String)((UriType)reference).getValue()).toString());
        }
        if (reference instanceof Reference) {
            return (ValueSet)this.context.fetchResource(ValueSet.class, ((Reference)reference).getReference());
        }
        return null;
    }

    private WrapperElement resolveInBundle(List<WrapperElement> entries, String ref, String fullUrl, String type, String id) {
        String[] parts;
        if (Utilities.isAbsoluteUrl((String)ref)) {
            for (WrapperElement entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (!ref.equals(fu)) continue;
                return entry;
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring((type + "/" + id).length()) + ref;
        }
        if ((parts = ref.split("\\/")).length >= 2) {
            String t = parts[0];
            String i = parts[1];
            for (WrapperElement entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (u != null && fullUrl.equals(u)) {
                    return entry;
                }
                if (u != null) continue;
                WrapperElement res = entry.getNamedChild("resource");
                WrapperElement resource = res.getFirstChild();
                String et = resource.getResourceType();
                String eid = resource.getNamedChildValue("id");
                if (!t.equals(et) || !i.equals(eid)) continue;
                return entry;
            }
        }
        return null;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String name) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!name.equals(ed.getName())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        return (StructureDefinition)this.context.fetchResource(StructureDefinition.class, pr);
    }

    private ElementDefinition resolveType(String type) {
        String url = "http://hl7.org/fhir/StructureDefinition/" + type;
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        if (sd == null || !sd.hasSnapshot()) {
            return null;
        }
        return (ElementDefinition)sd.getSnapshot().getElement().get(0);
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel value) {
        this.bpWarnings = value;
    }

    private boolean sliceMatches(WrapperElement element, String path, ElementDefinition slice, ElementDefinition ed, StructureDefinition profile) throws DefinitionException {
        if (!slice.getSlicing().hasDiscriminator()) {
            return false;
        }
        for (StringType s : slice.getSlicing().getDiscriminator()) {
            Element value;
            String discriminator = (String)s.getValue();
            ElementDefinition criteria = this.getCriteriaForDiscriminator(path, ed, discriminator, profile);
            if (!(discriminator.equals("url") && criteria.getPath().equals("Extension.url") ? !element.getAttribute("url").equals(((UriType)criteria.getFixed()).asStringValue()) : !this.valueMatchesCriteria(value = this.getValueForDiscriminator(element, discriminator, criteria), criteria))) continue;
            return false;
        }
        return true;
    }

    private void start(List<ValidationMessage> errors, WrapperElement resource, WrapperElement element, StructureDefinition profile, NodeStack stack) throws FHIRException {
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), profile.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0])) {
            this.validateElement(errors, profile, (ElementDefinition)profile.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false);
            this.checkDeclaredProfiles(errors, resource, element, stack);
            if (element.getResourceType().equals("Bundle")) {
                this.validateBundle(errors, element, stack);
            }
            if (element.getResourceType().equals("Observation")) {
                this.validateObservation(errors, element, stack);
            }
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history")) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    public List<ValidationMessage> validate(Document document) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, document);
        return results;
    }

    public List<ValidationMessage> validate(Document document, String profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, document, profile);
        return results;
    }

    public List<ValidationMessage> validate(Document document, StructureDefinition profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, document, profile);
        return results;
    }

    public List<ValidationMessage> validate(Element element) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, element);
        return results;
    }

    public List<ValidationMessage> validate(Element element, String profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, element, profile);
        return results;
    }

    public List<ValidationMessage> validate(Element element, StructureDefinition profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, element, profile);
        return results;
    }

    public List<ValidationMessage> validate(JsonObject obj) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, obj);
        return results;
    }

    public List<ValidationMessage> validate(JsonObject obj, String profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, obj, profile);
        return results;
    }

    public List<ValidationMessage> validate(JsonObject obj, StructureDefinition profile) throws FHIRException {
        ArrayList<ValidationMessage> results = new ArrayList<ValidationMessage>();
        this.validate(results, obj, profile);
        return results;
    }

    public void validate(List<ValidationMessage> errors, Document document) throws FHIRException {
        this.checkForProcessingInstruction(errors, document);
        this.validateResource(errors, null, new DOMWrapperElement(document.getDocumentElement()), null, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, Document document, String profile) throws FHIRException {
        this.checkForProcessingInstruction(errors, document);
        StructureDefinition p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validateResource(errors, null, new DOMWrapperElement(document.getDocumentElement()), p, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, Document document, StructureDefinition profile) throws FHIRException {
        this.checkForProcessingInstruction(errors, document);
        this.validateResource(errors, null, new DOMWrapperElement(document.getDocumentElement()), profile, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, Element element) throws FHIRException {
        this.validateResource(errors, null, new DOMWrapperElement(element), null, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, Element element, String profile) throws FHIRException {
        StructureDefinition p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validateResource(errors, null, new DOMWrapperElement(element), p, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, Element element, StructureDefinition profile) throws FHIRException {
        this.validateResource(errors, null, new DOMWrapperElement(element), profile, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        this.validateResource(errors, null, new JsonWrapperElement((JsonElement)object), null, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, JsonObject object, String profile) throws FHIRException {
        StructureDefinition p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validateResource(errors, null, new JsonWrapperElement((JsonElement)object), p, this.resourceIdRule, null);
    }

    public void validate(List<ValidationMessage> errors, JsonObject object, StructureDefinition profile) throws FHIRException {
        this.validateResource(errors, null, new JsonWrapperElement((JsonElement)object), profile, this.resourceIdRule, null);
    }

    private void validateBundle(List<ValidationMessage> errors, WrapperElement bundle, NodeStack stack) {
        ArrayList<WrapperElement> entries = new ArrayList<WrapperElement>();
        bundle.getNamedChildren("entry", entries);
        String type = bundle.getNamedChildValue("type");
        if (entries.size() == 0) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Documents or Messages must contain at least one entry");
        } else {
            WrapperElement firstEntry = (WrapperElement)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 0, null, null);
            String fullUrl = firstEntry.getNamedChildValue("fullUrl");
            if (type.equals("document")) {
                WrapperElement res = firstEntry.getNamedChild("resource");
                NodeStack localStack = firstStack.push(res, -1, null, null);
                WrapperElement resource = res.getFirstChild();
                String id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), res != null, "No resource on first entry", new Object[0])) {
                    if (bundle.isXml()) {
                        this.validateDocument(errors, entries, resource, localStack.push(resource, -1, null, null), fullUrl, id);
                    } else {
                        this.validateDocument(errors, entries, res, localStack, fullUrl, id);
                    }
                }
            }
            if (type.equals("message")) {
                this.validateMessage(errors, bundle);
            }
        }
    }

    private void validateBundleReference(List<ValidationMessage> errors, List<WrapperElement> entries, WrapperElement ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        if (ref != null && !Utilities.noString((String)ref.getNamedChildValue("reference"))) {
            WrapperElement target = this.resolveInBundle(entries, ref.getNamedChildValue("reference"), fullUrl, type, id);
            this.rule(errors, ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.addToLiteralPath("reference"), target != null, "Unable to resolve the target of the reference in the bundle (" + name + ")", new Object[0]);
        }
    }

    private void validateContains(List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, WrapperElement resource, WrapperElement element, NodeStack stack, IResourceValidator.IdStatus idstatus) throws FHIRException {
        WrapperElement e = element.isXml() ? element.getFirstChild() : element;
        String resourceName = e.getResourceType();
        StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
        if (path.endsWith("resource")) {
            resource = e;
        }
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), profile != null, "No profile found for contained resource of type '" + resourceName + "'", new Object[0])) {
            this.validateResource(errors, resource, e, profile, idstatus, stack);
        }
    }

    private void validateDocument(List<ValidationMessage> errors, List<WrapperElement> entries, WrapperElement composition, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getResourceType().equals("Composition"), "The first entry in a document must be a composition", new Object[0])) {
            this.validateBundleReference(errors, entries, composition.getNamedChild("subject"), "Composition Subject", stack.push(composition.getNamedChild("subject"), -1, null, null), fullUrl, "Composition", id);
            this.validateSections(errors, entries, composition, stack, fullUrl, id);
        }
    }

    private void validateElement(List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, WrapperElement resource, WrapperElement element, String actualType, NodeStack stack, boolean inCodeableConcept) throws FHIRException {
        element.setDefinition(definition);
        element.setProfile(profile);
        if (element.isXml()) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), "http://hl7.org/fhir".equals(element.getNamespace()), "Namespace mismatch - expected 'http://hl7.org/fhir', found '" + element.getNamespace() + "'", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), !element.hasNamespace("http://www.w3.org/2001/XMLSchema-instance"), "Schema Instance Namespace is not allowed in instances", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), !element.hasProcessingInstruction(), "No Processing Instructions in resources", new Object[0]);
        }
        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), !this.empty(element), "Elements must have some content (@value, extensions, or children elements)", new Object[0]);
        this.checkInvariants(errors, stack.literalPath, profile, definition, null, null, resource, element);
        List childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)profile, (String)definition.getName(), (String)definition.getPath(), (String)definition.getNameReference());
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        ElementDefinition slice = null;
        for (ElementDefinition ed : childDefinitions) {
            boolean process = true;
            if (ed.hasSlicing()) {
                if (slice != null && slice.getPath().equals(ed.getPath())) {
                    throw new DefinitionException("Slice encountered midway through path on " + slice.getPath());
                }
                slice = ed;
                process = false;
            } else if (slice != null && !slice.getPath().equals(ed.getPath())) {
                slice = null;
            }
            if (!process) continue;
            for (ElementInfo ei : children) {
                boolean match = false;
                if (slice == null) {
                    match = this.nameMatches(ei.name, this.tail(ed.getPath()));
                } else if (this.nameMatches(ei.name, this.tail(ed.getPath()))) {
                    match = this.sliceMatches(ei.element, ei.path, slice, ed, profile);
                }
                if (!match || !this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition == null, "Element matches more than one slice", new Object[0])) continue;
                ei.definition = ed;
            }
        }
        for (ElementInfo ei : children) {
            if (ei.path.endsWith(".extension")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition != null, "Element is unknown or does not match any slice (url=\"" + ei.element.getAttribute("url") + "\")", new Object[0]);
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition != null || !ei.element.isXml() && ei.element.getName().equals("fhir_comments"), "Element is unknown or does not match any slice", new Object[0]);
        }
        for (ElementDefinition ed : childDefinitions) {
            if (!ed.getRepresentation().isEmpty()) continue;
            int count = 0;
            for (ElementInfo ei : children) {
                if (ei.definition != ed) continue;
                ++count;
            }
            if (ed.getMin() > 0) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), "Element '" + stack.getLiteralPath() + "." + this.tail(ed.getPath()) + "': minimum required = " + Integer.toString(ed.getMin()) + ", but only found " + Integer.toString(count), new Object[0]);
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), "Element " + this.tail(ed.getPath()) + " @ " + stack.getLiteralPath() + ": max allowed = " + ed.getMax() + ", but found " + Integer.toString(count), new Object[0]);
        }
        for (ElementInfo ei : children) {
            String prefix;
            if (ei.definition == null) continue;
            String type = null;
            ElementDefinition typeDefn = null;
            if (!(ei.definition.getType().size() != 1 || ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getCode().equals("*") || ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getCode().equals("Element") || ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getCode().equals("BackboneElement"))) {
                type = ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getCode();
            } else if (ei.definition.getType().size() == 1 && ((ElementDefinition.TypeRefComponent)ei.definition.getType().get(0)).getCode().equals("*")) {
                prefix = this.tail(ei.definition.getPath());
                assert (prefix.endsWith("[x]"));
                type = ei.name.substring(prefix.length() - 3);
                if (this.isPrimitiveType(type)) {
                    type = Utilities.uncapitalize((String)type);
                }
            } else if (ei.definition.getType().size() > 1) {
                prefix = this.tail(ei.definition.getPath());
                assert (this.typesAreAllReference(ei.definition.getType()) || prefix.endsWith("[x]")) : prefix;
                prefix = prefix.substring(0, prefix.length() - 3);
                for (ElementDefinition.TypeRefComponent t : ei.definition.getType()) {
                    if (!(prefix + Utilities.capitalize((String)t.getCode())).equals(ei.name)) continue;
                    type = t.getCode();
                }
                if (type == null) {
                    ElementDefinition.TypeRefComponent trc = (ElementDefinition.TypeRefComponent)ei.definition.getType().get(0);
                    if (trc.getCode().equals("Reference")) {
                        type = "Reference";
                    } else {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "The element " + ei.name + " is illegal. Valid types at this point are " + this.describeTypes(ei.definition.getType()), new Object[0]);
                    }
                }
            } else if (ei.definition.getNameReference() != null) {
                typeDefn = this.resolveNameReference(profile.getSnapshot(), ei.definition.getNameReference());
            }
            if (type != null && type.startsWith("@")) {
                ei.definition = this.findElement(profile, type.substring(1));
                type = null;
            }
            NodeStack localStack = stack.push(ei.element, ei.count, ei.definition, type == null ? typeDefn : this.resolveType(type));
            String localStackLiterapPath = localStack.getLiteralPath();
            String eiPath = ei.path;
            assert (eiPath.equals(localStackLiterapPath)) : "ei.path: " + ElementInfo.access$200(ei) + "  -  localStack.getLiterapPath: " + localStackLiterapPath;
            boolean thisIsCodeableConcept = false;
            if (type != null) {
                if (this.isPrimitiveType(type)) {
                    this.checkPrimitive(errors, ei.path, type, ei.definition, ei.element);
                    continue;
                }
                if (type.equals("Identifier")) {
                    this.checkIdentifier(errors, ei.path, ei.element, ei.definition);
                } else if (type.equals("Coding")) {
                    this.checkCoding(errors, ei.path, ei.element, profile, ei.definition, inCodeableConcept);
                } else if (type.equals("CodeableConcept")) {
                    this.checkCodeableConcept(errors, ei.path, ei.element, profile, ei.definition);
                    thisIsCodeableConcept = true;
                } else if (type.equals("Reference")) {
                    this.checkReference(errors, ei.path, ei.element, profile, ei.definition, actualType, localStack);
                }
                if (type.equals("Extension")) {
                    this.checkExtension(errors, ei.path, ei.element, ei.definition, profile, localStack);
                    continue;
                }
                if (type.equals("Resource")) {
                    this.validateContains(errors, ei.path, ei.definition, definition, resource, ei.element, localStack, this.idStatusForEntry(element, ei));
                    continue;
                }
                StructureDefinition p = this.getProfileForType(type);
                if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, p != null, "Unknown type " + type, new Object[0])) continue;
                this.validateElement(errors, p, (ElementDefinition)p.getSnapshot().getElement().get(0), profile, ei.definition, resource, ei.element, type, localStack, thisIsCodeableConcept);
                continue;
            }
            if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), ei.definition != null, "Unrecognised Content " + ei.name, new Object[0])) continue;
            this.validateElement(errors, profile, ei.definition, null, null, resource, ei.element, type, localStack, false);
        }
    }

    private void validateMessage(List<ValidationMessage> errors, WrapperElement bundle) {
    }

    private void validateObservation(List<ValidationMessage> errors, WrapperElement element, NodeStack stack) {
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject") != null, "All observations should have a subject");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("performer") != null, "All observations should have a performer");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime") != null || element.getNamedChild("effectivePeriod") != null, "All observations should have an effectiveDateTime or an effectivePeriod");
    }

    private void validateResource(List<ValidationMessage> errors, WrapperElement resource, WrapperElement element, StructureDefinition profile, IResourceValidator.IdStatus idstatus, NodeStack stack) throws FHIRException {
        if (stack == null) {
            stack = new NodeStack(element.isXml());
        }
        if (resource == null) {
            resource = element;
        }
        boolean ok = true;
        if (element.isXml()) {
            ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), "/", element.getNamespace().equals("http://hl7.org/fhir"), "Namespace mismatch - expected 'http://hl7.org/fhir', found '" + element.getNamespace() + "'", new Object[0]);
        }
        if (ok) {
            String resourceName = element.getResourceType();
            if (profile == null) {
                profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
                ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), profile != null, "No profile found for resource type '" + resourceName + "'", new Object[0]);
            } else {
                WrapperElement first;
                String type;
                String string = type = profile.hasConstrainedType() ? profile.getConstrainedType() : profile.getName();
                if (!type.equals(resourceName) && resourceName.equals("Bundle") && (first = this.getFirstEntry(element)) != null && first.getResourceType().equals(type)) {
                    element = first;
                    resourceName = element.getResourceType();
                    idstatus = IResourceValidator.IdStatus.OPTIONAL;
                }
                ok = this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, stack.addToLiteralPath(resourceName), type.equals(resourceName), "Specified profile type was '" + profile.getConstrainedType() + "', but resource type was '" + resourceName + "'", new Object[0]);
            }
        }
        if (ok) {
            stack = stack.push(element, -1, (ElementDefinition)profile.getSnapshot().getElement().get(0), (ElementDefinition)profile.getSnapshot().getElement().get(0));
            if (idstatus == IResourceValidator.IdStatus.REQUIRED && element.getNamedChild("id") == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource requires an id, but none is present", new Object[0]);
            } else if (idstatus == IResourceValidator.IdStatus.PROHIBITED && element.getNamedChild("id") != null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource has an id, but none is allowed", new Object[0]);
            }
            this.start(errors, resource, element, profile, stack);
        }
    }

    private void validateSections(List<ValidationMessage> errors, List<WrapperElement> entries, WrapperElement focus, NodeStack stack, String fullUrl, String id) {
        ArrayList<WrapperElement> sections = new ArrayList<WrapperElement>();
        focus.getNamedChildren("entry", sections);
        int i = 0;
        for (WrapperElement section : sections) {
            NodeStack localStack = stack.push(section, 1, null, null);
            this.validateBundleReference(errors, entries, section.getNamedChild("content"), "Section Content", localStack, fullUrl, "Composition", id);
            this.validateSections(errors, entries, section, localStack, fullUrl, id);
            ++i;
        }
    }

    private boolean valueMatchesCriteria(Element value, ElementDefinition criteria) {
        return false;
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= 2100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public abstract class WrapperElement {
        private StructureDefinition profile;
        private ElementDefinition definition;

        public abstract int col();

        public abstract String getAttribute(String var1);

        public ElementDefinition getDefinition() {
            return this.definition;
        }

        public void setDefinition(ElementDefinition definition) {
            this.definition = definition;
        }

        public abstract WrapperElement getFirstChild();

        public abstract String getName();

        public abstract WrapperElement getNamedChild(String var1);

        public abstract String getNamedChildValue(String var1);

        public abstract void getNamedChildren(String var1, List<WrapperElement> var2);

        public abstract void getNamedChildrenWithWildcard(String var1, List<WrapperElement> var2);

        public abstract String getNamespace();

        public abstract WrapperElement getNextSibling();

        public StructureDefinition getProfile() {
            return this.profile;
        }

        public void setProfile(StructureDefinition profile) {
            this.profile = profile;
        }

        public abstract String getResourceType();

        public abstract String getText();

        public abstract boolean hasAttribute(String var1);

        public abstract boolean hasNamespace(String var1);

        public abstract boolean hasProcessingInstruction();

        public abstract boolean isXml();

        public abstract int line();
    }

    private class NodeStack {
        private ElementDefinition definition;
        private WrapperElement element;
        private ElementDefinition extension;
        private String literalPath;
        private List<String> logicalPaths;
        private NodeStack parent;
        private ElementDefinition type;
        private boolean xml;

        public NodeStack(boolean xml) {
            this.xml = xml;
        }

        public String addToLiteralPath(String ... path) {
            StringBuilder b = new StringBuilder();
            b.append(this.getLiteralPath());
            if (this.xml) {
                for (String p : path) {
                    if (p.startsWith(":")) {
                        b.append("[");
                        b.append(p.substring(1));
                        b.append("]");
                        continue;
                    }
                    b.append("/f:");
                    b.append(p);
                }
            } else {
                for (String p : path) {
                    b.append("/");
                    if (p.startsWith(":")) {
                        b.append(p.substring(1));
                        continue;
                    }
                    b.append(p);
                }
            }
            return b.toString();
        }

        private ElementDefinition getDefinition() {
            return this.definition;
        }

        private WrapperElement getElement() {
            return this.element;
        }

        private String getLiteralPath() {
            return this.literalPath == null ? "" : this.literalPath;
        }

        private List<String> getLogicalPaths() {
            return this.logicalPaths == null ? new ArrayList() : this.logicalPaths;
        }

        private ElementDefinition getType() {
            return this.type;
        }

        private void setType(ElementDefinition type) {
            this.type = type;
        }

        private NodeStack push(WrapperElement element, int count, ElementDefinition definition, ElementDefinition type) {
            NodeStack res = new NodeStack(element.isXml());
            res.parent = this;
            res.element = element;
            res.definition = definition;
            if (element.isXml()) {
                res.literalPath = this.getLiteralPath() + (element.getNamespace().equals("http://www.w3.org/1999/xhtml") ? "/h:" : "/f:") + element.getName();
                if (count > -1) {
                    res.literalPath = res.literalPath + "[" + Integer.toString(count) + "]";
                }
            } else {
                res.literalPath = element.getName() == null ? "" : this.getLiteralPath() + "/" + element.getName();
                if (count > -1) {
                    res.literalPath = res.literalPath + "/" + Integer.toString(count);
                }
            }
            res.logicalPaths = new ArrayList<String>();
            if (type != null) {
                res.type = type;
                String t = InstanceValidator.this.tail(definition.getPath());
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + t);
                    if (!t.endsWith("[x]")) continue;
                    res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + type.getPath());
                }
                res.logicalPaths.add(type.getPath());
            } else if (definition != null) {
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + element.getName());
                }
            } else {
                res.logicalPaths.addAll(this.getLogicalPaths());
            }
            return res;
        }
    }

    public class JsonWrapperElement
    extends WrapperElement {
        private JsonElement _element;
        private List<JsonWrapperElement> children = new ArrayList<JsonWrapperElement>();
        private JsonElement element;
        private int index;
        private String name;
        private JsonWrapperElement parent;
        private String path;
        private String resourceType;

        public JsonWrapperElement(JsonElement element) {
            this.name = null;
            this.resourceType = ((JsonObject)element).get("resourceType").getAsString();
            this.element = element;
            this.path = "";
            this.createChildren();
        }

        public JsonWrapperElement(String path, String name, JsonElement element, JsonElement _element, JsonWrapperElement parent, int index) {
            this.path = path + "/" + name;
            this.name = name;
            this.element = element;
            if (element instanceof JsonObject && ((JsonObject)element).has("resourceType")) {
                this.resourceType = ((JsonObject)element).get("resourceType").getAsString();
            }
            this._element = _element;
            this.parent = parent;
            this.index = index;
            this.createChildren();
        }

        @Override
        public int col() {
            return -1;
        }

        private void createChildren() {
            if (this.element != null) {
                if (this.element instanceof JsonPrimitive) {
                    if (this._element != null && this._element instanceof JsonObject) {
                        for (Map.Entry t : ((JsonObject)this._element).entrySet()) {
                            this.processChild((String)t.getKey(), (JsonElement)t.getValue());
                        }
                    }
                } else if (this.element instanceof JsonObject) {
                    for (Map.Entry t : ((JsonObject)this.element).entrySet()) {
                        if (((String)t.getKey()).equals("resourceType")) continue;
                        this.processChild((String)t.getKey(), (JsonElement)t.getValue());
                    }
                } else if (!(this.element instanceof JsonNull)) {
                    throw new Error("unexpected condition: " + this.element.getClass().getName());
                }
            }
            if (this._element != null) {
                // empty if block
            }
        }

        @Override
        public String getAttribute(String name) {
            if (name.equals("value")) {
                if (this.element == null) {
                    return null;
                }
                if (this.element instanceof JsonPrimitive) {
                    return ((JsonPrimitive)this.element).getAsString();
                }
                return null;
            }
            if (name.equals("xml:id")) {
                WrapperElement c = this.getNamedChild("id");
                return c == null ? null : c.getAttribute("value");
            }
            if (name.equals("url")) {
                WrapperElement c = this.getNamedChild("url");
                return c == null ? null : c.getAttribute("value");
            }
            throw new Error("not done yet: " + name);
        }

        @Override
        public WrapperElement getFirstChild() {
            if (this.children.isEmpty()) {
                return null;
            }
            return this.children.get(0);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public WrapperElement getNamedChild(String name) {
            for (JsonWrapperElement j : this.children) {
                if (!j.name.equals(name)) continue;
                return j;
            }
            return null;
        }

        @Override
        public String getNamedChildValue(String name) {
            WrapperElement c = this.getNamedChild(name);
            return c == null ? null : c.getAttribute("value");
        }

        @Override
        public void getNamedChildren(String name, List<WrapperElement> list) {
            for (JsonWrapperElement j : this.children) {
                if (!j.name.equals(name)) continue;
                list.add(j);
            }
        }

        @Override
        public void getNamedChildrenWithWildcard(String name, List<WrapperElement> list) {
            for (JsonWrapperElement j : this.children) {
                String n = j.name;
                if (!n.equals(name) && (!name.endsWith("[x]") || !n.startsWith(name.substring(0, name.length() - 3)))) continue;
                list.add(j);
            }
        }

        @Override
        public String getNamespace() {
            throw new Error("not done yet");
        }

        @Override
        public WrapperElement getNextSibling() {
            if (this.parent == null) {
                return null;
            }
            if (this.index >= this.parent.children.size() - 1) {
                return null;
            }
            return this.parent.children.get(this.index + 1);
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String getText() {
            throw new Error("not done yet");
        }

        @Override
        public boolean hasAttribute(String name) {
            if (name.equals("value")) {
                if (this.element == null) {
                    return false;
                }
                return this.element instanceof JsonPrimitive;
            }
            if (name.equals("xml:id")) {
                return this.getNamedChild("id") != null;
            }
            throw new Error("not done yet: " + name);
        }

        @Override
        public boolean hasNamespace(String ns) {
            throw new Error("not done");
        }

        @Override
        public boolean hasProcessingInstruction() {
            return false;
        }

        @Override
        public boolean isXml() {
            return false;
        }

        @Override
        public int line() {
            return -1;
        }

        private void processChild(String name, JsonElement e) {
            JsonElement _e;
            if (name.startsWith("_")) {
                if (((JsonObject)this.element).has(name = name.substring(1))) {
                    return;
                }
                e = null;
            }
            JsonElement jsonElement = _e = this.element instanceof JsonObject ? ((JsonObject)this.element).get("_" + name) : null;
            if (e instanceof JsonPrimitive || e == null && _e != null && !(_e instanceof JsonArray)) {
                this.children.add(new JsonWrapperElement(this.path, name, e, _e, this, this.children.size()));
            } else if (e instanceof JsonArray || e == null && _e != null) {
                int max;
                JsonArray array = (JsonArray)e;
                JsonArray _array = (JsonArray)_e;
                int n = max = array != null ? array.size() : 0;
                if (_array != null && _array.size() > max) {
                    max = _array.size();
                }
                for (int i = 0; i < max; ++i) {
                    JsonElement a = array == null || array.size() < i ? null : array.get(i);
                    JsonElement _a = _array == null || _array.size() < i ? null : _array.get(i);
                    this.children.add(new JsonWrapperElement(this.path, name, a, _a, this, this.children.size()));
                }
            } else if (e instanceof JsonObject) {
                this.children.add(new JsonWrapperElement(this.path, name, e, null, this, this.children.size()));
            } else {
                throw new Error("not done yet: " + e.getClass().getName());
            }
        }
    }

    public class ElementInfo {
        public int count;
        public ElementDefinition definition;
        private WrapperElement element;
        private String name;
        private String path;

        public ElementInfo(String name, WrapperElement element, String path, int count) {
            this.name = name;
            this.element = element;
            this.path = path;
            this.count = count;
        }

        public int col() {
            return this.element.col();
        }

        public int line() {
            return this.element.line();
        }
    }

    public class DOMWrapperElement
    extends WrapperElement {
        private int col;
        private Element element;
        private int line;

        public DOMWrapperElement(Element element) {
            this.element = element;
            XmlLocationData loc = (XmlLocationData)element.getUserData("locationDataKey");
            if (loc != null) {
                this.line = loc.getStartLine();
                this.col = loc.getStartColumn();
            } else {
                this.line = -1;
                this.col = -1;
            }
        }

        @Override
        public int col() {
            return this.col;
        }

        @Override
        public String getAttribute(String name) {
            return this.element.getAttribute(name);
        }

        @Override
        public WrapperElement getFirstChild() {
            Element res = XMLUtil.getFirstChild((Element)this.element);
            return res == null ? null : new DOMWrapperElement(res);
        }

        @Override
        public String getName() {
            return this.element.getLocalName();
        }

        @Override
        public WrapperElement getNamedChild(String name) {
            Element res = XMLUtil.getNamedChild((Element)this.element, (String)name);
            return res == null ? null : new DOMWrapperElement(res);
        }

        @Override
        public String getNamedChildValue(String name) {
            return XMLUtil.getNamedChildValue((Element)this.element, (String)name);
        }

        @Override
        public void getNamedChildren(String name, List<WrapperElement> list) {
            ArrayList el = new ArrayList();
            XMLUtil.getNamedChildren((Element)this.element, (String)name, el);
            for (Element e : el) {
                list.add(new DOMWrapperElement(e));
            }
        }

        @Override
        public void getNamedChildrenWithWildcard(String name, List<WrapperElement> list) {
            ArrayList el = new ArrayList();
            XMLUtil.getNamedChildrenWithWildcard((Element)this.element, (String)name, el);
            for (Element e : el) {
                list.add(new DOMWrapperElement(e));
            }
        }

        @Override
        public String getNamespace() {
            return this.element.getNamespaceURI();
        }

        @Override
        public WrapperElement getNextSibling() {
            Element res = XMLUtil.getNextSibling((Element)this.element);
            return res == null ? null : new DOMWrapperElement(res);
        }

        @Override
        public String getResourceType() {
            return this.element.getLocalName();
        }

        @Override
        public String getText() {
            return this.element.getTextContent();
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        @Override
        public boolean hasNamespace(String ns) {
            for (int i = 0; i < this.element.getAttributes().getLength(); ++i) {
                Node a = this.element.getAttributes().item(i);
                if (!a.getNodeName().equals("xmlns") && !a.getNodeName().startsWith("xmlns:") || !a.getNodeValue().equals(ns)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasProcessingInstruction() {
            for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 7) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isXml() {
            return true;
        }

        @Override
        public int line() {
            return this.line;
        }
    }

    public class ChildIterator {
        private String basePath;
        private WrapperElement child;
        private int lastCount;
        private WrapperElement parent;

        public ChildIterator(String path, WrapperElement element) {
            this.parent = element;
            this.basePath = path;
        }

        public int count() {
            WrapperElement n = this.child.getNextSibling();
            if (n != null && n.getName().equals(this.child.getName())) {
                return this.lastCount + 1;
            }
            return -1;
        }

        public WrapperElement element() {
            return this.child;
        }

        public String name() {
            return this.child.getName();
        }

        public boolean next() {
            if (this.child == null) {
                this.child = this.parent.getFirstChild();
                this.lastCount = 0;
            } else {
                String lastName = this.child.getName();
                this.child = this.child.getNextSibling();
                this.lastCount = this.child != null && this.child.getName().equals(lastName) ? ++this.lastCount : 0;
            }
            return this.child != null;
        }

        public String path() {
            WrapperElement n = this.child.getNextSibling();
            if (this.parent.isXml()) {
                String sfx = "";
                if (n != null && n.getName().equals(this.child.getName())) {
                    sfx = "[" + Integer.toString(this.lastCount + 1) + "]";
                }
                if ("http://www.w3.org/1999/xhtml".equals(this.child.getNamespace())) {
                    return this.basePath + "/h:" + this.name() + sfx;
                }
                return this.basePath + "/f:" + this.name() + sfx;
            }
            String sfx = "";
            if (n != null && n.getName().equals(this.child.getName())) {
                sfx = "/" + Integer.toString(this.lastCount + 1);
            }
            return this.basePath + "/" + this.name() + sfx;
        }
    }

    public class BaseOnWrapper
    extends Base {
        private static final long serialVersionUID = 1L;
        private IWorkerContext services;
        private WrapperElement wrapper;
        private List<ElementDefinition> elementList;
        private StructureDefinition profile;
        private ElementDefinition definition;
        private List<ElementDefinition> childDefinitions;
        private String typeName;
        private String typeProfile;

        public BaseOnWrapper(IWorkerContext services, WrapperElement wrapper, StructureDefinition profile, ElementDefinition definition, String typeName, String typeProfile) {
            this.services = services;
            this.wrapper = wrapper;
            this.profile = profile;
            this.definition = definition;
            this.typeName = typeName;
            this.typeProfile = typeProfile;
        }

        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other) || !this.fhirType().equals(other.fhirType())) {
                return false;
            }
            try {
                this.getDefinition("xxxx");
                List<ElementDefinition> childList = this.childDefinitions;
                for (ElementDefinition ed : childList) {
                    List otherList;
                    String tail = InstanceValidator.this.tail(ed.getPath());
                    List<Base> thisList = this.listChildrenByName(tail);
                    if (BaseOnWrapper.compareDeep(thisList, (List)(otherList = other.listChildrenByName(tail)), (boolean)false)) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String fhirType() {
            if (!Utilities.noString((String)this.typeName)) {
                return this.typeName;
            }
            return ((ElementDefinition.TypeRefComponent)this.definition.getType().get(0)).getCode();
        }

        private ElementDefinitionOutcome getDefinition(String name) throws DefinitionException {
            if (this.childDefinitions == null) {
                this.childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)this.profile, (String)this.definition.getName(), (String)this.definition.getPath(), (String)this.definition.getNameReference());
            }
            if (this.childDefinitions.size() == 0) {
                StructureDefinition profile;
                String pn = this.typeProfile;
                if (Utilities.noString((String)pn) && !Utilities.noString((String)this.typeName)) {
                    pn = "http://hl7.org/fhir/StructureDefinition/" + this.typeName;
                }
                if (Utilities.noString((String)pn) && this.definition.getType().size() == 1) {
                    pn = ((ElementDefinition.TypeRefComponent)this.definition.getType().get(0)).getProfile().size() > 0 ? (String)((UriType)((ElementDefinition.TypeRefComponent)this.definition.getType().get(0)).getProfile().get(0)).getValue() : "http://hl7.org/fhir/StructureDefinition/" + ((ElementDefinition.TypeRefComponent)this.definition.getType().get(0)).getCode();
                }
                if (!Utilities.noString((String)pn) && (profile = (StructureDefinition)this.services.fetchResource(StructureDefinition.class, pn)) != null) {
                    this.profile = profile;
                    this.childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)profile, null, (String)((ElementDefinition)profile.getSnapshot().getElement().get(0)).getPath(), null);
                }
            }
            for (ElementDefinition ed : this.childDefinitions) {
                ElementDefinition.TypeRefComponent tr;
                String tail = ed.getPath().substring(ed.getPath().lastIndexOf(46) + 1);
                if (tail.equals(name)) {
                    return new ElementDefinitionOutcome(ed);
                }
                if (!tail.endsWith("[x]") || name.length() <= tail.length() - 1 || !tail.substring(0, tail.length() - 3).equals(name.substring(0, tail.length() - 3)) || (tr = this.getType(ed, name.substring(tail.length() - 3))) == null) continue;
                return new ElementDefinitionOutcome(ed, tr);
            }
            return null;
        }

        private ElementDefinition.TypeRefComponent getType(ElementDefinition ed, String type) {
            for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                if (!t.getCode().equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }

        protected boolean isMetadataBased() {
            return true;
        }

        public boolean isPrimitive() {
            String t = this.fhirType();
            return t.equalsIgnoreCase("boolean") || t.equalsIgnoreCase("integer") || t.equalsIgnoreCase("string") || t.equalsIgnoreCase("decimal") || t.equalsIgnoreCase("uri") || t.equalsIgnoreCase("base64Binary") || t.equalsIgnoreCase("instant") || t.equalsIgnoreCase("date") || t.equalsIgnoreCase("uuid") || t.equalsIgnoreCase("id") || t.equalsIgnoreCase("xhtml") || t.equalsIgnoreCase("markdown") || t.equalsIgnoreCase("dateTime") || t.equalsIgnoreCase("time") || t.equalsIgnoreCase("code") || t.equalsIgnoreCase("oid") || t.equalsIgnoreCase("id");
        }

        protected void listChildren(List<Property> result) {
            throw new Error("not done yet");
        }

        public List<Base> listChildrenByName(String child_name) {
            ArrayList<Base> list = new ArrayList<Base>();
            ArrayList<WrapperElement> children = new ArrayList<WrapperElement>();
            this.wrapper.getNamedChildrenWithWildcard(child_name, children);
            for (WrapperElement child : children) {
                ElementDefinitionOutcome definition;
                try {
                    definition = this.getDefinition(child.getName());
                }
                catch (Exception e) {
                    definition = null;
                }
                if (definition == null) continue;
                ElementDefinition.TypeRefComponent tr = this.getType(definition.definition, "Resource");
                if (tr != null && this.wrapper.isXml()) {
                    list.add(new BaseOnWrapper(this.services, child.getFirstChild(), this.profile, definition.definition, definition.typename, definition.profile));
                    continue;
                }
                list.add(new BaseOnWrapper(this.services, child, this.profile, definition.definition, definition.typename, definition.profile));
            }
            return list;
        }

        public String primitiveValue() {
            return this.wrapper.getAttribute("value");
        }

        public String toString() {
            if (this.isPrimitive()) {
                return this.primitiveValue();
            }
            return this.fhirType();
        }
    }

    public class ResourceOnWrapper
    extends Resource {
        private static final long serialVersionUID = 1L;
        private IWorkerContext services;
        private WrapperElement wrapper;
        private List<ElementDefinition> elementList;
        private StructureDefinition profile;
        private ElementDefinition definition;
        private List<ElementDefinition> childDefinitions;

        public ResourceOnWrapper(IWorkerContext services, WrapperElement wrapper, StructureDefinition profile) {
            this.services = services;
            this.wrapper = wrapper;
            this.profile = profile;
            this.definition = (ElementDefinition)profile.getSnapshot().getElement().get(0);
        }

        public Resource copy() {
            throw new Error("copy() is not implemented here");
        }

        public String fhirType() {
            return this.wrapper.getResourceType();
        }

        private ElementDefinitionOutcome getDefinition(String name) throws DefinitionException {
            if (this.childDefinitions == null) {
                this.childDefinitions = ProfileUtilities.getChildMap((StructureDefinition)this.profile, (String)this.definition.getName(), (String)this.definition.getPath(), (String)this.definition.getNameReference());
            }
            for (ElementDefinition ed : this.childDefinitions) {
                ElementDefinition.TypeRefComponent tr;
                String tail = ed.getPath().substring(ed.getPath().lastIndexOf(46) + 1);
                if (tail.equals(name)) {
                    return new ElementDefinitionOutcome(ed);
                }
                if (!tail.endsWith("[x]") || !tail.substring(0, tail.length() - 3).equals(name.substring(0, tail.length() - 3)) || (tr = this.getType(ed, name.substring(tail.length() - 3))) == null) continue;
                return new ElementDefinitionOutcome(ed, tr);
            }
            return null;
        }

        public ResourceType getResourceType() {
            try {
                return ResourceType.fromCode((String)this.fhirType());
            }
            catch (Exception e) {
                return null;
            }
        }

        private ElementDefinition.TypeRefComponent getType(ElementDefinition ed, String type) {
            for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                if (!t.getCode().equals(type)) continue;
                return t;
            }
            return null;
        }

        protected boolean isMetadataBased() {
            return true;
        }

        public List<Base> listChildrenByName(String child_name) {
            ArrayList<Base> list = new ArrayList<Base>();
            ArrayList<WrapperElement> children = new ArrayList<WrapperElement>();
            this.wrapper.getNamedChildren(child_name, children);
            for (WrapperElement child : children) {
                ElementDefinitionOutcome definition;
                try {
                    definition = this.getDefinition(child.getName());
                }
                catch (Exception e) {
                    definition = null;
                }
                if (definition == null) continue;
                ElementDefinition.TypeRefComponent tr = this.getType(definition.definition, "Resource");
                if (tr != null && this.wrapper.isXml()) {
                    list.add(new BaseOnWrapper(this.services, child.getFirstChild(), this.profile, definition.definition, definition.typename, definition.profile));
                    continue;
                }
                list.add(new BaseOnWrapper(this.services, child, this.profile, definition.definition, definition.typename, definition.profile));
            }
            return list;
        }

        public String toString() {
            return this.fhirType();
        }
    }

    private class ElementDefinitionOutcome {
        private ElementDefinition definition;
        private String typename;
        private String profile;

        public ElementDefinitionOutcome(ElementDefinition ed) {
            this.definition = ed;
        }

        public ElementDefinitionOutcome(ElementDefinition ed, ElementDefinition.TypeRefComponent tr) {
            this.definition = ed;
            this.typename = tr.getCode();
            if (tr.hasProfile()) {
                this.profile = (String)((UriType)tr.getProfile().get(0)).getValue();
            }
        }
    }
}

