/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class BaseValidator {
    protected ValidationMessage.Source source;

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL));
        }
        return thePass;
    }

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL));
        }
        return thePass;
    }

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, this.formatMessage(theMessage, theMessageArguments), ValidationMessage.IssueSeverity.FATAL));
        }
        return thePass;
    }

    protected boolean fail(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.FATAL));
        }
        return thePass;
    }

    private String formatMessage(String theMessage, Object ... theMessageArguments) {
        String message = theMessageArguments != null && theMessageArguments.length > 0 ? MessageFormat.format(theMessage, theMessageArguments) : theMessage;
        return message;
    }

    protected boolean grammarWord(String w) {
        return w.equals("and") || w.equals("or") || w.equals("a") || w.equals("the") || w.equals("for") || w.equals("this") || w.equals("that") || w.equals("of");
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    public static boolean rule(List<ValidationMessage> errors, ValidationMessage.Source source, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, ValidationMessage.IssueSeverity.ERROR));
        }
        return thePass;
    }

    protected String splitByCamelCase(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c) && i != 0 && !Character.isUpperCase(s.charAt(i - 1))) {
                b.append(' ');
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String stripPunctuation(String s, boolean numbers) {
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            int t = Character.getType(c);
            if (!(t == 1 || t == 2 || t == 3 || t == 4 || t == 5 || t == 9 && numbers || t == 10 && numbers) && c != ' ') continue;
            b.append(c);
        }
        return b.toString();
    }

    private String toPath(List<String> pathParts) {
        if (pathParts == null || pathParts.isEmpty()) {
            return "";
        }
        return "//" + StringUtils.join(pathParts, (char)'/');
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            msg = this.formatMessage(msg, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, line, col, path, msg, ValidationMessage.IssueSeverity.WARNING));
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING));
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.WARNING));
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, ValidationMessage.IssueSeverity.WARNING));
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            msg = this.formatMessage(msg, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, ValidationMessage.IssueSeverity.WARNING));
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass) {
            msg = this.formatMessage(msg, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass) {
            String path = this.toPath(pathParts);
            String message = this.formatMessage(theMessage, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass) {
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass) {
            msg = this.formatMessage(msg, theMessageArguments);
            errors.add(new ValidationMessage(this.source, type, -1, -1, path, msg, html, ValidationMessage.IssueSeverity.INFORMATION));
        }
        return thePass;
    }
}

