/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.instance.hapi.validation.IValidationSupport;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CachingValidationSupport
implements IValidationSupport {
    private final IValidationSupport myWrap;
    private final Cache<String, Object> myCache;

    public CachingValidationSupport(IValidationSupport theWrap) {
        this.myWrap = theWrap;
        this.myCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    @Override
    public List<StructureDefinition> allStructures() {
        return (List)this.myCache.get((Object)"fetchAllStructureDefinitions", t -> this.myWrap.allStructures());
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return this.myWrap.expandValueSet(theContext, theInclude);
    }

    @Override
    public ValueSet fetchCodeSystem(FhirContext theContext, String theSystem) {
        return this.myWrap.fetchCodeSystem(theContext, theSystem);
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        return this.myWrap.fetchResource(theContext, theClass, theUri);
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return this.myWrap.isCodeSystemSupported(theContext, theSystem);
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay) {
        return this.myWrap.validateCode(theContext, theCodeSystem, theCode, theDisplay);
    }
}

