/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.validation.BaseValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class QuestionnaireResponseValidator
extends BaseValidator {
    private IWorkerContext myWorkerCtx;

    public QuestionnaireResponseValidator(IWorkerContext theWorkerCtx) {
        this.myWorkerCtx = theWorkerCtx;
    }

    private Set<Class<? extends Type>> allowedTypes(Class<? extends Type> theClass0) {
        return this.allowedTypes(theClass0, null);
    }

    private Set<Class<? extends Type>> allowedTypes(Class<? extends Type> theClass0, Class<? extends Type> theClass1) {
        HashSet<Class<? extends Type>> retVal = new HashSet<Class<? extends Type>>();
        retVal.add(theClass0);
        if (theClass1 != null) {
            retVal.add(theClass1);
        }
        return Collections.unmodifiableSet(retVal);
    }

    private List<QuestionnaireResponse.QuestionnaireResponseItemComponent> findResponsesByLinkId(List<QuestionnaireResponse.QuestionnaireResponseItemComponent> theItem, String theLinkId) {
        Validate.notBlank((CharSequence)theLinkId, (String)"theLinkId must not be blank", (Object[])new Object[0]);
        ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> retVal = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent next : theItem) {
            if (!theLinkId.equals(next.getLinkId())) continue;
            retVal.add(next);
        }
        return retVal;
    }

    public void validate(List<ValidationMessage> theErrors, QuestionnaireResponse theAnswers) {
        LinkedList<String> pathStack = new LinkedList<String>();
        pathStack.add("QuestionnaireResponse");
        pathStack.add("questionnaire");
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, pathStack, theAnswers.hasQuestionnaire(), "QuestionnaireResponse does not specity which questionnaire it is providing answers to")) {
            return;
        }
        Reference questionnaireRef = theAnswers.getQuestionnaire();
        Questionnaire questionnaire = this.getQuestionnaire(theAnswers, questionnaireRef);
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, pathStack, questionnaire != null, "Questionnaire {0} is not found in the WorkerContext", theAnswers.getQuestionnaire().getReference())) {
            return;
        }
        QuestionnaireResponse.QuestionnaireResponseStatus status = theAnswers.getStatus();
        boolean validateRequired = false;
        if (status == QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED || status == QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED) {
            validateRequired = true;
        }
        pathStack.removeLast();
        this.validateItems(theErrors, questionnaire.getItem(), theAnswers.getItem(), pathStack, theAnswers, validateRequired);
    }

    private Questionnaire getQuestionnaire(QuestionnaireResponse theAnswers, Reference theQuestionnaireRef) {
        Questionnaire retVal;
        String value = theQuestionnaireRef.getReferenceElement().getValue();
        if (theQuestionnaireRef.getReferenceElement().isLocal()) {
            retVal = (Questionnaire)theQuestionnaireRef.getResource();
            if (retVal == null) {
                for (Resource next : theAnswers.getContained()) {
                    if (!value.equals(next.getId())) continue;
                    retVal = (Questionnaire)next;
                }
            }
        } else {
            retVal = (Questionnaire)this.myWorkerCtx.fetchResource(Questionnaire.class, value);
        }
        return retVal;
    }

    private ValueSet getValueSet(QuestionnaireResponse theResponse, Reference theQuestionnaireRef) {
        ValueSet retVal;
        if (theQuestionnaireRef.getReferenceElement().isLocal()) {
            retVal = (ValueSet)theQuestionnaireRef.getResource();
            if (retVal == null) {
                for (Resource next : theResponse.getContained()) {
                    if (!theQuestionnaireRef.getReferenceElement().getValue().equals(next.getId())) continue;
                    retVal = (ValueSet)next;
                }
            }
        } else {
            retVal = (ValueSet)this.myWorkerCtx.fetchResource(ValueSet.class, theQuestionnaireRef.getReferenceElement().getValue());
        }
        return retVal;
    }

    private void validateGroup(List<ValidationMessage> theErrors, Questionnaire.QuestionnaireItemComponent theQuestGroup, QuestionnaireResponse.QuestionnaireResponseItemComponent theRespGroup, LinkedList<String> thePathStack, QuestionnaireResponse theResponse, boolean theValidateRequired) {
        this.validateItems(theErrors, theQuestGroup.getItem(), theRespGroup.getItem(), thePathStack, theResponse, theValidateRequired);
    }

    private void validateQuestion(List<ValidationMessage> theErrors, Questionnaire.QuestionnaireItemComponent theQuestion, QuestionnaireResponse.QuestionnaireResponseItemComponent theRespGroup, LinkedList<String> thePathStack, QuestionnaireResponse theResponse, boolean theValidateRequired) {
        String linkId = theQuestion.getLinkId();
        if (!this.fail(theErrors, ValidationMessage.IssueType.INVALID, thePathStack, StringUtils.isNotBlank((CharSequence)linkId), "Questionnaire is invalid, question found with no link ID")) {
            return;
        }
        Questionnaire.QuestionnaireItemType type = theQuestion.getType();
        if (type == null) {
            this.rule(theErrors, ValidationMessage.IssueType.INVALID, thePathStack, false, "Questionnaire is invalid, no type specified for question with link ID[{0}]", linkId);
            return;
        }
        List responses = theRespGroup.getAnswer();
        if (responses.size() > 1) {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRepeats(), "Multiple answers found with linkId[{0}]", linkId);
        }
        if (responses.size() == 0) {
            if (theValidateRequired) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired(), "Missing answer item for required item with linkId[{0}]", linkId);
            } else {
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired(), "Missing answer item for required item with linkId[{0}]", linkId);
            }
            return;
        }
        this.validateQuestionAnswers(theErrors, theQuestion, thePathStack, type, theRespGroup, theResponse, theValidateRequired);
    }

    private void validateItems(List<ValidationMessage> theErrors, List<Questionnaire.QuestionnaireItemComponent> theQuestionnaireItems, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> theResponseItems, LinkedList<String> thePathStack, QuestionnaireResponse theResponse, boolean theValidateRequired) {
        HashSet<String> allowedItems = new HashSet<String>();
        for (Questionnaire.QuestionnaireItemComponent nextQuestionnaireItem : theQuestionnaireItems) {
            if (nextQuestionnaireItem.getType() == Questionnaire.QuestionnaireItemType.NULL || nextQuestionnaireItem.getType() == null) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Questionnaire definition contains item with no type");
                String linkId = nextQuestionnaireItem.getLinkId();
                if (!StringUtils.isNotBlank((CharSequence)linkId)) continue;
                allowedItems.add(linkId);
                continue;
            }
            if (Questionnaire.QuestionnaireItemType.DISPLAY.equals((Object)nextQuestionnaireItem.getType())) continue;
            String itemType = Questionnaire.QuestionnaireItemType.GROUP.equals((Object)nextQuestionnaireItem.getType()) ? "group" : "question";
            String linkId = nextQuestionnaireItem.getLinkId();
            if (StringUtils.isBlank((CharSequence)linkId)) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Questionnaire definition contains {0} with no linkId", itemType);
                continue;
            }
            allowedItems.add(linkId);
            List<QuestionnaireResponse.QuestionnaireResponseItemComponent> responseItems = this.findResponsesByLinkId(theResponseItems, linkId);
            if (responseItems.isEmpty()) {
                if (!nextQuestionnaireItem.getRequired()) continue;
                if (theValidateRequired) {
                    this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Missing required {0} with linkId[{1}]", itemType, linkId);
                    continue;
                }
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Missing required {0} with linkId[{1}]", itemType, linkId);
                continue;
            }
            if (responseItems.size() > 1 && !nextQuestionnaireItem.getRepeats()) {
                int index = theResponseItems.indexOf(responseItems.get(1));
                thePathStack.add("item(" + index + ")");
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Multiple repetitions of {0} with linkId[{1}] found at this position, but this item cannot repeat", itemType, linkId);
                thePathStack.removeLast();
            }
            for (QuestionnaireResponse.QuestionnaireResponseItemComponent nextResponseItem : responseItems) {
                int index = theResponseItems.indexOf(nextResponseItem);
                thePathStack.add("item(" + index + ")");
                if (nextQuestionnaireItem.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
                    this.validateGroup(theErrors, nextQuestionnaireItem, nextResponseItem, thePathStack, theResponse, theValidateRequired);
                } else {
                    this.validateQuestion(theErrors, nextQuestionnaireItem, nextResponseItem, thePathStack, theResponse, theValidateRequired);
                }
                thePathStack.removeLast();
            }
        }
        int idx = -1;
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent next : theResponseItems) {
            ++idx;
            if (allowedItems.contains(next.getLinkId())) continue;
            thePathStack.add("item(" + idx + ")");
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Item with linkId[{0}] found at this position, but this item does not exist at this position in Questionnaire", next.getLinkId());
            thePathStack.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateQuestionAnswers(List<ValidationMessage> theErrors, Questionnaire.QuestionnaireItemComponent theQuestion, LinkedList<String> thePathStack, Questionnaire.QuestionnaireItemType type, QuestionnaireResponse.QuestionnaireResponseItemComponent responseQuestion, QuestionnaireResponse theResponse, boolean theValidateRequired) {
        String linkId = theQuestion.getLinkId();
        Set<Class<? extends Type>> allowedAnswerTypes = this.determineAllowedAnswerTypes(type);
        if (allowedAnswerTypes.isEmpty()) {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, responseQuestion.isEmpty(), "Question with linkId[{0}] has no answer type but an answer was provided", linkId);
        } else {
            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, responseQuestion.getAnswer().size() <= 1 || theQuestion.getRepeats(), "Multiple answers to non repeating question with linkId[{0}]", linkId);
            if (theValidateRequired) {
                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired() || !responseQuestion.getAnswer().isEmpty(), "Missing answer to required question with linkId[{0}]", linkId);
            } else {
                this.hint(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, !theQuestion.getRequired() || !responseQuestion.getAnswer().isEmpty(), "Missing answer to required question with linkId[{0}]", linkId);
            }
        }
        int answerIdx = -1;
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent nextAnswer : responseQuestion.getAnswer()) {
            ++answerIdx;
            try {
                thePathStack.add("answer(" + answerIdx + ")");
                Type nextValue = nextAnswer.getValue();
                if (!allowedAnswerTypes.contains(nextValue.getClass())) {
                    this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] found of type [{1}] but this is invalid for question of type [{2}]", linkId, nextValue.getClass().getSimpleName(), type.toCode());
                    continue;
                }
                if (type == Questionnaire.QuestionnaireItemType.CHOICE || type == Questionnaire.QuestionnaireItemType.OPENCHOICE) {
                    if (nextAnswer.getValue() instanceof StringType) {
                        String value = (String)((StringType)nextAnswer.getValue()).getValue();
                        if (StringUtils.isBlank((CharSequence)value) && Boolean.TRUE.equals(theQuestion.getRequiredElement().getValue())) {
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] has no value but this item is required", linkId);
                        }
                    } else {
                        String optionsRef;
                        Coding coding = (Coding)nextAnswer.getValue();
                        if (StringUtils.isBlank((CharSequence)coding.getCode()) && StringUtils.isBlank((CharSequence)coding.getDisplay()) && StringUtils.isBlank((CharSequence)coding.getSystem())) {
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] is of type coding, but none of code, system, and display are populated", linkId);
                            continue;
                        }
                        if (StringUtils.isBlank((CharSequence)coding.getCode()) && StringUtils.isBlank((CharSequence)coding.getSystem())) {
                            if (type != Questionnaire.QuestionnaireItemType.OPENCHOICE) {
                                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] is of type only has a display populated (no code or system) but question does not allow {1}", linkId, Questionnaire.QuestionnaireItemType.OPENCHOICE.name());
                                continue;
                            }
                        } else if (StringUtils.isBlank((CharSequence)coding.getCode()) || StringUtils.isBlank((CharSequence)coding.getSystem())) {
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Answer to question with linkId[{0}] has a coding, but this coding does not contain a code and system (both must be present, or neither as the question allows {1})", linkId, Questionnaire.QuestionnaireItemType.OPENCHOICE.name());
                            continue;
                        }
                        if (StringUtils.isNotBlank((CharSequence)(optionsRef = theQuestion.getOptions().getReference()))) {
                            ValueSet valueSet = this.getValueSet(theResponse, theQuestion.getOptions());
                            if (valueSet == null) {
                                this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, false, "Question with linkId[{0}] has options ValueSet[{1}] but this ValueSet can not be found", linkId, optionsRef);
                                continue;
                            }
                            boolean found = false;
                            for (ValueSet.ValueSetExpansionContainsComponent next : valueSet.getExpansion().getContains()) {
                                if (!coding.getCode().equals(next.getCode()) || !coding.getSystem().equals(next.getSystem())) continue;
                                found = true;
                                break;
                            }
                            this.rule(theErrors, ValidationMessage.IssueType.BUSINESSRULE, thePathStack, found, "Question with linkId[{0}] has answer with system[{1}] and code[{2}] but this is not a valid answer for ValueSet[{3}]", linkId, coding.getSystem(), coding.getCode(), optionsRef);
                        }
                    }
                }
                this.validateItems(theErrors, theQuestion.getItem(), nextAnswer.getItem(), thePathStack, theResponse, theValidateRequired);
            }
            finally {
                thePathStack.removeLast();
            }
        }
    }

    private Set<Class<? extends Type>> determineAllowedAnswerTypes(Questionnaire.QuestionnaireItemType type) {
        Set<Class<? extends Type>> allowedAnswerTypes;
        switch (type) {
            case ATTACHMENT: {
                allowedAnswerTypes = this.allowedTypes(Attachment.class);
                break;
            }
            case BOOLEAN: {
                allowedAnswerTypes = this.allowedTypes(BooleanType.class);
                break;
            }
            case CHOICE: {
                allowedAnswerTypes = this.allowedTypes(Coding.class);
                break;
            }
            case DATE: {
                allowedAnswerTypes = this.allowedTypes(DateType.class);
                break;
            }
            case DATETIME: {
                allowedAnswerTypes = this.allowedTypes(DateTimeType.class);
                break;
            }
            case DECIMAL: {
                allowedAnswerTypes = this.allowedTypes(DecimalType.class);
                break;
            }
            case INTEGER: {
                allowedAnswerTypes = this.allowedTypes(IntegerType.class);
                break;
            }
            case OPENCHOICE: {
                allowedAnswerTypes = this.allowedTypes(Coding.class, StringType.class);
                break;
            }
            case QUANTITY: {
                allowedAnswerTypes = this.allowedTypes(Quantity.class);
                break;
            }
            case REFERENCE: {
                allowedAnswerTypes = this.allowedTypes(Reference.class);
                break;
            }
            case STRING: {
                allowedAnswerTypes = this.allowedTypes(StringType.class);
                break;
            }
            case TEXT: {
                allowedAnswerTypes = this.allowedTypes(StringType.class);
                break;
            }
            case TIME: {
                allowedAnswerTypes = this.allowedTypes(TimeType.class);
                break;
            }
            case URL: {
                allowedAnswerTypes = this.allowedTypes(UriType.class);
                break;
            }
            default: {
                allowedAnswerTypes = Collections.emptySet();
            }
        }
        return allowedAnswerTypes;
    }
}

