/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CachingValidationSupport
implements IValidationSupport {
    private final IValidationSupport myWrap;
    private final Cache<String, Object> myCache;

    public CachingValidationSupport(IValidationSupport theWrap) {
        this.myWrap = theWrap;
        this.myCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return this.myWrap.expandValueSet(theContext, theInclude);
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        return (List)this.myCache.get((Object)"fetchAllConformanceResources", t -> this.myWrap.fetchAllConformanceResources(theContext));
    }

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return (List)this.myCache.get((Object)"fetchAllStructureDefinitions", t -> this.myWrap.fetchAllStructureDefinitions(theContext));
    }

    public CodeSystem fetchCodeSystem(FhirContext theContext, String theSystem) {
        return this.myWrap.fetchCodeSystem(theContext, theSystem);
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        return (T)this.myWrap.fetchResource(theContext, theClass, theUri);
    }

    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        return this.myWrap.fetchStructureDefinition(theCtx, theUrl);
    }

    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return this.myWrap.isCodeSystemSupported(theContext, theSystem);
    }

    public IValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay) {
        return this.myWrap.validateCode(theContext, theCodeSystem, theCode, theDisplay);
    }
}

