/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLSXmlParser {
    private static final String XLS_NS = "urn:schemas-microsoft-com:office:spreadsheet";
    private Map<String, Sheet> sheets;
    private Document xml;
    private String name;
    private Integer rowIndex;

    public XLSXmlParser(InputStream in, String name) throws FHIRException {
        this.name = name;
        try {
            this.xml = this.parseXml(in);
            this.sheets = new HashMap<String, Sheet>();
            this.readXml();
        }
        catch (Exception e) {
            throw new FHIRException("unable to load " + name + ": " + e.getMessage(), e);
        }
    }

    private Document parseXml(InputStream in) throws FHIRException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (Exception e) {
            throw new FHIRException("Error processing " + this.name + ": " + e.getMessage(), e);
        }
    }

    private void readXml() throws FHIRException {
        Element root = this.xml.getDocumentElement();
        this.check(root.getNamespaceURI().equals(XLS_NS), "Spreadsheet namespace incorrect");
        this.check(root.getNodeName().equals("Workbook"), "Spreadsheet element name incorrect");
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals("Worksheet")) continue;
            this.processWorksheet((Element)node);
        }
    }

    private void processWorksheet(Element node) throws FHIRException {
        Sheet sheet = new Sheet();
        sheet.title = node.getAttributeNS(XLS_NS, "Name");
        this.sheets.put(node.getAttributeNS(XLS_NS, "Name"), sheet);
        NodeList table = node.getElementsByTagNameNS(XLS_NS, "Table");
        this.check(table.getLength() == 1, "multiple table elements");
        NodeList rows = ((Element)table.item(0)).getElementsByTagNameNS(XLS_NS, "Row");
        if (rows.getLength() == 0) {
            return;
        }
        this.rowIndex = 1;
        sheet.columns = this.readRow((Element)rows.item(0));
        for (int i = 1; i < rows.getLength(); ++i) {
            Integer n = this.rowIndex;
            Integer n2 = this.rowIndex = Integer.valueOf(this.rowIndex + 1);
            sheet.rows.add(this.readRow((Element)rows.item(i)));
        }
        while (sheet.rows.size() != 0 && this.isEmptyRow(sheet.rows.get(sheet.rows.size() - 1))) {
            sheet.rows.remove(sheet.rows.size() - 1);
        }
    }

    private boolean isEmptyRow(Row w) {
        for (int col = 0; col < w.size(); ++col) {
            if (((String)w.get(col)).trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Row readRow(Element row) throws DOMException, FHIRException {
        Row res = new Row();
        int ndx = 1;
        NodeList cells = row.getElementsByTagNameNS(XLS_NS, "Cell");
        for (int i = 0; i < cells.getLength(); ++i) {
            Element cell = (Element)cells.item(i);
            if (cell.hasAttributeNS(XLS_NS, "Index")) {
                int index = Integer.parseInt(cell.getAttributeNS(XLS_NS, "Index"));
                while (ndx < index) {
                    res.add("");
                    ++ndx;
                }
            }
            res.add(this.readData(cell, ndx, res.size() > 0 ? (String)res.get(0) : "?"));
            ++ndx;
        }
        return res;
    }

    private String readData(Element cell, int col, String s) throws DOMException, FHIRException {
        ArrayList<Element> data = new ArrayList<Element>();
        XMLUtil.getNamedChildren(cell, "Data", data);
        if (data.size() == 0) {
            return "";
        }
        this.check(data.size() == 1, "Multiple Data encountered (" + Integer.toString(data.size()) + " @ col " + Integer.toString(col) + " - " + cell.getTextContent() + " (" + s + "))");
        Element d = (Element)data.get(0);
        String type = d.getAttributeNS(XLS_NS, "Type");
        if ("Boolean".equals(type)) {
            if (d.getTextContent().equals("1")) {
                return "True";
            }
            return "False";
        }
        if ("String".equals(type)) {
            return d.getTextContent();
        }
        if ("Number".equals(type)) {
            return d.getTextContent();
        }
        if ("DateTime".equals(type)) {
            return d.getTextContent();
        }
        if ("Error".equals(type)) {
            return null;
        }
        throw new FHIRException("Cell Type is not known (" + d.getAttributeNodeNS(XLS_NS, "Type") + ") in " + this.getLocation());
    }

    private void check(boolean test, String message) throws FHIRException {
        if (!test) {
            throw new FHIRException(message + " in " + this.getLocation());
        }
    }

    private String getLocation() {
        return this.name + ", row " + this.rowIndex.toString();
    }

    public Map<String, Sheet> getSheets() {
        return this.sheets;
    }

    public class Sheet {
        public String title;
        public Row columns;
        public List<Row> rows = new ArrayList<Row>();

        public boolean hasColumn(String column) {
            for (int i = 0; i < this.columns.size(); ++i) {
                if (!((String)this.columns.get(i)).equalsIgnoreCase(column)) continue;
                return true;
            }
            return false;
        }

        public boolean hasColumn(int row, String column) {
            String s = this.getColumn(row, column);
            return s != null && !s.equals("");
        }

        public String getColumn(int row, String column) {
            int c = -1;
            String s = "";
            for (int i = 0; i < this.columns.size(); ++i) {
                s = s + "," + (String)this.columns.get(i);
                if (!((String)this.columns.get(i)).equalsIgnoreCase(column)) continue;
                c = i;
            }
            if (c == -1) {
                return "";
            }
            if (this.rows.get(row).size() <= c) {
                return "";
            }
            s = (String)this.rows.get(row).get(c);
            return s == null ? "" : s.trim();
        }

        public List<String> getColumnNamesBySuffix(String suffix) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < this.columns.size(); ++i) {
                if (!((String)this.columns.get(i)).endsWith(suffix)) continue;
                names.add((String)this.columns.get(i));
            }
            return names;
        }

        public String getByColumnPrefix(int row, String column) {
            int c = -1;
            String s = "";
            for (int i = 0; i < this.columns.size(); ++i) {
                s = s + "," + (String)this.columns.get(i);
                if (!((String)this.columns.get(i)).startsWith(column)) continue;
                c = i;
            }
            if (c == -1) {
                return "";
            }
            if (this.rows.get(row).size() <= c) {
                return "";
            }
            return ((String)this.rows.get(row).get(c)).trim();
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public int getIntColumn(int row, String column) {
            String value = this.getColumn(row, column);
            if (Utilities.noString(value)) {
                return 0;
            }
            return Integer.parseInt(value);
        }

        public String getNonEmptyColumn(int row, String column) throws FHIRException {
            String value = this.getColumn(row, column);
            if (Utilities.noString(value)) {
                throw new FHIRException("The colummn " + column + " cannot be empty");
            }
            return value;
        }

        public boolean hasColumnContent(String col) {
            int i = this.columns.indexOf(col);
            if (i == -1) {
                return false;
            }
            for (Row r : this.rows) {
                if (r.size() <= i || Utilities.noString((String)r.get(i))) continue;
                return true;
            }
            return false;
        }
    }

    public class Row
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }
}

