/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.CSFile;

public class TextFile {
    public static List<String> readAllLines(String path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        CSFile file = new CSFile(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while (reader.ready()) {
            result.add(reader.readLine());
        }
        reader.close();
        return result;
    }

    public static void writeAllLines(String path, List<String> lines) throws IOException {
        CSFile file = new CSFile(path);
        FileOutputStream s = new FileOutputStream(file);
        OutputStreamWriter sw = new OutputStreamWriter((OutputStream)s, "UTF-8");
        for (String line : lines) {
            sw.write(line + "\r\n");
        }
        sw.flush();
        s.close();
    }

    public static void stringToFile(String content, File file) throws IOException {
        OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        sw.write(65279);
        sw.write(content);
        sw.flush();
        sw.close();
    }

    public static byte[] stringToBytes(String content, boolean bom) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        OutputStreamWriter sw = new OutputStreamWriter((OutputStream)bs, "UTF-8");
        if (bom) {
            sw.write(65279);
        }
        sw.write(content);
        sw.flush();
        sw.close();
        return bs.toByteArray();
    }

    public static void stringToFile(String content, String path) throws IOException {
        CSFile file = new CSFile(path);
        TextFile.stringToFile(content, file);
    }

    public static void stringToFile(String content, File file, boolean bom) throws IOException {
        OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        if (bom) {
            sw.write(65279);
        }
        sw.write(content);
        sw.flush();
        sw.close();
    }

    public static void stringToFile(String content, String path, boolean bom) throws IOException {
        CSFile file = new CSFile(path);
        TextFile.stringToFile(content, file, bom);
    }

    public static void stringToFileNoPrefix(String content, String path) throws IOException {
        CSFile file = new CSFile(path);
        OutputStreamWriter sw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        sw.write(content);
        sw.flush();
        sw.close();
    }

    public static String fileToString(File f) throws FileNotFoundException, IOException {
        return TextFile.streamToString(new FileInputStream(f));
    }

    public static String fileToString(String src) throws FileNotFoundException, IOException {
        return TextFile.streamToString(new FileInputStream(new CSFile(src)));
    }

    public static String streamToString(InputStream input) throws IOException {
        InputStreamReader sr = new InputStreamReader(input, "UTF-8");
        StringBuilder b = new StringBuilder();
        int i = -1;
        while ((i = sr.read()) > -1) {
            char c = (char)i;
            b.append(c);
        }
        sr.close();
        return b.toString().replace("\ufeff", "");
    }

    public static byte[] streamToBytes(InputStream input) throws IOException {
        int i;
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream r = new ByteArrayOutputStream(2048);
        byte[] read = new byte[512];
        while (-1 != (i = input.read(read))) {
            r.write(read, 0, i);
        }
        input.close();
        return r.toByteArray();
    }

    public static void bytesToFile(byte[] bytes, String path) throws IOException {
        CSFile file = new CSFile(path);
        FileOutputStream sw = new FileOutputStream(file);
        ((OutputStream)sw).write(bytes);
        sw.flush();
        ((OutputStream)sw).close();
    }

    public static byte[] fileToBytes(String srcFile) throws FileNotFoundException, IOException {
        return TextFile.streamToBytes(new FileInputStream(new CSFile(srcFile)));
    }

    public static String bytesToString(byte[] bs) throws IOException {
        return TextFile.streamToString(new ByteArrayInputStream(bs));
    }
}

