/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.fhirpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.utils.FHIRPathEngine;

public class FhirPathR5
implements IFhirPath {
    private FHIRPathEngine myEngine;

    public FhirPathR5(FhirContext theCtx) {
        IValidationSupport validationSupport = theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(theCtx, validationSupport));
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        List result;
        try {
            result = this.myEngine.evaluate((Base)theInput, thePath);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)198) + (Object)((Object)e));
        }
        for (Base next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FhirPathExecutionException(Msg.code((int)199) + "FluentPath expression \"" + thePath + "\" returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }

    public void parse(String theExpression) {
        this.myEngine.parse(theExpression);
    }
}

