/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.ctx;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.hapi.fhirpath.FhirPathR5;
import org.hl7.fhir.r5.hapi.rest.server.R5BundleFactory;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;

public class FhirR5
implements IFhirVersion {
    private String myId;

    public IFhirPath createFhirPathExecutor(FhirContext theFhirContext) {
        return new FhirPathR5(theFhirContext);
    }

    public IBaseResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId((IIdType)new IdDt(this.myId));
        return retVal;
    }

    public Class<List> getContainedType() {
        return List.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        String path = "org/hl7/fhir/r5/model/fhirversion.properties";
        InputStream str = FhirR5.class.getResourceAsStream("/" + path);
        if (str == null) {
            str = FhirR5.class.getResourceAsStream(path);
        }
        if (str == null) {
            throw new ConfigurationException(Msg.code((int)200) + "Can not find model property file on classpath: " + path);
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/r5/model/schema";
    }

    public Class<? extends IBaseReference> getResourceReferenceType() {
        return Reference.class;
    }

    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType((String)"org.hl7.fhir.r5.hapi.ctx.FhirServerR5");
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.R5;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new R5BundleFactory(theContext);
    }

    public IBaseCoding newCodingDt() {
        return new Coding();
    }

    public IIdType newIdType() {
        return new IdType();
    }
}

