/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.ParserType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.utils.INarrativeGenerator;
import org.hl7.fhir.r4.utils.validation.IResourceValidator;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public final class HapiWorkerContext
extends I18nBase
implements IWorkerContext {
    private static final List<String> PRIMITIVE_TYPES = Arrays.asList("boolean", "integer", "integer64", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "uuid", "xhtml", "url", "canonical");
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private IValidationSupport myValidationSupport;
    private Parameters myExpansionProfile;
    private String myOverrideVersionNs;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = HapiSystemProperties.getValidationResourceCacheTimeoutMillis();
        this.myFetchedResourceCache = CacheFactory.build((long)timeoutMillis);
        this.setValidationMessageLanguage(this.getLocale());
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions();
    }

    public List<StructureDefinition> getStructures() {
        return this.allStructures();
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (CodeSystem)this.myValidationSupport.fetchCodeSystem(theSystem);
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException(Msg.code((int)258));
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException(Msg.code((int)259));
    }

    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException(Msg.code((int)260));
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException(Msg.code((int)261));
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException(Msg.code((int)262));
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException(Msg.code((int)263));
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException(Msg.code((int)264));
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException(Msg.code((int)265));
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException(Msg.code((int)266));
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(new ValidationSupportContext(this.myValidationSupport), theSystem);
    }

    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(theOptions, system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        ValidationMessage.IssueSeverity severity = null;
        if (result.getSeverity() != null) {
            severity = ValidationMessage.IssueSeverity.fromCode((String)result.getSeverityCode());
        }
        CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent().setCode(result.getCode());
        return new IWorkerContext.ValidationResult(severity, result.getMessage(), definition);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException(Msg.code((int)267));
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        IValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(new ValidationSupportContext(this.myValidationSupport), HapiWorkerContext.convertConceptValidationOptions(theOptions), theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet vs) {
        ValidationOptions options = theOptions.withGuessSystem();
        return this.validateCode(options, null, code, null, vs);
    }

    @CoverageIgnore
    public List<MetadataResource> allConformanceResources() {
        throw new UnsupportedOperationException(Msg.code((int)268));
    }

    public void generateSnapshot(StructureDefinition p) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)269));
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(Parameters theExpParameters) {
        this.myExpansionProfile = theExpParameters;
    }

    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException(Msg.code((int)270));
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHierarchical) {
        throw new UnsupportedOperationException(Msg.code((int)271));
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent theInc, boolean theHierarchical) throws TerminologyServiceException {
        ValueSet input = new ValueSet();
        input.getCompose().addInclude(theInc);
        IValidationSupport.ValueSetExpansionOutcome output = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), null, (IBaseResource)input);
        return new ValueSetExpander.ValueSetExpansionOutcome((ValueSet)output.getValueSet(), output.getError(), null);
    }

    public IWorkerContext.ILoggingService getLogger() {
        throw new UnsupportedOperationException(Msg.code((int)272));
    }

    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException(Msg.code((int)273));
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException(Msg.code((int)274));
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException(Msg.code((int)275));
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public TranslationServices translator() {
        throw new UnsupportedOperationException(Msg.code((int)276));
    }

    public List<StructureMap> listTransforms() {
        throw new UnsupportedOperationException(Msg.code((int)277));
    }

    public StructureMap getTransform(String url) {
        throw new UnsupportedOperationException(Msg.code((int)278));
    }

    public String getOverrideVersionNs() {
        return this.myOverrideVersionNs;
    }

    public void setOverrideVersionNs(String value) {
        this.myOverrideVersionNs = value;
    }

    public StructureDefinition fetchTypeDefinition(String theTypeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + theTypeName);
    }

    public List<StructureDefinition> fetchTypeDefinitions(String input) {
        ArrayList<StructureDefinition> types = new ArrayList<StructureDefinition>();
        for (StructureDefinition sd : this.allStructures()) {
            if (!input.equals(sd.getTypeTail())) continue;
            types.add(sd);
        }
        return types;
    }

    public String getLinkForUrl(String corePath, String url) {
        throw new UnsupportedOperationException(Msg.code((int)279));
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException(Msg.code((int)280));
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null || theUri == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(theClass, theUri));
        return (T)retVal;
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri, String theVersion) {
        return this.fetchResource(theClass, theUri + "|" + theVersion);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri, Resource resource) {
        return this.fetchResource(theClass, theUri);
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass, theUri);
        if (retVal == null) {
            throw new FHIRException(Msg.code((int)281) + "Could not find resource: " + theUri);
        }
        return retVal;
    }

    public <T extends Resource> List<T> fetchResourcesByType(Class<T> aClass) {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        if (aClass == StructureDefinition.class) {
            res.addAll(this.getStructures());
        }
        return res;
    }

    public Resource fetchResourceById(String theType, String theUri) {
        throw new UnsupportedOperationException(Msg.code((int)282));
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException(Msg.code((int)283));
    }

    public void cacheResource(Resource theRes) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)284));
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myCtx.getResourceTypes();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent theBinding, boolean theCacheOk, boolean theHierarchical) throws FHIRException {
        throw new UnsupportedOperationException(Msg.code((int)285));
    }

    public static ConceptValidationOptions convertConceptValidationOptions(ValidationOptions theOptions) {
        ConceptValidationOptions retVal = new ConceptValidationOptions();
        if (theOptions.isGuessSystem()) {
            retVal = retVal.setInferSystem(true);
        }
        return retVal;
    }

    public boolean isPrimitiveType(String theType) {
        return PRIMITIVE_TYPES.contains(theType);
    }
}

