/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.hl7.fhir.r4.model.ExpansionProfile;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetChecker;

public interface ValueSetExpander {
    public ValueSetExpansionOutcome expand(ValueSet var1, ExpansionProfile var2) throws ETooCostly, FileNotFoundException, IOException;

    public static class ValueSetExpansionOutcome {
        private ValueSet valueset;
        private ValueSetChecker service;
        private String error;
        private TerminologyServiceErrorClass errorClass;

        public ValueSetExpansionOutcome(ValueSet valueset) {
            this.valueset = valueset;
            this.service = null;
            this.error = null;
        }

        public ValueSetExpansionOutcome(ValueSet valueset, String error, TerminologyServiceErrorClass errorClass) {
            this.valueset = valueset;
            this.service = null;
            this.error = error;
            this.errorClass = errorClass;
        }

        public ValueSetExpansionOutcome(ValueSetChecker service, String error, TerminologyServiceErrorClass errorClass) {
            this.valueset = null;
            this.service = service;
            this.error = error;
            this.errorClass = errorClass;
        }

        public ValueSetExpansionOutcome(String error, TerminologyServiceErrorClass errorClass) {
            this.valueset = null;
            this.service = null;
            this.error = error;
            this.errorClass = errorClass;
        }

        public ValueSet getValueset() {
            return this.valueset;
        }

        public ValueSetChecker getService() {
            return this.service;
        }

        public String getError() {
            return this.error;
        }

        public TerminologyServiceErrorClass getErrorClass() {
            return this.errorClass;
        }
    }

    public static class ETooCostly
    extends Exception {
        public ETooCostly(String msg) {
            super(msg);
        }
    }

    public static enum TerminologyServiceErrorClass {
        UNKNOWN,
        NOSERVICE,
        SERVER_ERROR,
        VALUESET_UNSUPPORTED;


        public boolean isInfrastructure() {
            return this == NOSERVICE || this == SERVER_ERROR || this == VALUESET_UNSUPPORTED;
        }
    }
}

