/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3DocumentStorage {
    AC,
    AA,
    AR,
    PU,
    NULL;


    public static V3DocumentStorage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AC".equals(codeString)) {
            return AC;
        }
        if ("AA".equals(codeString)) {
            return AA;
        }
        if ("AR".equals(codeString)) {
            return AR;
        }
        if ("PU".equals(codeString)) {
            return PU;
        }
        throw new FHIRException("Unknown V3DocumentStorage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AC: {
                return "AC";
            }
            case AA: {
                return "AA";
            }
            case AR: {
                return "AR";
            }
            case PU: {
                return "PU";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/DocumentStorage";
    }

    public String getDefinition() {
        switch (this) {
            case AC: {
                return "A storage status in which a document is available on-line.";
            }
            case AA: {
                return "A storage status in which a document is available on-line and is also stored off-line for long-term access.";
            }
            case AR: {
                return "A storage status in which a document has been stored off-line for long-term access.";
            }
            case PU: {
                return "A storage status in which a document is no longer available in this system.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AC: {
                return "active";
            }
            case AA: {
                return "active and archived";
            }
            case AR: {
                return "archived (not active)";
            }
            case PU: {
                return "purged";
            }
        }
        return "?";
    }
}

