/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum UsersessionStatus {
    ACTIVATING,
    ACTIVE,
    SUSPENDED,
    CLOSING,
    CLOSED,
    NULL;


    public static UsersessionStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("activating".equals(codeString)) {
            return ACTIVATING;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("closing".equals(codeString)) {
            return CLOSING;
        }
        if ("closed".equals(codeString)) {
            return CLOSED;
        }
        throw new FHIRException("Unknown UsersessionStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVATING: {
                return "activating";
            }
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case CLOSING: {
                return "closing";
            }
            case CLOSED: {
                return "closed";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/usersession-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVATING: {
                return "The user session is activating";
            }
            case ACTIVE: {
                return "The user session is active";
            }
            case SUSPENDED: {
                return "The user session is suspended";
            }
            case CLOSING: {
                return "The user session is closing";
            }
            case CLOSED: {
                return "The user session is closed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVATING: {
                return "Activating";
            }
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspending";
            }
            case CLOSING: {
                return "Closing";
            }
            case CLOSED: {
                return "Closed";
            }
        }
        return "?";
    }
}

