/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SystemVersionProcessingMode {
    DEFAULT,
    CHECK,
    OVERRIDE,
    NULL;


    public static SystemVersionProcessingMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("default".equals(codeString)) {
            return DEFAULT;
        }
        if ("check".equals(codeString)) {
            return CHECK;
        }
        if ("override".equals(codeString)) {
            return OVERRIDE;
        }
        throw new FHIRException("Unknown SystemVersionProcessingMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DEFAULT: {
                return "default";
            }
            case CHECK: {
                return "check";
            }
            case OVERRIDE: {
                return "override";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/system-version-processing-mode";
    }

    public String getDefinition() {
        switch (this) {
            case DEFAULT: {
                return "Use this version of the code system if a value set doesn't specify a version";
            }
            case CHECK: {
                return "Use this version of the code system. If a value set specifies a different version, the expansion operation should fail";
            }
            case OVERRIDE: {
                return "Use this version of the code system irrespective of which version is specified by a value set. Note that this has obvious safety issues, in that it may result in a value set expansion giving a different list of codes that is both wrong and unsafe, and implementers should only use this capability reluctantly. It primarily exists to deal with situations where specifications have fallen into decay as time passes. If the value is override, the version used SHALL explicitly be represented in the expansion parameters";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DEFAULT: {
                return "Default Version";
            }
            case CHECK: {
                return "Check ValueSet Version";
            }
            case OVERRIDE: {
                return "Override ValueSet Version";
            }
        }
        return "?";
    }
}

