/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SupplydeliveryType {
    MEDICATION,
    DEVICE,
    NULL;


    public static SupplydeliveryType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("device".equals(codeString)) {
            return DEVICE;
        }
        throw new FHIRException("Unknown SupplydeliveryType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MEDICATION: {
                return "medication";
            }
            case DEVICE: {
                return "device";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supply-item-type";
    }

    public String getDefinition() {
        switch (this) {
            case MEDICATION: {
                return "Supply is a kind of medication.";
            }
            case DEVICE: {
                return "What is supplied (or requested) is a device.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MEDICATION: {
                return "Medication";
            }
            case DEVICE: {
                return "Device";
            }
        }
        return "?";
    }
}

