/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Status {
    ATTESTED,
    VALIDATED,
    INPROCESS,
    REQREVALID,
    VALFAIL,
    REVALFAIL,
    NULL;


    public static Status fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("attested".equals(codeString)) {
            return ATTESTED;
        }
        if ("validated".equals(codeString)) {
            return VALIDATED;
        }
        if ("in-process".equals(codeString)) {
            return INPROCESS;
        }
        if ("req-revalid".equals(codeString)) {
            return REQREVALID;
        }
        if ("val-fail".equals(codeString)) {
            return VALFAIL;
        }
        if ("reval-fail".equals(codeString)) {
            return REVALFAIL;
        }
        throw new FHIRException("Unknown Status code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ATTESTED: {
                return "attested";
            }
            case VALIDATED: {
                return "validated";
            }
            case INPROCESS: {
                return "in-process";
            }
            case REQREVALID: {
                return "req-revalid";
            }
            case VALFAIL: {
                return "val-fail";
            }
            case REVALFAIL: {
                return "reval-fail";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/status";
    }

    public String getDefinition() {
        switch (this) {
            case ATTESTED: {
                return "";
            }
            case VALIDATED: {
                return "";
            }
            case INPROCESS: {
                return "";
            }
            case REQREVALID: {
                return "";
            }
            case VALFAIL: {
                return "";
            }
            case REVALFAIL: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ATTESTED: {
                return "Attested";
            }
            case VALIDATED: {
                return "Validated";
            }
            case INPROCESS: {
                return "In process";
            }
            case REQREVALID: {
                return "Requires revalidation";
            }
            case VALFAIL: {
                return "Validation failed";
            }
            case REVALFAIL: {
                return "Re-Validation failed";
            }
        }
        return "?";
    }
}

