/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ReactionEventCertainty {
    UNLIKELY,
    LIKELY,
    CONFIRMED,
    UNKNOWN,
    NULL;


    public static ReactionEventCertainty fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unlikely".equals(codeString)) {
            return UNLIKELY;
        }
        if ("likely".equals(codeString)) {
            return LIKELY;
        }
        if ("confirmed".equals(codeString)) {
            return CONFIRMED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ReactionEventCertainty code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNLIKELY: {
                return "unlikely";
            }
            case LIKELY: {
                return "likely";
            }
            case CONFIRMED: {
                return "confirmed";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/reaction-event-certainty";
    }

    public String getDefinition() {
        switch (this) {
            case UNLIKELY: {
                return "There is a low level of clinical certainty that the reaction was caused by the identified substance.";
            }
            case LIKELY: {
                return "There is a high level of clinical certainty that the reaction was caused by the identified substance.";
            }
            case CONFIRMED: {
                return "There is a very high level of clinical certainty that the reaction was due to the identified substance, which may include clinical evidence by testing or rechallenge.";
            }
            case UNKNOWN: {
                return "The clinical certainty that the reaction was caused by the identified substance is unknown.  It is an explicit assertion that certainty is not known.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNLIKELY: {
                return "Unlikely";
            }
            case LIKELY: {
                return "Likely";
            }
            case CONFIRMED: {
                return "Confirmed";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

