/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ProductplanType;

public class ProductplanTypeEnumFactory
implements EnumFactory<ProductplanType> {
    @Override
    public ProductplanType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("medical".equals(codeString)) {
            return ProductplanType.MEDICAL;
        }
        if ("dental".equals(codeString)) {
            return ProductplanType.DENTAL;
        }
        if ("mental".equals(codeString)) {
            return ProductplanType.MENTAL;
        }
        if ("subst-ab".equals(codeString)) {
            return ProductplanType.SUBSTAB;
        }
        if ("vision".equals(codeString)) {
            return ProductplanType.VISION;
        }
        if ("Drug".equals(codeString)) {
            return ProductplanType.DRUG;
        }
        if ("short-term".equals(codeString)) {
            return ProductplanType.SHORTTERM;
        }
        if ("long-term".equals(codeString)) {
            return ProductplanType.LONGTERM;
        }
        if ("hospice".equals(codeString)) {
            return ProductplanType.HOSPICE;
        }
        if ("home".equals(codeString)) {
            return ProductplanType.HOME;
        }
        throw new IllegalArgumentException("Unknown ProductplanType code '" + codeString + "'");
    }

    @Override
    public String toCode(ProductplanType code) {
        if (code == ProductplanType.MEDICAL) {
            return "medical";
        }
        if (code == ProductplanType.DENTAL) {
            return "dental";
        }
        if (code == ProductplanType.MENTAL) {
            return "mental";
        }
        if (code == ProductplanType.SUBSTAB) {
            return "subst-ab";
        }
        if (code == ProductplanType.VISION) {
            return "vision";
        }
        if (code == ProductplanType.DRUG) {
            return "Drug";
        }
        if (code == ProductplanType.SHORTTERM) {
            return "short-term";
        }
        if (code == ProductplanType.LONGTERM) {
            return "long-term";
        }
        if (code == ProductplanType.HOSPICE) {
            return "hospice";
        }
        if (code == ProductplanType.HOME) {
            return "home";
        }
        return "?";
    }

    @Override
    public String toSystem(ProductplanType code) {
        return code.getSystem();
    }
}

