/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PaymentType {
    PAYMENT,
    ADJUSTMENT,
    ADVANCE,
    NULL;


    public static PaymentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("payment".equals(codeString)) {
            return PAYMENT;
        }
        if ("adjustment".equals(codeString)) {
            return ADJUSTMENT;
        }
        if ("advance".equals(codeString)) {
            return ADVANCE;
        }
        throw new FHIRException("Unknown PaymentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PAYMENT: {
                return "payment";
            }
            case ADJUSTMENT: {
                return "adjustment";
            }
            case ADVANCE: {
                return "advance";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/payment-type";
    }

    public String getDefinition() {
        switch (this) {
            case PAYMENT: {
                return "The amount is partial or complete settlement of the amounts due.";
            }
            case ADJUSTMENT: {
                return "The amount is an adjustment regarding claims already paid.";
            }
            case ADVANCE: {
                return "The amount is an advance against future claims.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PAYMENT: {
                return "Payment";
            }
            case ADJUSTMENT: {
                return "Adjustment";
            }
            case ADVANCE: {
                return "Advance";
            }
        }
        return "?";
    }
}

