/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PaymentAdjustmentReason {
    A001,
    A002,
    NULL;


    public static PaymentAdjustmentReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("a001".equals(codeString)) {
            return A001;
        }
        if ("a002".equals(codeString)) {
            return A002;
        }
        throw new FHIRException("Unknown PaymentAdjustmentReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A001: {
                return "a001";
            }
            case A002: {
                return "a002";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/payment-adjustment-reason";
    }

    public String getDefinition() {
        switch (this) {
            case A001: {
                return "Prior Payment Reversal";
            }
            case A002: {
                return "Prior Overpayment";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A001: {
                return "Prior Payment Reversal";
            }
            case A002: {
                return "Prior Overpayment";
            }
        }
        return "?";
    }
}

