/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationKnowledgeCharacter {
    IMPRINTCD,
    SIZE,
    SHAPE,
    COLOR,
    COATING,
    SCORING,
    LOGO,
    NULL;


    public static MedicationKnowledgeCharacter fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("imprintcd".equals(codeString)) {
            return IMPRINTCD;
        }
        if ("size".equals(codeString)) {
            return SIZE;
        }
        if ("shape".equals(codeString)) {
            return SHAPE;
        }
        if ("color".equals(codeString)) {
            return COLOR;
        }
        if ("coating".equals(codeString)) {
            return COATING;
        }
        if ("scoring".equals(codeString)) {
            return SCORING;
        }
        if ("logo".equals(codeString)) {
            return LOGO;
        }
        throw new FHIRException("Unknown MedicationKnowledgeCharacter code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case IMPRINTCD: {
                return "imprintcd";
            }
            case SIZE: {
                return "size";
            }
            case SHAPE: {
                return "shape";
            }
            case COLOR: {
                return "color";
            }
            case COATING: {
                return "coating";
            }
            case SCORING: {
                return "scoring";
            }
            case LOGO: {
                return "logo";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medicationKnowledge-character";
    }

    public String getDefinition() {
        switch (this) {
            case IMPRINTCD: {
                return "Identyifying marks on product";
            }
            case SIZE: {
                return "Description of size of the product";
            }
            case SHAPE: {
                return "Description of shape of the product";
            }
            case COLOR: {
                return "Description of color of the product";
            }
            case COATING: {
                return "Description of coating of the product";
            }
            case SCORING: {
                return "Description of scoring of the product";
            }
            case LOGO: {
                return "Description of logo of the product";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case IMPRINTCD: {
                return "Imprint Code";
            }
            case SIZE: {
                return "Size";
            }
            case SHAPE: {
                return "Shape";
            }
            case COLOR: {
                return "Color";
            }
            case COATING: {
                return "Coating";
            }
            case SCORING: {
                return "Scoring";
            }
            case LOGO: {
                return "Logo";
            }
        }
        return "?";
    }
}

